/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.slack;

import com.slack.api.model.Attachment;

public class SlackMessageDTO {
    private String title;
    private String titleLink;
    private String authorName;
    private String text;
    private String footer;

    private SlackMessageDTO(String title, String titleLink, String authorName, String text, String footer) {
        this.title = title;
        this.titleLink = titleLink;
        this.authorName = authorName;
        this.text = text;
        this.footer = footer;
    }

    public Attachment parseAttachment() {
        return Attachment.builder().title(this.title).titleLink(this.titleLink).authorName(this.authorName).text(this.text).footer(this.footer).build();
    }

    public static SlackMessageDTOBuilder builder() {
        return new SlackMessageDTOBuilder();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleLink(String titleLink) {
        this.titleLink = titleLink;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleLink() {
        return this.titleLink;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getText() {
        return this.text;
    }

    public String getFooter() {
        return this.footer;
    }

    public static class SlackMessageDTOBuilder {
        private String title;
        private String titleLink;
        private String authorName;
        private String text;
        private String footer;

        SlackMessageDTOBuilder() {
        }

        public SlackMessageDTOBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SlackMessageDTOBuilder titleLink(String titleLink) {
            this.titleLink = titleLink;
            return this;
        }

        public SlackMessageDTOBuilder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public SlackMessageDTOBuilder text(String text) {
            this.text = text;
            return this;
        }

        public SlackMessageDTOBuilder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public SlackMessageDTO build() {
            return new SlackMessageDTO(this.title, this.titleLink, this.authorName, this.text, this.footer);
        }

        public String toString() {
            return "SlackMessageDTO.SlackMessageDTOBuilder(title=" + this.title + ", titleLink=" + this.titleLink + ", authorName=" + this.authorName + ", text=" + this.text + ", footer=" + this.footer + ")";
        }
    }
}

