/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.aspect;

import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Aspect
@Component
public class SessionParamAdvice {
    private static final Logger log = LoggerFactory.getLogger(SessionParamAdvice.class);
    private final SlackNotificationService slackNotificationService;
    private final String appName;

    public SessionParamAdvice(SlackNotificationService slackNotificationService, @Value(value="${spring.application.name}") String appName) {
        this.slackNotificationService = slackNotificationService;
        this.appName = appName;
    }

    @Around(value="execution(* com.arms..controller.*.*(..))")
    public Object sessionParam(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        ServerWebExchange exchange = Arrays.stream(args).filter(a -> a instanceof ServerWebExchange).findFirst().orElse(null);
        String methodName = Arrays.stream(joinPoint.getSignature().toLongString().split(" ")).skip(1L).collect(Collectors.joining(" "));
        try {
            Object proceed = joinPoint.proceed();
            return proceed;
        }
        catch (Exception e) {
            this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.middleproxy, e);
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            String parameters = Arrays.stream(args).map(String::valueOf).collect(Collectors.joining("\t"));
            Optional.ofNullable(exchange).ifPresentOrElse(a -> a.getSession().flatMap(session -> {
                log.error("{} Error \ubc1c\uc0dd\tmethodName : {}\tsession    : {}\tparameter   : {}\terrorMsg    : {}", new Object[]{this.appName, methodName, session.getId(), parameters, errors});
                return Mono.empty();
            }).subscribe(), () -> log.error("{} Error \ubc1c\uc0dd\tmethodName : {}\tparameter   : {}\terrorMsg    : {}", new Object[]{this.appName, methodName, parameters, errors}));
            throw e;
        }
    }
}

