package com.arms.egovframework.javaservice.esframework.model.dto.esquery;

import lombok.*;

@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class SubGroupFieldDTO {

    private String subFieldAlias;

    private String subField;

    private boolean isAscending;

    private int size;

    public static SubGroupFieldDTOBuilder builder() {
        return new SubGroupFieldDTOBuilder();
    }

    public static class SubGroupFieldDTOBuilder {
        private String subFieldAlias;
        private String subField;
        private boolean isAscending = false;
        private int size = 10000;

        public SubGroupFieldDTOBuilder subFieldAlias(String subFieldAlias) {
            this.subFieldAlias = subFieldAlias;
            return this;
        }

        public SubGroupFieldDTOBuilder subField(String subField) {
            this.subField = subField;
            return this;
        }

        public SubGroupFieldDTOBuilder isAscending(boolean isAscending) {
            this.isAscending = isAscending;
            return this;
        }

        public SubGroupFieldDTOBuilder size(int size) {
            this.size = size;
            return this;
        }

        public SubGroupFieldDTO build() {
            SubGroupFieldDTO dto = new SubGroupFieldDTO();
            dto.setSubFieldAlias(this.subFieldAlias);
            dto.setSubField(this.subField);
            dto.setAscending(this.isAscending);
            dto.setSize(this.size);
            return dto;
        }
    }
}
