package com.arms.egovframework.javaservice.esframework.model.dto.esquery;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class HighlightDTO {

    private List<String> fields;

    private String preTags;

    private String postTags;

    public static HighlightDTOBuilder builder() {
        return new HighlightDTOBuilder();
    }

    public static class HighlightDTOBuilder {
        private List<String> fields;
        private String preTags;
        private String postTags;

        public HighlightDTOBuilder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public HighlightDTOBuilder preTags(String preTags) {
            this.preTags = preTags;
            return this;
        }

        public HighlightDTOBuilder postTags(String postTags) {
            this.postTags = postTags;
            return this;
        }

        public HighlightDTO build() {
            HighlightDTO dto = new HighlightDTO();
            dto.setFields(this.fields);
            dto.setPreTags(this.preTags);
            dto.setPostTags(this.postTags);
            return dto;
        }
    }
}
