package com.arms.egovframework.javaservice.esframework.factory;

import com.arms.egovframework.javaservice.esframework.factory.builder.SearchQueryBuilder;
import com.arms.egovframework.javaservice.esframework.factory.builder.AbstractQueryBuilder;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;

import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import lombok.Getter;
import lombok.Setter;
import org.opensearch.data.client.orhlc.NativeSearchQuery;

@Setter
@Getter
public class SearchDocQueryFactory implements AbstractQueryBuilder<NativeSearchQuery> {

	private final AbstractQueryBuilder<NativeSearchQuery> abstractQueryBuilder;

	private SearchDocQueryFactory(AbstractQueryBuilder<NativeSearchQuery> abstractQueryBuilder) {
		this.abstractQueryBuilder = abstractQueryBuilder;
	}

	public static AbstractQueryBuilder<NativeSearchQuery> searchDoc(SearchDocDTO searchDocDTO){
		return new SearchDocQueryFactory(SearchQueryBuilder.of(searchDocDTO, searchDocDTO.getEsQuery()));
	}

	@Override
	public NativeSearchQuery create() {
		return abstractQueryBuilder.create();
	}

	@Override
	public NativeSearchQuery createForRecentTrue(Class<? extends BaseEntity> entityClass) {
		return abstractQueryBuilder.createForRecentTrue(entityClass);
	}


}
