package com.arms.egovframework.javaservice.esframework.esquery.highlight;

import com.arms.egovframework.javaservice.esframework.esquery.EsQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.HighlightDTO;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;

import java.util.List;


public class EsHighlightQuery extends EsQuery {

	private final HighlightBuilder highlightBuilder = new HighlightBuilder();

	private EsHighlightQuery(){}

	public static EsHighlightQuery esHighlightAll(){
		HighlightDTO highlightDTO = HighlightDTO
				.builder()
				.fields(List.of("*"))
				.preTags("<em>")
				.postTags("</em>")
				.build();
		return new EsHighlightQuery(highlightDTO);
	}

	public EsHighlightQuery(HighlightDTO highlightDTO){
		highlightDTO.getFields().forEach(
			a-> highlightBuilder.field(String.valueOf(a))
		);
		highlightBuilder
			.preTags(highlightDTO.getPreTags())
			.postTags(highlightDTO.getPostTags());
	}

	public HighlightBuilder highlight() {
		return this.highlightBuilder;
	}
}
