package com.arms.api.wiki.model;

import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;
import java.util.Optional;

@Getter
@Setter
public class WikiDTO extends SearchRequestDTO {

    private String id;

    private String contents;

    private String wikiId;

    private boolean recent;

    private Long version;

    private List<String> diagramXmls;

    private String pdServiceId;

    private String author;

    private Date createdDate;

    private Date updatedDate;

    public WikiEntity createEntity() {
        return WikiEntity.builder()
                .wikiId(this.wikiId)
                .contents(this.contents)
                .author(this.author)
                .version(Optional.ofNullable(this.version).orElse(0L))
                .pdServiceId(this.pdServiceId)
                .createdDate(this.createdDate)
                .updatedDate(this.updatedDate)
                .build();
    }

    public WikiEntity createEntityWithVersionUp(Long version) {
        this.version = version + 1L;
        return createEntity();
    }
}
