package com.arms.api.util;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/*
	ApplicationContextAware를 사용할때에는 순환참조를 사용 하는게 아닌지 반드시 확인해야한다.
*/
@Component
public class ApplicationContextProvider implements ApplicationContextAware {

    @Getter
    private static final ApplicationContextWrapper applicationContextWrapper = new ApplicationContextWrapper();

    @Override
    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        applicationContextWrapper.setApplicationContext(ctx);
    }

    public static <T> T getBean(Class<T> t){
        return applicationContextWrapper.getBean(t);
    }

    @Setter
    private static class ApplicationContextWrapper{

        private ApplicationContext applicationContext;

        public <T> T getBean(Class<T> t){
            return applicationContext.getBean(t);
        }
    }

}
