package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.CloudJiraIssueRawDataVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;



@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
@Getter
@Slf4j
@EqualsAndHashCode(of = {"cloudJiraIssueRawDataVO"})
public class CloudJiraIssueVO {

    private CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO;

    private ServerInfo serverInfo;

    private AlmIssueWithRequirementDTO almIssueWithRequirementDTO;

    private boolean excludeFromSave;

    private List<Long> linkedIssuePdServiceIds;

    private List<Long> linkedIssuePdServiceVersions;

    public AlmIssueVO toAlmIssueVOByStateCategory(String armsStateCategory){
         return AlmIssueVO.builder()
                    .upperKey(cloudJiraIssueRawDataVO.getParentKey())
                    .id(cloudJiraIssueRawDataVO.getId())
                    .self(cloudJiraIssueRawDataVO.getSelf())
                    .key(cloudJiraIssueRawDataVO.getKey())
                    .fields(cloudJiraIssueRawDataVO.getFields())
                    .rawData(cloudJiraIssueRawDataVO.getRawData())
                    .almIssueWithRequirementDTO(almIssueWithRequirementDTO)
                    .excludeFromSave(excludeFromSave)
                    .linkedIssue(relationRecentIds())
                    .armsStateCategory(armsStateCategory)
                    .linkedIssuePdServiceIds(linkedIssuePdServiceIds)
                    .linkedIssuePdServiceVersions(linkedIssuePdServiceVersions)
                .build();
    }

    public AlmIssueVO toAlmIssueVO() {
        return AlmIssueVO.builder()
                .upperKey(cloudJiraIssueRawDataVO.getParentKey())
                .id(cloudJiraIssueRawDataVO.getId())
                .self(cloudJiraIssueRawDataVO.getSelf())
                .key(cloudJiraIssueRawDataVO.getKey())
                .fields(cloudJiraIssueRawDataVO.getFields())
                .rawData(cloudJiraIssueRawDataVO.getRawData())
                .build();
    }

    public IssueFieldData cloudJiraIssueField(){
        return cloudJiraIssueRawDataVO.getFields();
    }

    public String recentId(){
        return this.serverInfo.getConnectId() +"_"+ cloudJiraIssueRawDataVO.getFields().getProject().getKey()+"_"+ cloudJiraIssueRawDataVO.getKey();
    }

    public String recentId(String key){
        return this.serverInfo.getConnectId() +"_"+ cloudJiraIssueRawDataVO.getFields().getProject().getKey()+"_"+key;
    }

    public CloudJiraIssueVO markAsExcludedFromSave(){
        return CloudJiraIssueVO.builder()
                .cloudJiraIssueRawDataVO(this.cloudJiraIssueRawDataVO)
                .serverInfo(this.serverInfo)
                .almIssueWithRequirementDTO(this.almIssueWithRequirementDTO)
                .excludeFromSave(true)
                .build();
    }

    public CloudJiraIssueVO appliedLinkedIssuePdServiceElement(List<AlmIssueWithRequirementDTO> almIssueWithRequirementDTOS){

        return CloudJiraIssueVO.builder()
                .cloudJiraIssueRawDataVO(this.cloudJiraIssueRawDataVO)
                .serverInfo(this.serverInfo)
                .almIssueWithRequirementDTO(
                    almIssueWithRequirementDTOS
                        .stream()
                        .filter(a->{
                            if(a.getIssueKey()==null){
                                System.out.println(a);
                            }
                            return a.getIssueKey().equals(cloudJiraIssueRawDataVO.getKey());
                        })
                        .findFirst()
                        .orElseGet(()->this.almIssueWithRequirementDTO)
                )
                .linkedIssuePdServiceIds(almIssueWithRequirementDTOS.stream().map(AlmIssueWithRequirementDTO::getServiceId).toList())
                .linkedIssuePdServiceVersions(almIssueWithRequirementDTOS.stream().flatMap(a->a.getVersions().stream()).toList())
                .excludeFromSave(this.excludeFromSave)
                .build();
    }

    public Set<String> relationRecentIds(){

        List<IssueLink> issueRelations = cloudJiraIssueRawDataVO.getFields().getIssuelinks();

        Set<String> set = issueRelations
                .stream()
                .filter(a -> !ObjectUtils.isEmpty(a.getInwardIssue()))
                .map(a -> {
                    String projectKey = Arrays.stream(a.getInwardIssue().getKey().split("-")).findFirst().orElseGet(() -> almIssueWithRequirementDTO.getProjectKeyOrId());
                    return almIssueWithRequirementDTO.extractIssueKeyFromMainKey(projectKey, a.getInwardIssue().getKey());
                })
                .collect(Collectors.toSet());


        set.addAll(issueRelations
                .stream()
                .filter(a -> !ObjectUtils.isEmpty(a.getOutwardIssue()))
                .map(a -> {
                    String projectKey = Arrays.stream(a.getOutwardIssue().getKey().split("-")).findFirst().orElseGet(() -> almIssueWithRequirementDTO.getProjectKeyOrId());
                    return almIssueWithRequirementDTO.extractIssueKeyFromMainKey(projectKey, a.getOutwardIssue().getKey());
                })
                .collect(Collectors.toSet()));

        return set;

    }

}
