package com.arms.api.issue.almapi.model.dto;

import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.type.dto.IssueTypeDTO;
import com.arms.api.project.dto.ProjectDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;

import java.util.List;

@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CloudJiraIssueFieldDTO {

    private ProjectDTO project;

    private IssueTypeDTO issuetype;

    private String summary;

    private 내용 description;

    private UserData reporter;

    private UserData assignee;

    private List<String> labels;

    private IssuePriorityDTO priority;

    private String duedate;

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 내용 {
        private List<콘텐츠> content;
        private String type;
        private Integer version;
    }

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 콘텐츠 {
        private List<콘텐츠_아이템> content;
        private String type;
    }

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 콘텐츠_아이템 {
        private String text;
        private String type;
        private List<마크> marks;
    }

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 마크 {
        private String type;
        private 마크_속성 attrs;
    }

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class 마크_속성 {
        private String href;
    }

}
