package com.arms.api.admin.indexstatus.model.vo;


import com.arms.egovframework.javaservice.esframework.model.entity.IndexStatusEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

import java.util.List;
import java.util.Map;

import static com.arms.egovframework.javaservice.esframework.model.entity.JobStatus.AFTER;
import static com.arms.egovframework.javaservice.esframework.model.entity.JobStatus.BEFORE;

@AllArgsConstructor
@Builder
@Getter
public class IndexStatusWithJobIdVO {

    private IndexStatusVO beforeIndexStatusVO;

    private IndexStatusVO afterIndexStatusVO;

    public IndexStatusWithJobIdVO(Map.Entry<String, List<IndexStatusEntity>> listEntry){

        for (IndexStatusEntity indexStatusEntity : listEntry.getValue()) {
            if (BEFORE.equals(indexStatusEntity.getJobStatus())) {
                this.beforeIndexStatusVO = IndexStatusVO.builder()
                        .indexName(listEntry.getKey())
                        .timestamp(indexStatusEntity.getTimestamp())
                        .docsCount(indexStatusEntity.getDocsCount())
                        .build();
            } else if (AFTER.equals(indexStatusEntity.getJobStatus())) {
                this.afterIndexStatusVO = IndexStatusVO.builder()
                        .indexName(listEntry.getKey())
                        .timestamp(indexStatusEntity.getTimestamp())
                        .docsCount(indexStatusEntity.getDocsCount())
                        .build();
            }
        }
    }


}
