package com.arms.api.account.strategy;

import com.arms.api.account.model.AlmAccount;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
public class OnPromiseJiraAccountStrategy implements AccountStrategy {

    private final Logger 로그 = LoggerFactory.getLogger(this.getClass());

    private final ServerInfoService serverInfoService;

    private final JiraUtil jiraUtil;

    @Autowired
    public OnPromiseJiraAccountStrategy(ServerInfoService ServerInfoService, JiraUtil JiraUtil) {
        this.serverInfoService = ServerInfoService;
        this.jiraUtil = JiraUtil;
    }

    @Override
    public AlmAccount verifyAccount(ServerInfo serverInfo){
        로그.info("온프라미스_지라_계정전략 :: 계정정보_검증");
        return 계정정보_조회(serverInfo);
    }

    @Override
    public AlmAccount getAccount(String connectId){
        로그.info("온프라미스_지라_계정전략 :: 계정정보_가져오기, 연결_아이디: {}", connectId);

        ServerInfo serverInfo = serverInfoService.verifyServerInfo(connectId);
        return 계정정보_조회(serverInfo);
    }

    private AlmAccount 계정정보_조회(ServerInfo serverInfo) {
        try {
            String uri = serverInfo.getUri();
            String serverType = serverInfo.getType();
            String apiToken = serverInfoService.getDecryptPasswordOrToken(serverInfo);
            String userId = serverInfo.getUserId();

            로그.info("온프라미스_지라_계정전략 :: 계정정보_조회, 서버 주소: {}, 서버 타입: {}, apiToken: {}, 유저 아이디: {}",uri,serverType,apiToken,userId);

            JiraRestClient restClient = jiraUtil.createJiraOnPremiseCommunicator(uri, userId, serverInfoService.getDecryptPasswordOrToken(serverInfo));
            User 계정정보_조회결과 = restClient.getUserClient().getUser(userId).claim();

            if (계정정보_조회결과 == null) {
                로그.error("온프라미스 지라 계정 조회 결과가 Null입니다.");
                throw new IllegalArgumentException(ErrorCode.ACCOUNT_INFO_RETRIEVAL_ERROR.getErrorMsg());
            }

            return 계정정보_데이터로_변환(계정정보_조회결과);

        } catch (Exception e) {
            로그.error("온프라미스 계정 정보 조회시 오류가 발생하였습니다." + e.getMessage());
            throw new IllegalArgumentException(ErrorCode.ACCOUNT_INFO_RETRIEVAL_ERROR.getErrorMsg());
        }
    }

    private AlmAccount 계정정보_데이터로_변환(User 계정정보_조회결과){
        AlmAccount AlmAccount = new AlmAccount();
        AlmAccount.setSelf(String.valueOf(계정정보_조회결과.getSelf()));
        AlmAccount.setName(계정정보_조회결과.getName());
        AlmAccount.setEmailAddress(계정정보_조회결과.getEmailAddress());
        AlmAccount.setDisplayName(계정정보_조회결과.getDisplayName());
        AlmAccount.setActive(계정정보_조회결과.isActive());
        return AlmAccount;
    }


}
