/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.repository.common;

import com.arms.egovframework.javaservice.esframework.annotation.Recent;
import com.arms.egovframework.javaservice.esframework.annotation.RecentId;
import com.arms.egovframework.javaservice.esframework.util.ReflectionUtil;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.opensearch.data.client.orhlc.NativeSearchQuery;
import org.opensearch.data.client.orhlc.NativeSearchQueryBuilder;
import org.opensearch.data.core.OpenSearchOperations;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.Query;

class RecentFieldConvertor<S, T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecentFieldConvertor.class);
    private final Map<Object, List<SearchHit<T>>> searchHitsMapList;
    private final OpenSearchOperations openSearchOperations;
    private final List<? extends T> entities;

    public RecentFieldConvertor(Iterable<S> entities, Class<T> tClass, OpenSearchOperations openSearchOperations) throws IllegalStateException {
        this.entities = StreamSupport.stream(entities.spliterator(), false).map(tClass::cast).collect(Collectors.toList());
        if (this.entities.isEmpty()) {
            throw new IllegalStateException("\uc800\uc7a5\ud560 \ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        String recentIdFieldName = Optional.of(ReflectionUtil.fieldInfo((Iterable)this.entities, RecentId.class).getAnnotation(Field.class).name()).filter(s -> !s.isEmpty()).orElse(ReflectionUtil.fieldInfo((Iterable)this.entities, RecentId.class).getName());
        String recentFieldName = Optional.of(ReflectionUtil.fieldInfo((Iterable)this.entities, Recent.class).getAnnotation(Field.class).name()).filter(s -> !s.isEmpty()).orElse(ReflectionUtil.fieldInfo((Iterable)this.entities, Recent.class).getName());
        this.openSearchOperations = openSearchOperations;
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)recentIdFieldName, (Collection)ReflectionUtil.fieldValues((Iterable)this.entities, RecentId.class))).filter((QueryBuilder)QueryBuilders.termQuery((String)recentFieldName, (boolean)true))).build();
        this.searchHitsMapList = Optional.ofNullable(this.search((Query)searchQuery, tClass)).map(schHits -> schHits.getSearchHits().stream().filter(a -> a.getIndex() != null).sorted(Comparator.comparing(a -> this.decodeCustomUUIDAndGetTimeStamp(a.getId()), Comparator.reverseOrder())).collect(Collectors.groupingBy(a -> {
            try {
                String fieldName = ReflectionUtil.fieldInfo(a.getContent().getClass(), RecentId.class).getName();
                return ReflectionUtil.getValue((Object)a.getContent(), (String)fieldName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }))).orElse(new HashMap());
    }

    private SearchHits<T> search(Query query, Class<T> clazz) {
        try {
            return this.openSearchOperations.search(query, clazz);
        }
        catch (NoSuchIndexException e) {
            String errorMessage = e.getMessage();
            if (errorMessage != null && errorMessage.contains("no such index")) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public S recentTrue(S newEntity) {
        try {
            String name = ReflectionUtil.fieldInfo(newEntity.getClass(), RecentId.class).getName();
            Object keyObject = ReflectionUtil.getValue(newEntity, (String)name);
            if (this.searchHitsMapList != null && this.searchHitsMapList.containsKey(keyObject)) {
                SearchHit searchHit = (SearchHit)((List)this.searchHitsMapList.get(keyObject)).stream().findFirst().orElseThrow(() -> new RuntimeException("\uac12\uc774 \ube44\uc6cc \uc788\uc2b5\ub2c8\ub2e4."));
                if (newEntity.equals(searchHit.getContent())) {
                    return null;
                }
                String fieldName = ReflectionUtil.fieldInfo(newEntity.getClass(), Recent.class).getName();
                ReflectionUtil.setValue(newEntity, (String)fieldName, (Object)true);
                return newEntity;
            }
            String fieldName = ReflectionUtil.fieldInfo(newEntity.getClass(), Recent.class).getName();
            ReflectionUtil.setValue(newEntity, (String)fieldName, (Object)true);
            return newEntity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private List<SearchHit<T>> recentFalse(Function<Map<Object, List<SearchHit<T>>>, Stream<SearchHit<T>>> function) {
        return Optional.ofNullable(this.searchHitsMapList).map(entitiMap -> ((Stream)function.apply((Map)entitiMap)).map(hit -> {
            try {
                String fieldName = ReflectionUtil.fieldInfo(hit.getContent().getClass(), Recent.class).getName();
                ReflectionUtil.setValue((Object)hit.getContent(), (String)fieldName, (Object)false);
                return hit;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList())).orElse(null);
    }

    public List<SearchHit<T>> setRecentFalseIfNotEqual(T newEntity) {
        Function<Map, Stream> function = entityMap -> {
            try {
                String fieldName = ReflectionUtil.fieldInfo(newEntity.getClass(), RecentId.class).getName();
                return entityMap.getOrDefault(ReflectionUtil.getValue((Object)newEntity, (String)fieldName), Collections.emptyList()).stream().filter(hit -> !newEntity.equals(hit.getContent()));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        };
        return this.recentFalse(function);
    }

    public List<SearchHit<T>> setRecentFalseIfDuplicate(T newEntity) {
        Function<Map, Stream> function = entityMap -> {
            try {
                String name = ReflectionUtil.fieldInfo(newEntity.getClass(), RecentId.class).getName();
                Object key = ReflectionUtil.getValue((Object)newEntity, (String)name);
                return entityMap.getOrDefault(key, Collections.emptyList()).stream().filter(hit -> newEntity.equals(hit.getContent())).skip(1L);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        };
        return this.recentFalse(function);
    }

    public Map<String, List<T>> listMapGroupByIndex(Function<T, List<SearchHit<T>>> function) {
        return this.entities.stream().filter(Objects::nonNull).map(function).filter(Objects::nonNull).flatMap(searchHits -> searchHits.stream().filter(a -> a.getIndex() != null)).collect(Collectors.groupingBy(SearchHit::getIndex, Collectors.mapping(SearchHit::getContent, Collectors.toList())));
    }

    private long decodeCustomUUIDAndGetTimeStamp(String base64uuid) {
        byte[] uuidBytes = Base64.getUrlDecoder().decode(base64uuid);
        if (uuidBytes.length != 15) {
            throw new IllegalArgumentException("Invalid UUID byte array length: " + uuidBytes.length);
        }
        return ((long)uuidBytes[5] & 0xFFL) << 40 | ((long)uuidBytes[4] & 0xFFL) << 32 | ((long)uuidBytes[3] & 0xFFL) << 24 | ((long)uuidBytes[2] & 0xFFL) << 16 | ((long)uuidBytes[12] & 0xFFL) << 8 | (long)uuidBytes[14] & 0xFFL;
    }
}

