/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.model.vo;

import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentBucket {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentBucket.class);
    private String groupKey;
    private String docFieldName;
    private String docCount;
    private List<DocumentBucket> subDocuments;
    private DocumentBucket parentDocumentBucket;

    private DocumentBucket() {
    }

    <T extends Number> T getDocCount(Class<T> t) {
        if (t.equals(Float.class)) {
            return (T)((Number)t.cast(Float.valueOf(Float.parseFloat(this.docCount))));
        }
        return (T)((Number)t.cast(Long.parseLong(this.docCount)));
    }

    Long getDocCount() {
        return Long.parseLong(this.docCount);
    }

    List<DocumentBucket> getDeepestDocument() {
        if (this.subDocuments == null || this.subDocuments.isEmpty()) {
            return List.of(this);
        }
        this.subDocuments.forEach(bucket -> bucket.setParentDocumentBucket(this));
        return this.subDocuments.stream().flatMap(bucket -> {
            List deepestList = bucket.getDeepestDocument();
            return deepestList.stream();
        }).collect(Collectors.toList());
    }

    public String valueByName(String docAliasName) {
        if (this.parentDocumentBucket == null && docAliasName.equals(this.groupKey)) {
            return this.docFieldName;
        }
        if (this.parentDocumentBucket == null) {
            return "";
        }
        if (docAliasName.equals(this.groupKey)) {
            return this.docFieldName;
        }
        return this.parentDocumentBucket.valueByName(docAliasName);
    }

    public <T extends Number> T countByName(String docAliasName, Class<T> t) {
        if (this.parentDocumentBucket == null && docAliasName.equals(this.groupKey)) {
            return (T)this.getDocCount(t);
        }
        if (this.parentDocumentBucket == null) {
            return (T)((Number)t.cast(0));
        }
        if (docAliasName.equals(this.groupKey)) {
            return (T)this.getDocCount(t);
        }
        return (T)this.parentDocumentBucket.countByName(docAliasName, t);
    }

    public Float floatCountByName(String docAliasName) {
        return (Float)this.countByName(docAliasName, Float.class);
    }

    public Long countByName(String docAliasName) {
        if (this.parentDocumentBucket == null && docAliasName.equals(this.groupKey)) {
            return this.getDocCount();
        }
        if (this.parentDocumentBucket == null) {
            return 0L;
        }
        if (docAliasName.equals(this.groupKey)) {
            return this.getDocCount();
        }
        return this.parentDocumentBucket.countByName(docAliasName);
    }

    DocumentBucket(String groupKey, MultiBucketsAggregation.Bucket bucket) {
        this.groupKey = groupKey;
        this.docFieldName = bucket.getKeyAsString();
        this.docCount = String.valueOf(bucket.getDocCount());
        this.subDocuments = new DocumentAggregations(bucket.getAggregations().asMap()).docBuckets();
    }

    DocumentBucket(String groupKey, NumericMetricsAggregation.SingleValue bucketValue) {
        this.groupKey = groupKey;
        this.docFieldName = groupKey;
        this.docCount = bucketValue.getValueAsString();
    }

    @Generated
    public void setParentDocumentBucket(DocumentBucket parentDocumentBucket) {
        this.parentDocumentBucket = parentDocumentBucket;
    }
}

