/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.search_engine.service;

import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.search_engine.dto.BaseSearchAggrDTO;
import com.arms.api.search_engine.dto.SearchDTO;
import com.arms.api.search_engine.service.AlmIssueSearch;
import com.arms.api.search_engine.vo.SearchAggrResultVO;
import com.arms.api.search_engine.vo.SearchDocFieldNameAndCount;
import com.arms.api.search_engine.vo.SearchResultVO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.esquery.highlight.EsHighlightQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlmIssueSearchImpl
implements AlmIssueSearch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlmIssueSearchImpl.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    public SearchResultVO<AlmIssueEntity> searchAlmIssue(SearchDTO searchDTO) {
        String startDate = searchDTO.getStartDate();
        String endDate = searchDTO.getEndDate();
        String filterFieldName = this.getFilterFieldName(searchDTO.getFilter().getName());
        DocumentResultWrapper hits = this.esCommonRepositoryWrapper.findHits(SimpleQuery.search((SearchRequestDTO)searchDTO).andQueryStringFilter(searchDTO.getSearchString()).andTermsQueryFilter(filterFieldName, searchDTO.getFilter().getValues()).andRangeQueryFilter(RangeQueryFilter.of((String)"@timestamp").betweenDate(startDate, endDate)).highlight(EsHighlightQuery.esHighlightAll()));
        return SearchResultVO.builder().totalResultDocs(hits.getTotalHits()).searchResultDocs(hits.toHitDocs()).build();
    }

    private String getFilterFieldName(String filterName) {
        if (filterName != null && !filterName.isBlank() && filterName.equals("project")) {
            return "project.project_name.keyword";
        }
        return null;
    }

    public SearchAggrResultVO aggregateByAlmProjectName(BaseSearchAggrDTO searchAggrDTO) {
        String startDate = searchAggrDTO.getStartDate();
        String endDate = searchAggrDTO.getEndDate();
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateDocs(SimpleQuery.aggregation((AggregationRequestDTO)AggregationRequestDTO.builder().size(5).mainField("project.project_name.keyword").mainFieldAlias("projectName").isAscending(false).build()).andQueryStringFilter(searchAggrDTO.getSearchString()).andRangeQueryFilter(RangeQueryFilter.of((String)"@timestamp").betweenDate(startDate, endDate)));
        List documentBuckets = documentAggregations.deepestList();
        List<SearchDocFieldNameAndCount> list = documentBuckets.stream().map(documentBucket -> SearchDocFieldNameAndCount.builder().docFieldName(documentBucket.valueByName("projectName")).docCount(documentBucket.countByName("projectName").longValue()).build()).toList();
        return SearchAggrResultVO.builder().totalHits(documentAggregations.getTotalHits()).docFieldNameAndCounts(list).build();
    }

    @Generated
    public AlmIssueSearchImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

