/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.status.strategy;

import com.arms.api.issue.status.strategy.IssueStatusStrategy;
import com.arms.api.issue.status.vo.CloudJiraByIssueTypeIssueStatusVO;
import com.arms.api.issue.status.vo.IssueStatusVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Status;
import io.atlassian.util.concurrent.Promise;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OnPremiseJiraIssueStatusStrategy
implements IssueStatusStrategy {
    private final JiraUtil jiraUtil;
    private final ServerInfoService serverInfoService;

    public List<IssueStatusVO> getIssueStatusList(ServerInfo serverInfo) {
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            Promise statusesPromise = restClient.getMetadataClient().getStatuses();
            Iterable statuses = (Iterable)statusesPromise.claim();
            return StreamSupport.stream(statuses.spliterator(), false).map(arg_0 -> this.convertIssueStatusVO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s] :: getIssueStatusList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public List<CloudJiraByIssueTypeIssueStatusVO> getIssueStatusListByProject(ServerInfo serverInfo, String projectId) {
        return null;
    }

    private IssueStatusVO convertIssueStatusVO(Status issueStatus) {
        return IssueStatusVO.builder().self(issueStatus.getSelf().toString()).id(issueStatus.getId().toString()).name(issueStatus.getName()).description(issueStatus.getDescription()).build();
    }

    @Generated
    public OnPremiseJiraIssueStatusStrategy(JiraUtil jiraUtil, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.serverInfoService = serverInfoService;
    }
}

