/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.priority.strategy;

import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.priority.strategy.IssuePriorityStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import java.util.List;
import lombok.Generated;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class CloudJiraIssuePriorityStrategy
implements IssuePriorityStrategy {
    private final JiraUtil jiraUtil;
    private final JiraApi jiraApi;
    private final ServerInfoService serverInfoService;

    public List<IssuePriorityDTO> getIssuePriorityList(ServerInfo serverInfo) {
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        String priorityEndpoint = this.jiraApi.getEndpoint().getIssue().getPriority();
        try {
            return (List)this.jiraUtil.get(webClient, priorityEndpoint, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s] :: getIssuePriorityList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Generated
    public CloudJiraIssuePriorityStrategy(JiraUtil jiraUtil, JiraApi jiraApi, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.jiraApi = jiraApi;
        this.serverInfoService = serverInfoService;
    }
}

