/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.service;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.model.vo.AlmIssueVO;
import com.arms.api.issue.almapi.model.vo.AlmIssueVOCollection;
import com.arms.api.issue.almapi.repository.AlmIssueToEntityConverterRepository;
import com.arms.api.issue.almapi.service.AlmIssueEntityCollection;
import com.arms.api.util.ApplicationContextProvider;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlmIssueToEntityConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlmIssueToEntityConverter.class);
    private final AlmIssueEntityCollection almIssueEntityCollection = new AlmIssueEntityCollection();
    private final AlmIssueVOCollection almIssueVOCollection;

    private AlmIssueToEntityConverter(AlmIssueVOCollection almIssueVOCollection) {
        this.almIssueVOCollection = almIssueVOCollection;
    }

    public static AlmIssueToEntityConverter discoveryRequirementIssue(AlmIssueVOCollection almIssueCollection) {
        AlmIssueToEntityConverter almIssueToEntityConverter = new AlmIssueToEntityConverter(almIssueCollection);
        almIssueToEntityConverter.createRequirementEntity();
        return almIssueToEntityConverter;
    }

    public static AlmIssueToEntityConverter discoveryNoneRequirementIssue(AlmIssueVOCollection almIssueCollections) {
        AlmIssueToEntityConverter almIssueToEntityConverter = new AlmIssueToEntityConverter(almIssueCollections);
        almIssueToEntityConverter.createNoneRequirementEntities();
        return almIssueToEntityConverter;
    }

    private void createRequirementEntity() {
        List almIssueVOS = this.almIssueVOCollection.listWithLinkedIssue();
        almIssueVOS.stream().filter(vo -> {
            AlmIssueEntity recentDocByRecentId = ((AlmIssueToEntityConverterRepository)ApplicationContextProvider.getBean(AlmIssueToEntityConverterRepository.class)).findRecentDocByRecentId(vo.recentId());
            return recentDocByRecentId.izReqTrue() && vo.getAlmIssueWithRequirementDTO().getIssueKey().equals(recentDocByRecentId.getKey());
        }).forEach(vo -> this.almIssueEntityCollection.addEntity(this.createEntity(vo)));
    }

    private void createNoneRequirementEntities() {
        List relationList = this.almIssueVOCollection.listWithLinkedIssue();
        List<AlmIssueEntity> almIssueEntities = relationList.stream().filter(AlmIssueVO::isIncludeFromSave).distinct().map(arg_0 -> this.createEntity(arg_0)).filter(arg_0 -> this.isPossibleTraceParentKeyOrIsSelfGeneratedIssue(arg_0)).filter(AlmIssueEntity::izReqFalse).toList();
        this.almIssueEntityCollection.addEntities(almIssueEntities);
    }

    private boolean isPossibleTraceParentKeyOrIsSelfGeneratedIssue(AlmIssueEntity almIssueEntity) {
        return almIssueEntity.getUpperKey() == null && almIssueEntity.getParentReqKey() == null || almIssueEntity.getUpperKey() != null && almIssueEntity.getParentReqKey() != null;
    }

    private AlmIssueEntity createEntity(AlmIssueVO reqAlmIssueVO) {
        AlmIssueWithRequirementDTO almIssueWithRequirementDTO = reqAlmIssueVO.getAlmIssueWithRequirementDTO();
        String upperKey = this.getUpperKey(reqAlmIssueVO);
        AlmIssueVO almIssueVO = Optional.ofNullable(upperKey).map(a -> reqAlmIssueVO.parentKey(almIssueWithRequirementDTO.getIssueKey())).orElse(reqAlmIssueVO);
        Long cReqStatusId = almIssueWithRequirementDTO.getCReqStatusId();
        Long serviceId = almIssueWithRequirementDTO.getServiceId();
        List versions = almIssueWithRequirementDTO.getVersions();
        Long cReqLink = almIssueWithRequirementDTO.getCReqLink();
        boolean isReq = this.isRequirement(almIssueVO);
        DateTimeFormatter formatter = almIssueVO.getFields().getCreated().matches(".*[+-]\\d{4}$") ? DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ") : DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        Long pdServiceId = isReq ? serviceId : this.getPdServiceId(almIssueVO);
        List pdServiceVersions = isReq ? versions : this.getPdServiceVersions(almIssueVO);
        AlmIssueEntity almIssueEntity = AlmIssueEntity.builder().jira_server_id(almIssueWithRequirementDTO.getJiraServerId()).isReq(Boolean.valueOf(isReq)).upperKey(this.getUpperKey(almIssueVO)).parentReqKey(almIssueVO.getParentKey()).issueID(almIssueVO.getId()).key(almIssueVO.getKey()).self(almIssueVO.getSelf()).project((AlmIssueEntity.Project)Optional.ofNullable(almIssueVO.getFields().getProject()).map(project -> AlmIssueEntity.Project.builder().id(project.getId()).key(project.getKey()).name(project.getName()).self(project.getSelf()).build()).orElse(null)).issuetype((AlmIssueEntity.IssueType)Optional.ofNullable(almIssueVO.getFields().getIssuetype()).map(issuetype -> AlmIssueEntity.IssueType.builder().self(issuetype.getSelf()).id(issuetype.getId()).description(issuetype.getDescription()).name(issuetype.getName()).subtask(issuetype.getSubtask()).untranslatedName(issuetype.getUntranslatedName()).hierarchyLevel(issuetype.getHierarchyLevel()).build()).orElse(null)).creator((AlmIssueEntity.Creator)Optional.ofNullable(almIssueVO.getFields().getCreator()).map(creator -> AlmIssueEntity.Creator.builder().accountId(creator.getAccountId()).emailAddress(creator.getEmailAddress()).displayName(creator.getDisplayName()).build()).orElse(null)).reporter((AlmIssueEntity.Reporter)Optional.ofNullable(almIssueVO.getFields().getReporter()).map(reporter -> AlmIssueEntity.Reporter.builder().accountId(reporter.getAccountId()).emailAddress(reporter.getEmailAddress()).displayName(reporter.getDisplayName()).build()).orElse(null)).assignee((AlmIssueEntity.Assignee)Optional.ofNullable(almIssueVO.getFields().getAssignee()).map(assignee -> AlmIssueEntity.Assignee.builder().accountId(assignee.getAccountId()).emailAddress(assignee.getEmailAddress()).displayName(assignee.getDisplayName()).build()).orElse(null)).labels(almIssueVO.getFields().getLabels()).priority((AlmIssueEntity.Priority)Optional.ofNullable(almIssueVO.getFields().getPriority()).map(priority -> AlmIssueEntity.Priority.builder().self(priority.getSelf()).id(priority.getId()).name(priority.getName()).description(priority.getDescription()).isDefault(Optional.of(priority.isDefault()).orElse(false).booleanValue()).build()).orElse(null)).status((AlmIssueEntity.\uc0c1\ud0dc)Optional.ofNullable(almIssueVO.getFields().getStatus()).map(status -> AlmIssueEntity.\uc0c1\ud0dc.builder().self(status.getSelf()).id(status.getId()).name(status.getName()).description(status.getDescription()).build()).orElse(null)).resolution((AlmIssueEntity.Resolution)Optional.ofNullable(almIssueVO.getFields().getResolution()).map(resolution -> AlmIssueEntity.Resolution.builder().self(resolution.getSelf()).id(resolution.getId()).name(resolution.getName()).description(resolution.getDescription()).isDefault(Optional.of(resolution.isDefault()).orElse(false).booleanValue()).build()).orElse(null)).resolutiondate(almIssueVO.getFields().getResolutiondate()).created(Date.from(OffsetDateTime.parse(almIssueVO.getFields().getCreated(), formatter).toInstant())).updated(Date.from(OffsetDateTime.parse(almIssueVO.getFields().getUpdated(), formatter).toInstant())).overallUpdatedDate(Date.from(OffsetDateTime.parse(almIssueVO.getFields().getUpdated(), formatter).toInstant())).worklogs(Optional.ofNullable(almIssueVO.getFields().getWorklogs()).orElse(Collections.emptyList()).stream().map(worklogItem -> new AlmIssueEntity.Worklogs(worklogItem.getSelf(), (AlmIssueEntity.Author)Optional.ofNullable(worklogItem.getAuthor()).map(author -> new AlmIssueEntity.Author(author.getAccountId(), author.getEmailAddress())).orElse(null), (AlmIssueEntity.UpdateAuthor)Optional.ofNullable(worklogItem.getUpdateAuthor()).map(updateAuthor -> new AlmIssueEntity.UpdateAuthor(updateAuthor.getAccountId(), updateAuthor.getEmailAddress())).orElse(null), worklogItem.getCreated(), worklogItem.getUpdated(), worklogItem.getStarted(), worklogItem.getTimeSpent(), worklogItem.getTimeSpentSeconds(), worklogItem.getId(), worklogItem.getIssueId())).collect(Collectors.toList())).timespent(almIssueVO.getFields().getTimespent()).summary(almIssueVO.getFields().getSummary()).cReqStatusId(isReq ? cReqStatusId : this.getCReqStatusId(almIssueVO)).pdServiceId(pdServiceId).pdServiceVersions(pdServiceVersions).cReqLink(isReq ? cReqLink : this.getCReqLink(almIssueVO)).linkedIssues(almIssueVO.getLinkedIssues()).linkedIssuePdServiceIds(Optional.ofNullable(almIssueVO.getLinkedIssuePdServiceIds()).map(a -> a.stream().distinct().toList()).orElse(List.of())).linkedIssuePdServiceVersions(Optional.ofNullable(almIssueVO.getLinkedIssuePdServiceVersions()).map(a -> a.stream().distinct().toList()).orElse(List.of())).cReqProperty((AlmIssueEntity.CReqProperty)Optional.ofNullable(almIssueWithRequirementDTO.getCReqProperty()).map(cReqProperty -> isReq ? AlmIssueEntity.CReqProperty.builder().cReqPriorityLink(cReqProperty.getCReqPriorityLink()).cReqPriorityName(cReqProperty.getCReqPriorityName()).cReqDifficultyLink(cReqProperty.getCReqDifficultyLink()).cReqDifficultyName(cReqProperty.getCReqDifficultyName()).cReqStateLink(cReqProperty.getCReqStateLink()).cReqStateName(cReqProperty.getCReqStateName()).build() : this.getAlmCReqProperty(almIssueVO)).orElse(null)).armsStateCategory((String)Optional.ofNullable(almIssueVO.getArmsStateCategory()).map(armsStateCategory -> almIssueVO.getArmsStateCategory()).orElse(null)).rawData(almIssueVO.getRawData()).build();
        almIssueEntity.generateId();
        return almIssueEntity;
    }

    private String getUpperKey(AlmIssueVO almIssueVO) {
        AlmIssueEntity almIssueEntity = ((AlmIssueToEntityConverterRepository)ApplicationContextProvider.getBean(AlmIssueToEntityConverterRepository.class)).findRecentDocByRecentId(almIssueVO.recentId());
        if (almIssueEntity == null || almIssueEntity.getUpperKey() == null) {
            return almIssueVO.getUpperKey();
        }
        return almIssueEntity.getUpperKey();
    }

    private Boolean isRequirement(AlmIssueVO almIssueVO) {
        AlmIssueEntity almIssueEntity = ((AlmIssueToEntityConverterRepository)ApplicationContextProvider.getBean(AlmIssueToEntityConverterRepository.class)).findRecentDocByRecentId(almIssueVO.recentId());
        if (almIssueEntity == null || almIssueEntity.getIsReq() == null) {
            return false;
        }
        return almIssueEntity.getIsReq();
    }

    private AlmIssueEntity.CReqProperty getAlmCReqProperty(AlmIssueVO almIssueVO) {
        AlmIssueEntity almIssueEntity = ((AlmIssueToEntityConverterRepository)ApplicationContextProvider.getBean(AlmIssueToEntityConverterRepository.class)).findRecentDocByRecentId(almIssueVO.recentParentId());
        if (almIssueEntity == null || almIssueEntity.getCReqProperty() == null) {
            return null;
        }
        return almIssueEntity.getCReqProperty();
    }

    private Long getCReqStatusId(AlmIssueVO almIssueVO) {
        AlmIssueEntity almIssueEntity = ((AlmIssueToEntityConverterRepository)ApplicationContextProvider.getBean(AlmIssueToEntityConverterRepository.class)).findRecentDocByRecentId(almIssueVO.recentParentId());
        if (almIssueEntity == null || almIssueEntity.getCReqStatusId() == null) {
            return null;
        }
        return almIssueEntity.getCReqStatusId();
    }

    private Long getCReqLink(AlmIssueVO almIssueVO) {
        AlmIssueEntity almIssueEntity = ((AlmIssueToEntityConverterRepository)ApplicationContextProvider.getBean(AlmIssueToEntityConverterRepository.class)).findRecentDocByRecentId(almIssueVO.recentParentId());
        if (almIssueEntity == null || almIssueEntity.getCReqLink() == null) {
            return null;
        }
        return almIssueEntity.getCReqLink();
    }

    private Long getPdServiceId(AlmIssueVO almIssueVO) {
        AlmIssueEntity almIssueEntity = ((AlmIssueToEntityConverterRepository)ApplicationContextProvider.getBean(AlmIssueToEntityConverterRepository.class)).findRecentDocByRecentId(almIssueVO.recentParentId());
        if (almIssueEntity == null || almIssueEntity.getPdServiceId() == null) {
            return null;
        }
        return almIssueEntity.getPdServiceId();
    }

    private List<Long> getPdServiceVersions(AlmIssueVO almIssueVO) {
        AlmIssueEntity almIssueEntity = ((AlmIssueToEntityConverterRepository)ApplicationContextProvider.getBean(AlmIssueToEntityConverterRepository.class)).findRecentDocByRecentId(almIssueVO.recentParentId());
        if (almIssueEntity == null || almIssueEntity.getPdServiceVersions() == null) {
            return null;
        }
        return almIssueEntity.getPdServiceVersions();
    }

    public List<AlmIssueEntity> almIssueEntities() {
        return this.almIssueEntityCollection.almIssueEntities();
    }
}

