/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.topmenu.service;

import com.arms.api.analysis.topmenu.model.dto.TopMenuDTO;
import com.arms.api.analysis.topmenu.model.vo.ReqAndIssueTotalCountVO;
import com.arms.api.analysis.topmenu.service.AnalysisTopMenu;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AnalysisTopMenuImpl
implements AnalysisTopMenu {
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    public ReqAndIssueTotalCountVO topMenuTotalCountWithReqAndSubtask(TopMenuDTO topMenuDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = topMenuDTO.getPdServiceAndIsReq();
        Long pdServiceLink = pdServiceAndIsReq.getPdServiceId();
        List pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        HashSet versionSet = new HashSet(pdServiceVersions);
        List retrieveIssues = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter((String)"linkedIssuePdServiceIds", List.of(pdServiceLink)).andTermsQueryFilter("linkedIssuePdServiceVersions", pdServiceVersions).andExistsQueryFilter("isReq")).toDocs();
        long req = 0L;
        long subtask = 0L;
        long notAssignedReq = 0L;
        long notAssignedNotReq = 0L;
        for (AlmIssueEntity issue : retrieveIssues) {
            Long pdServiceId = issue.getPdServiceId();
            if (this.isRightReqIssue(issue, pdServiceLink, versionSet)) {
                ++req;
                if (!this.isNotAssignedIssue(issue)) continue;
                ++notAssignedReq;
                continue;
            }
            ++subtask;
            if (!this.isNotAssignedIssue(issue)) continue;
            ++notAssignedNotReq;
        }
        return ReqAndIssueTotalCountVO.builder().total(Long.valueOf(req + subtask)).req(Long.valueOf(req)).notAssignedReq(Long.valueOf(notAssignedReq)).subtask(Long.valueOf(subtask)).notAssignedNotReq(Long.valueOf(notAssignedNotReq)).build();
    }

    private boolean isRightReqIssue(AlmIssueEntity issue, Long pdServiceId, Set<Long> versionSet) {
        return Boolean.TRUE.equals(issue.getIsReq()) && Objects.equals(issue.getPdServiceId(), pdServiceId) && this.isContainsRightVersion(issue.getPdServiceVersions(), versionSet);
    }

    private boolean isContainsRightVersion(List<Long> versions, Set<Long> versionSet) {
        if (versions == null || versionSet == null || versions.isEmpty() || versionSet.isEmpty()) {
            return false;
        }
        return versions.stream().anyMatch(versionSet::contains);
    }

    private boolean isNotAssignedIssue(AlmIssueEntity issue) {
        return ObjectUtils.isEmpty((Object)issue.getAssignee());
    }

    @Generated
    public AnalysisTopMenuImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

