/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.factory.builder;

import com.arms.egovframework.javaservice.esframework.annotation.Recent;
import com.arms.egovframework.javaservice.esframework.esquery.EsQuery;
import com.arms.egovframework.javaservice.esframework.factory.builder.AggregationQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.MainGroupDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SingleValueGroupDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.data.client.orhlc.NativeSearchQuery;
import org.opensearch.data.client.orhlc.NativeSearchQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.sort.FieldSortBuilder;

public class AggregationQueryBuilder<T extends AbstractAggregationBuilder<T>>
implements AggregationQuery<NativeSearchQuery> {
    private final List<SubGroupFieldDTO> subGroupFieldDTOS;
    private final NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
    private final BoolQueryBuilder boolQuery;
    private final AbstractAggregationBuilder<T> valuesSourceAggregationBuilder;

    protected AggregationQueryBuilder(MainGroupDTO mainGroupDTO, EsQuery esQuery, AbstractAggregationBuilder<T> valuesSourceAggregationBuilder) {
        this.valuesSourceAggregationBuilder = valuesSourceAggregationBuilder;
        this.subGroupFieldDTOS = mainGroupDTO.getSubGroupFieldDTOS();
        this.boolQuery = esQuery.getBoolQueryBuilder();
        this.nativeSearchQueryBuilder.withMaxResults(Integer.valueOf(mainGroupDTO.isContentView() ? mainGroupDTO.getSize() : 0));
        this.nativeSearchQueryBuilder.withTrackTotalHits(Boolean.valueOf(true));
        this.nativeSearchQueryBuilder.withAggregations(new AbstractAggregationBuilder[]{this.valuesSourceAggregationBuilder});
        List<FieldSortBuilder> fieldSortBuilders = esQuery.getSortBuilders();
        Optional.ofNullable(this.boolQuery).ifPresent(query -> this.nativeSearchQueryBuilder.withQuery((QueryBuilder)this.boolQuery));
        Optional.ofNullable(fieldSortBuilders).ifPresent(sorts -> this.nativeSearchQueryBuilder.withSorts(new ArrayList(fieldSortBuilders)));
    }

    protected AggregationQueryBuilder(SingleValueGroupDTO singleValueGroupDTO, EsQuery esQuery, AbstractAggregationBuilder<T> valuesSourceAggregationBuilder) {
        this.valuesSourceAggregationBuilder = valuesSourceAggregationBuilder;
        this.subGroupFieldDTOS = List.of(singleValueGroupDTO.getSubGroupFieldDTO());
        int size = singleValueGroupDTO.getSize();
        boolean isViewContents = singleValueGroupDTO.isContentView();
        this.boolQuery = esQuery.getBoolQueryBuilder();
        this.nativeSearchQueryBuilder.withMaxResults(Integer.valueOf(isViewContents ? size : 0));
        this.nativeSearchQueryBuilder.withTrackTotalHits(Boolean.valueOf(true));
        this.nativeSearchQueryBuilder.withAggregations(new AbstractAggregationBuilder[]{this.valuesSourceAggregationBuilder});
        List<FieldSortBuilder> fieldSortBuilders = esQuery.getSortBuilders();
        Optional.ofNullable(this.boolQuery).ifPresent(query -> this.nativeSearchQueryBuilder.withQuery((QueryBuilder)this.boolQuery));
        Optional.ofNullable(fieldSortBuilders).ifPresent(sorts -> this.nativeSearchQueryBuilder.withSorts(new ArrayList(fieldSortBuilders)));
    }

    @Override
    public void applyNestedAggregation() {
        Optional.ofNullable(this.subGroupFieldDTOS).ifPresent(subGroupFields -> {
            if (!subGroupFields.isEmpty()) {
                this.valuesSourceAggregationBuilder.subAggregation(this.createNestedAggregation((List<SubGroupFieldDTO>)subGroupFields));
            }
        });
    }

    @Override
    public void applyCardinalityAggregation() {
        Optional.ofNullable(this.subGroupFieldDTOS).ifPresent(subGroupFields -> {
            if (!subGroupFields.isEmpty()) {
                this.valuesSourceAggregationBuilder.subAggregation(this.createCardinalityAggregation((List<SubGroupFieldDTO>)subGroupFields));
            }
        });
    }

    @Override
    public void applyAggregation() {
        Optional.ofNullable(this.subGroupFieldDTOS).ifPresent(subGroupFields -> {
            if (!subGroupFields.isEmpty()) {
                this.createAggregation((List<SubGroupFieldDTO>)subGroupFields).forEach(arg_0 -> this.valuesSourceAggregationBuilder.subAggregation(arg_0));
            }
        });
    }

    @Override
    public void applyMetricAggregation() {
        Optional.ofNullable(this.subGroupFieldDTOS).ifPresent(subGroupFields -> {
            if (!subGroupFields.isEmpty()) {
                this.createMetricAggregation((List<SubGroupFieldDTO>)subGroupFields).forEach(arg_0 -> this.valuesSourceAggregationBuilder.subAggregation(arg_0));
            }
        });
    }

    @Override
    public NativeSearchQuery create() {
        return this.nativeSearchQueryBuilder.build();
    }

    @Override
    public NativeSearchQuery createForRecentTrue(Class<? extends BaseEntity> entityClass) {
        String recentFieldName = ReflectionUtil.fieldInfo(entityClass, Recent.class).getName();
        this.boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)recentFieldName, (boolean)true));
        return this.nativeSearchQueryBuilder.build();
    }

    private List<AggregationBuilder> createAggregation(List<SubGroupFieldDTO> subGroupFieldDTOS) {
        return subGroupFieldDTOS.stream().map(fieldName -> ((TermsAggregationBuilder)AggregationBuilders.terms((String)Optional.ofNullable(fieldName.getSubFieldAlias()).orElseGet(() -> "group_by_" + fieldName.getSubField())).field(fieldName.getSubField())).order(BucketOrder.count((boolean)fieldName.isAscending())).size(fieldName.getSize())).collect(Collectors.toList());
    }

    private AggregationBuilder createNestedAggregation(List<SubGroupFieldDTO> subGroupFieldDTOS) {
        return (AggregationBuilder)subGroupFieldDTOS.stream().collect(Collectors.collectingAndThen(Collectors.toList(), lst -> {
            Collections.reverse(lst);
            return lst;
        })).stream().map(fieldName -> ((TermsAggregationBuilder)AggregationBuilders.terms((String)Optional.ofNullable(fieldName.getSubFieldAlias()).orElseGet(() -> "group_by_" + fieldName.getSubField())).field(fieldName.getSubField())).order(BucketOrder.count((boolean)fieldName.isAscending())).size(fieldName.getSize())).reduce(null, (agg1, agg2) -> {
            if (agg1 == null) {
                return agg2;
            }
            return (TermsAggregationBuilder)agg2.subAggregation((AggregationBuilder)agg1);
        });
    }

    private List<AggregationBuilder> createMetricAggregation(List<SubGroupFieldDTO> subGroupFieldDTOS) {
        return subGroupFieldDTOS.stream().flatMap(subGroupField -> {
            ValuesSourceAggregationBuilder.LeafOnly[] leafOnlyArray = new ValuesSourceAggregationBuilder.LeafOnly[3];
            leafOnlyArray[0] = (ValuesSourceAggregationBuilder.LeafOnly)AggregationBuilders.avg((String)("avg_by_" + Optional.ofNullable(subGroupField.getSubFieldAlias()).orElseGet(subGroupField::getSubField))).field(subGroupField.getSubField());
            leafOnlyArray[1] = (ValuesSourceAggregationBuilder.LeafOnly)AggregationBuilders.max((String)("max_by_" + Optional.ofNullable(subGroupField.getSubFieldAlias()).orElseGet(subGroupField::getSubField))).field(subGroupField.getSubField());
            leafOnlyArray[2] = (ValuesSourceAggregationBuilder.LeafOnly)AggregationBuilders.min((String)("min_by_" + Optional.ofNullable(subGroupField.getSubFieldAlias()).orElseGet(subGroupField::getSubField))).field(subGroupField.getSubField());
            return Stream.of(leafOnlyArray);
        }).collect(Collectors.toList());
    }

    private AggregationBuilder createCardinalityAggregation(List<SubGroupFieldDTO> subGroupFieldDTOS) {
        return (AggregationBuilder)subGroupFieldDTOS.stream().map(fieldName -> (CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)Optional.ofNullable(fieldName.getSubFieldAlias()).orElseGet(() -> "group_by_" + fieldName.getSubField())).field(fieldName.getSubField())).reduce(null, (agg1, agg2) -> agg2);
    }
}

