/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.serverinfo.controller;

import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.ServerInfoEntity;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/serverInfo"})
public class ServerInfoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerInfoController.class);
    @Autowired
    private ServerInfoService serverInfoService;

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ServerInfoEntity saveOrUpdateServerInfo(@RequestBody ServerInfo serverInfo) {
        if (serverInfo == null) {
            throw new IllegalArgumentException(ErrorCode.SERVER_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        if (serverInfo.getConnectId() == null) {
            throw new IllegalArgumentException(ErrorCode.SERVER_ID_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)serverInfo.getUri())) {
            throw new IllegalArgumentException(ErrorCode.SERVER_URI_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)serverInfo.getUserId())) {
            throw new IllegalArgumentException(ErrorCode.SERVER_ID_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)this.serverInfoService.getDecryptPasswordOrToken(serverInfo))) {
            throw new IllegalArgumentException(ErrorCode.SERVER_PW_OR_API_TOKEN_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)serverInfo.getType())) {
            throw new IllegalArgumentException(ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        log.info("[ServerInfoController :: saveOrUpdateServerInfo] :: {}", (Object)serverInfo);
        return this.serverInfoService.saveOrUpdateServerInfo(serverInfo);
    }

    @GetMapping(value={"/listByConnectIds"})
    public List<ServerInfo> serverInfoListByConnectIds(@RequestParam(value="connectIds") List<String> connectIds) {
        log.info("[ServerInfoController :: serverInfoListByConnectIds] :: {}", (Object)connectIds.toString());
        return this.serverInfoService.serverInfoListByConnectIds(connectIds);
    }

    @PostMapping(value={"/backup/scheduler"})
    public void serverInfoBackup() {
        this.serverInfoService.serverInfoBackup();
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    public ServerInfo deleteServerInfo(@RequestBody ServerInfo serverInfo) throws Exception {
        if (serverInfo == null || serverInfo.getConnectId() == null) {
            throw new Exception("\uc0ad\uc81c \uc694\uccad \ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        log.info("[ServerInfoController :: deleteServerInfo] :: {}", (Object)serverInfo.getConnectId());
        this.serverInfoService.deleteServerInfo(serverInfo.getConnectId());
        return serverInfo;
    }

    @ResponseBody
    @RequestMapping(value={"/serverTypeMap"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getServerTypeMap() {
        log.info("[ServerInfoController :: getServerTypeMap]");
        Map<String, String> serverTypeMap = this.serverInfoService.getServerIdToTypeMap();
        return ResponseEntity.ok(serverTypeMap);
    }
}

