/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.project.strategy;

import com.arms.api.project.strategy.ProjectStrategy;
import com.arms.api.project.vo.ProjectVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OnpremiseJiraProjectStrategy
implements ProjectStrategy {
    private final JiraUtil jiraUtil;
    private final ServerInfoService serverInfoService;

    @Override
    public ProjectVO getProject(ServerInfo serverInfo, String projectKeyOrId) {
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            BasicProject basicProject = (BasicProject)restClient.getProjectClient().getProject(projectKeyOrId).claim();
            return this.convertProjectVO(basicProject);
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn(e, this.getClass().getName(), String.format("%s[%s] :: getProject Error \ud504\ub85c\uc81d\ud2b8[%s] ", serverInfo.getType(), serverInfo.getUri(), projectKeyOrId));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public List<ProjectVO> getProjectList(ServerInfo serverInfo) {
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            Iterable basicProjectList = (Iterable)restClient.getProjectClient().getAllProjects().claim();
            return StreamSupport.stream(basicProjectList.spliterator(), false).map(this::convertProjectVO).collect(Collectors.toList());
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn(e, this.getClass().getName(), String.format("%s[%s] :: getProjectList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private ProjectVO convertProjectVO(BasicProject project) {
        return ProjectVO.builder().id(project.getId().toString()).key(project.getKey()).name(project.getName()).self(project.getSelf().toString()).build();
    }

    @Generated
    public OnpremiseJiraProjectStrategy(JiraUtil jiraUtil, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.serverInfoService = serverInfoService;
    }
}

