/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.resolution.strategy;

import com.arms.api.issue.resolution.model.IssueResolutionData;
import com.arms.api.issue.resolution.strategy.IssueResolutionStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OnPremiseJiraIssueResolutionStrategy
implements IssueResolutionStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnPremiseJiraIssueResolutionStrategy.class);
    private final JiraUtil jiraUtil;
    private final ServerInfoService serverInfoService;

    @Override
    public List<IssueResolutionData> getIssueResolutionList(ServerInfo serverInfo) {
        try {
            JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            Iterable \uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288_\ud574\uacb0\ucc45_\ubaa9\ub85d = (Iterable)restClient.getMetadataClient().getResolutions().claim();
            if (\uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288_\ud574\uacb0\ucc45_\ubaa9\ub85d == null) {
                log.error("\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c( {} ) \uc11c\ubc84\uc5d0 \uc124\uc815\ub41c \uc774\uc288 \ud574\uacb0\ucc45\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \uc11c\ubc84 \uc815\ubcf4 \ud655\uc778\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.", (Object)serverInfo.getUri());
                return null;
            }
            List<IssueResolutionData> \ubc18\ud658\ud560_\uc774\uc288_\ud574\uacb0\ucc45_\ubaa9\ub85d = StreamSupport.stream(\uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288_\ud574\uacb0\ucc45_\ubaa9\ub85d.spliterator(), false).map(\uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288_\ud574\uacb0\ucc45 -> {
                IssueResolutionData \ubc18\ud658\ud560_\uc774\uc288_\ud574\uacb0\ucc45 = new IssueResolutionData();
                \ubc18\ud658\ud560_\uc774\uc288_\ud574\uacb0\ucc45.setSelf(\uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288_\ud574\uacb0\ucc45.getSelf().toString());
                \ubc18\ud658\ud560_\uc774\uc288_\ud574\uacb0\ucc45.setId(\uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288_\ud574\uacb0\ucc45.getId().toString());
                \ubc18\ud658\ud560_\uc774\uc288_\ud574\uacb0\ucc45.setName(\uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288_\ud574\uacb0\ucc45.getName());
                \ubc18\ud658\ud560_\uc774\uc288_\ud574\uacb0\ucc45.setDescription(\uc628\ud504\ub808\ubbf8\uc2a4_\uc774\uc288_\ud574\uacb0\ucc45.getDescription());
                return \ubc18\ud658\ud560_\uc774\uc288_\ud574\uacb0\ucc45;
            }).collect(Collectors.toList());
            return \ubc18\ud658\ud560_\uc774\uc288_\ud574\uacb0\ucc45_\ubaa9\ub85d;
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn(e, this.getClass().getName(), "\uc774\uc288\ud574\uacb0\ucc45_\ubaa9\ub85d_\uac00\uc838\uc624\uae30");
            throw new IllegalArgumentException(\uc5d0\ub7ec\ub85c\uadf8);
        }
    }

    @Generated
    public OnPremiseJiraIssueResolutionStrategy(JiraUtil jiraUtil, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.serverInfoService = serverInfoService;
    }
}

