/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.resolution.strategy;

import com.arms.api.issue.resolution.model.IssueResolutionData;
import com.arms.api.issue.resolution.strategy.IssueResolutionStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class CloudJiraIssueResolutionStrategy
implements IssueResolutionStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudJiraIssueResolutionStrategy.class);
    private final JiraUtil jiraUtil;
    private final JiraApi jiraApi;
    private final ServerInfoService serverInfoService;

    @Override
    public List<IssueResolutionData> getIssueResolutionList(ServerInfo serverInfo) {
        try {
            WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            String resolutionEndpoint = this.jiraApi.getEndpoint().getIssue().getResolution();
            List \ubc18\ud658\ud560_IssueResolutionData_\ubaa9\ub85d = (List)this.jiraUtil.get(webClient, resolutionEndpoint, new ParameterizedTypeReference<List<IssueResolutionData>>(this){}).block();
            return \ubc18\ud658\ud560_IssueResolutionData_\ubaa9\ub85d;
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn(e, this.getClass().getName(), "\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getConnectId() + ") :: \uc774\uc288\ud574\uacb0\ucc45_\ubaa9\ub85d_\uac00\uc838\uc624\uae30");
            throw new IllegalArgumentException(\uc5d0\ub7ec\ub85c\uadf8);
        }
    }

    @Generated
    public CloudJiraIssueResolutionStrategy(JiraUtil jiraUtil, JiraApi jiraApi, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.jiraApi = jiraApi;
        this.serverInfoService = serverInfoService;
    }
}

