/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.resolution.service;

import com.arms.api.issue.resolution.model.IssueResolutionData;
import com.arms.api.issue.resolution.strategy.CloudJiraIssueResolutionStrategy;
import com.arms.api.issue.resolution.strategy.IssueResolutionStrategy;
import com.arms.api.issue.resolution.strategy.IssueResolutionStrategyRegister;
import com.arms.api.issue.resolution.strategy.OnPremiseJiraIssueResolutionStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class \uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5_\ud638\ucd9c {
    private final Logger \ub85c\uadf8 = LoggerFactory.getLogger(this.getClass());
    private ServerInfoService ServerInfoService;
    private CloudJiraIssueResolutionStrategy \ud074\ub77c\uc6b0\ub4dc_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5;
    private OnPremiseJiraIssueResolutionStrategy \uc628\ud504\ub808\ubbf8\uc2a4_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5;

    @Autowired
    public \uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5_\ud638\ucd9c(ServerInfoService ServerInfoService2, CloudJiraIssueResolutionStrategy \ud074\ub77c\uc6b0\ub4dc_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5, OnPremiseJiraIssueResolutionStrategy \uc628\ud504\ub808\ubbf8\uc2a4_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5) {
        this.ServerInfoService = ServerInfoService2;
        this.\ud074\ub77c\uc6b0\ub4dc_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5 = \ud074\ub77c\uc6b0\ub4dc_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5;
        this.\uc628\ud504\ub808\ubbf8\uc2a4_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5 = \uc628\ud504\ub808\ubbf8\uc2a4_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5;
    }

    private IssueResolutionStrategy \uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5_\ud655\uc778(ServerInfo serverInfo) {
        IssueResolutionStrategy IssueResolutionStrategy2;
        if (serverInfo == null || serverInfo.getType().isEmpty()) {
            this.\ub85c\uadf8.error("\uc9c0\ub77c\uc774\uc288 \ud574\uacb0\ucc45 \uc804\ub7b5 \ub4f1\ub85d Error: serverInfo \uc720\ud615 {}", (Object)ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc9c0\ub77c\uc774\uc288 \ud574\uacb0\ucc45 \uc804\ub7b5 \ub4f1\ub85d Error: \uc5f0\uacb0\uc815\ubcf4_\uc720\ud615 " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        ServerType \uc11c\ubc84_\uc720\ud615 = ServerType.typeValueOf(serverInfo.getType());
        if (\uc11c\ubc84_\uc720\ud615 == ServerType.CLOUD) {
            IssueResolutionStrategy2 = this.\ud074\ub77c\uc6b0\ub4dc_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5;
        } else if (\uc11c\ubc84_\uc720\ud615 == ServerType.ON_PREMISS) {
            IssueResolutionStrategy2 = this.\uc628\ud504\ub808\ubbf8\uc2a4_\uc9c0\ub77c_\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5;
        } else {
            throw new IllegalArgumentException("\uc774\uc288\ud574\uacb0\ucc45 \uc804\ub7b5 \ud655\uc778 Error: \ud5c8\uc6a9\ud558\uc9c0 \uc54a\ub294 serverInfo_\uc720\ud615\uc785\ub2c8\ub2e4. :: " + String.valueOf((Object)\uc11c\ubc84_\uc720\ud615) + " :: " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        return IssueResolutionStrategy2;
    }

    public List<IssueResolutionData> \uc774\uc288\ud574\uacb0\ucc45_\ubaa9\ub85d_\uac00\uc838\uc624\uae30(String \uc5f0\uacb0_\uc544\uc774\ub514) {
        if (\uc5f0\uacb0_\uc544\uc774\ub514 == null) {
            this.\ub85c\uadf8.error("\uc774\uc288 \ud574\uacb0\ucc45 \ubaa9\ub85d \uac00\uc838\uc624\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uc774\uc288 \ud574\uacb0\ucc45 \ubaa9\ub85d \uac00\uc838\uc624\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        ServerInfo serverInfo = this.ServerInfoService.verifyServerInfo(\uc5f0\uacb0_\uc544\uc774\ub514);
        ServerType \uc11c\ubc84_\uc720\ud615 = ServerType.typeValueOf(serverInfo.getType());
        if (\uc11c\ubc84_\uc720\ud615 == ServerType.REDMINE_ON_PREMISS) {
            this.\ub85c\uadf8.info("\ub808\ub4dc\ub9c8\uc778 \uc628\ud504\ub808\ubbf8\uc2a4 \ud0c0\uc785\uc740 \uc774\uc288 \ud574\uacb0\ucc45\uc744 \uc9c0\uc6d0\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            return Collections.emptyList();
        }
        IssueResolutionStrategy IssueResolutionStrategy2 = this.\uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5_\ud655\uc778(serverInfo);
        IssueResolutionStrategyRegister IssueResolutionStrategyRegister2 = new IssueResolutionStrategyRegister();
        IssueResolutionStrategyRegister2.issueResolutionStrategyRegister(IssueResolutionStrategy2);
        List<IssueResolutionData> \ubc18\ud658\ud560_\uc774\uc288\ud574\uacb0\ucc45_\ubaa9\ub85d = IssueResolutionStrategyRegister2.getIssueResolutionStrategyList(serverInfo);
        return \ubc18\ud658\ud560_\uc774\uc288\ud574\uacb0\ucc45_\ubaa9\ub85d;
    }

    @Generated
    public \uc774\uc288\ud574\uacb0\ucc45_\uc804\ub7b5_\ud638\ucd9c() {
    }
}

