/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.model.entity;

import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchIndex;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchTemplateConfig;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.annotation.Recent;
import com.arms.egovframework.javaservice.esframework.annotation.RecentId;
import com.arms.egovframework.javaservice.esframework.annotation.RollingIndexName;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="#{@jiraissue}", createIndex=false)
@ElasticSearchTemplateConfig
@ElasticSearchIndex
public class AlmIssueEntity
implements BaseEntity {
    @Id
    @ReadOnlyProperty
    private String id;
    @RecentId
    @JsonProperty(value="recent_id")
    @Field(type=FieldType.Keyword, name="recent_id")
    private String recentId;
    @Recent
    @Field(type=FieldType.Boolean, name="recent")
    private boolean recent;
    @Field(type=FieldType.Boolean, name="isReq")
    private Boolean isReq;
    @Field(type=FieldType.Long, name="cReqLink")
    private Long cReqLink;
    @Field(type=FieldType.Long, name="cReqStatusId")
    private Long cReqStatusId;
    @Field(type=FieldType.Long, name="pdServiceId")
    private Long pdServiceId;
    @Field(type=FieldType.Long, name="pdServiceVersions")
    private List<Long> pdServiceVersions;
    @Field(type=FieldType.Long, name="linkedIssuePdServiceIds")
    private List<Long> linkedIssuePdServiceIds;
    @Field(type=FieldType.Long, name="linkedIssuePdServiceVersions")
    private List<Long> linkedIssuePdServiceVersions;
    @Field(type=FieldType.Keyword, name="linkedIssues")
    private List<String> linkedIssues;
    @Field(type=FieldType.Keyword, name="jira_server_id")
    private String jira_server_id;
    @Field(type=FieldType.Keyword, name="key")
    private String key;
    @Field(type=FieldType.Keyword, name="parentReqKey")
    private String parentReqKey;
    @Field(type=FieldType.Keyword, name="upperKey")
    private String upperKey;
    @Field(type=FieldType.Auto, name="issueID")
    private String issueID;
    @Field(type=FieldType.Text, name="self")
    private String self;
    @Field(type=FieldType.Date, name="@timestamp")
    @JsonProperty(value="@timestamp")
    @ElasticSearchUpdateDate
    private Date timestamp;
    @Field(type=FieldType.Auto, name="etc")
    private Object etc;
    @Field(type=FieldType.Percolator, name="queries")
    @JsonProperty(value="queries")
    private List<String> percolatorQueries;
    private Project project;
    private IssueType issuetype;
    private Creator creator;
    private Reporter reporter;
    private Assignee assignee;
    @Field(type=FieldType.Text)
    private List<String> labels;
    private Priority priority;
    private \uc0c1\ud0dc status;
    @Field(type=FieldType.Keyword, name="armsStateCategory")
    @JsonProperty(value="armsStateCategory")
    private String armsStateCategory;
    private Resolution resolution;
    @Field(type=FieldType.Text, name="resolutiondate")
    private String resolutiondate;
    @Field(type=FieldType.Date, name="created")
    private Date created;
    @Field(type=FieldType.Date, name="updated")
    private Date updated;
    @Field(type=FieldType.Date, name="overallUpdatedDate")
    private Date overallUpdatedDate;
    private Deleted deleted;
    private List<Worklogs> worklogs;
    @Field(type=FieldType.Integer, name="timespent")
    private Integer timespent;
    @Field(type=FieldType.Text, name="summary")
    private String summary;
    private CReqProperty cReqProperty;
    @JsonIgnore
    @Field(type=FieldType.Text, name="rawData")
    private String rawData;

    public AlmIssueEntity() {
    }

    public void generateId() {
        this.recentId = this.jira_server_id + "_" + this.project.key + "_" + this.key;
    }

    public boolean izEmpty() {
        return this.recentId == null || this.recentId.isEmpty();
    }

    public boolean izNotEmpty() {
        return !this.izEmpty();
    }

    public String recentId() {
        return this.recentId;
    }

    public String recentIdByNewKey(String newKey) {
        return this.jira_server_id + "_" + this.project.key + "_" + newKey;
    }

    private void modifyKey(String projectKey, String newKey) {
        this.key = newKey;
        this.project.key = projectKey;
        this.recentId = this.recentIdByNewKey(newKey);
    }

    public void modifyProjectKeyAndKey(String projectKey, String newKey) {
        this.modifyKey(projectKey, newKey);
    }

    public boolean isNeedOverallUpdatedDate(AlmIssueEntity targetAlmIssueEntity) {
        if (targetAlmIssueEntity.getUpdated() == null) {
            return false;
        }
        return this.overallUpdatedDate.after(targetAlmIssueEntity.getUpdated());
    }

    public boolean izReqTrue() {
        return this.isReq != null && this.isReq != false;
    }

    public boolean izReqFalse() {
        return !this.izReqTrue();
    }

    public String stringValueOfCreatedDate() {
        if (this.created != null) {
            ZonedDateTime zdt = this.created.toInstant().atZone(ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return zdt.format(formatter);
        }
        return null;
    }

    public String stringValueOfUpdatedDate() {
        if (this.updated != null) {
            ZonedDateTime zdt = this.updated.toInstant().atZone(ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return zdt.format(formatter);
        }
        return null;
    }

    @RollingIndexName
    public String localDate() {
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return now.format(formatter);
    }

    @Generated
    public static AlmIssueEntityBuilder builder() {
        return new AlmIssueEntityBuilder();
    }

    @Generated
    public AlmIssueEntityBuilder toBuilder() {
        return new AlmIssueEntityBuilder().id(this.id).recentId(this.recentId).recent(this.recent).isReq(this.isReq).cReqLink(this.cReqLink).cReqStatusId(this.cReqStatusId).pdServiceId(this.pdServiceId).pdServiceVersions(this.pdServiceVersions).linkedIssuePdServiceIds(this.linkedIssuePdServiceIds).linkedIssuePdServiceVersions(this.linkedIssuePdServiceVersions).linkedIssues(this.linkedIssues).jira_server_id(this.jira_server_id).key(this.key).parentReqKey(this.parentReqKey).upperKey(this.upperKey).issueID(this.issueID).self(this.self).timestamp(this.timestamp).etc(this.etc).percolatorQueries(this.percolatorQueries).project(this.project).issuetype(this.issuetype).creator(this.creator).reporter(this.reporter).assignee(this.assignee).labels(this.labels).priority(this.priority).status(this.status).armsStateCategory(this.armsStateCategory).resolution(this.resolution).resolutiondate(this.resolutiondate).created(this.created).updated(this.updated).overallUpdatedDate(this.overallUpdatedDate).deleted(this.deleted).worklogs(this.worklogs).timespent(this.timespent).summary(this.summary).cReqProperty(this.cReqProperty).rawData(this.rawData);
    }

    @Generated
    public AlmIssueEntity(String id, String recentId, boolean recent, Boolean isReq, Long cReqLink, Long cReqStatusId, Long pdServiceId, List<Long> pdServiceVersions, List<Long> linkedIssuePdServiceIds, List<Long> linkedIssuePdServiceVersions, List<String> linkedIssues, String jira_server_id, String key, String parentReqKey, String upperKey, String issueID, String self, Date timestamp, Object etc, List<String> percolatorQueries, Project project, IssueType issuetype, Creator creator, Reporter reporter, Assignee assignee, List<String> labels, Priority priority, \uc0c1\ud0dc status, String armsStateCategory, Resolution resolution, String resolutiondate, Date created, Date updated, Date overallUpdatedDate, Deleted deleted, List<Worklogs> worklogs, Integer timespent, String summary, CReqProperty cReqProperty, String rawData) {
        this.id = id;
        this.recentId = recentId;
        this.recent = recent;
        this.isReq = isReq;
        this.cReqLink = cReqLink;
        this.cReqStatusId = cReqStatusId;
        this.pdServiceId = pdServiceId;
        this.pdServiceVersions = pdServiceVersions;
        this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
        this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
        this.linkedIssues = linkedIssues;
        this.jira_server_id = jira_server_id;
        this.key = key;
        this.parentReqKey = parentReqKey;
        this.upperKey = upperKey;
        this.issueID = issueID;
        this.self = self;
        this.timestamp = timestamp;
        this.etc = etc;
        this.percolatorQueries = percolatorQueries;
        this.project = project;
        this.issuetype = issuetype;
        this.creator = creator;
        this.reporter = reporter;
        this.assignee = assignee;
        this.labels = labels;
        this.priority = priority;
        this.status = status;
        this.armsStateCategory = armsStateCategory;
        this.resolution = resolution;
        this.resolutiondate = resolutiondate;
        this.created = created;
        this.updated = updated;
        this.overallUpdatedDate = overallUpdatedDate;
        this.deleted = deleted;
        this.worklogs = worklogs;
        this.timespent = timespent;
        this.summary = summary;
        this.cReqProperty = cReqProperty;
        this.rawData = rawData;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setRecentId(String recentId) {
        this.recentId = recentId;
    }

    @Generated
    public void setRecent(boolean recent) {
        this.recent = recent;
    }

    @Generated
    public void setIsReq(Boolean isReq) {
        this.isReq = isReq;
    }

    @Generated
    public void setCReqLink(Long cReqLink) {
        this.cReqLink = cReqLink;
    }

    @Generated
    public void setCReqStatusId(Long cReqStatusId) {
        this.cReqStatusId = cReqStatusId;
    }

    @Generated
    public void setPdServiceId(Long pdServiceId) {
        this.pdServiceId = pdServiceId;
    }

    @Generated
    public void setPdServiceVersions(List<Long> pdServiceVersions) {
        this.pdServiceVersions = pdServiceVersions;
    }

    @Generated
    public void setLinkedIssuePdServiceIds(List<Long> linkedIssuePdServiceIds) {
        this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
    }

    @Generated
    public void setLinkedIssuePdServiceVersions(List<Long> linkedIssuePdServiceVersions) {
        this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
    }

    @Generated
    public void setLinkedIssues(List<String> linkedIssues) {
        this.linkedIssues = linkedIssues;
    }

    @Generated
    public void setJira_server_id(String jira_server_id) {
        this.jira_server_id = jira_server_id;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setParentReqKey(String parentReqKey) {
        this.parentReqKey = parentReqKey;
    }

    @Generated
    public void setUpperKey(String upperKey) {
        this.upperKey = upperKey;
    }

    @Generated
    public void setIssueID(String issueID) {
        this.issueID = issueID;
    }

    @Generated
    public void setSelf(String self) {
        this.self = self;
    }

    @Generated
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setEtc(Object etc) {
        this.etc = etc;
    }

    @Generated
    public void setPercolatorQueries(List<String> percolatorQueries) {
        this.percolatorQueries = percolatorQueries;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setIssuetype(IssueType issuetype) {
        this.issuetype = issuetype;
    }

    @Generated
    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @Generated
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Generated
    public void setAssignee(Assignee assignee) {
        this.assignee = assignee;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Generated
    public void setStatus(\uc0c1\ud0dc status) {
        this.status = status;
    }

    @Generated
    public void setArmsStateCategory(String armsStateCategory) {
        this.armsStateCategory = armsStateCategory;
    }

    @Generated
    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    @Generated
    public void setResolutiondate(String resolutiondate) {
        this.resolutiondate = resolutiondate;
    }

    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @Generated
    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Generated
    public void setOverallUpdatedDate(Date overallUpdatedDate) {
        this.overallUpdatedDate = overallUpdatedDate;
    }

    @Generated
    public void setDeleted(Deleted deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setWorklogs(List<Worklogs> worklogs) {
        this.worklogs = worklogs;
    }

    @Generated
    public void setTimespent(Integer timespent) {
        this.timespent = timespent;
    }

    @Generated
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Generated
    public void setCReqProperty(CReqProperty cReqProperty) {
        this.cReqProperty = cReqProperty;
    }

    @Generated
    public void setRawData(String rawData) {
        this.rawData = rawData;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getRecentId() {
        return this.recentId;
    }

    @Generated
    public boolean isRecent() {
        return this.recent;
    }

    @Generated
    public Boolean getIsReq() {
        return this.isReq;
    }

    @Generated
    public Long getCReqLink() {
        return this.cReqLink;
    }

    @Generated
    public Long getCReqStatusId() {
        return this.cReqStatusId;
    }

    @Generated
    public Long getPdServiceId() {
        return this.pdServiceId;
    }

    @Generated
    public List<Long> getPdServiceVersions() {
        return this.pdServiceVersions;
    }

    @Generated
    public List<Long> getLinkedIssuePdServiceIds() {
        return this.linkedIssuePdServiceIds;
    }

    @Generated
    public List<Long> getLinkedIssuePdServiceVersions() {
        return this.linkedIssuePdServiceVersions;
    }

    @Generated
    public List<String> getLinkedIssues() {
        return this.linkedIssues;
    }

    @Generated
    public String getJira_server_id() {
        return this.jira_server_id;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getParentReqKey() {
        return this.parentReqKey;
    }

    @Generated
    public String getUpperKey() {
        return this.upperKey;
    }

    @Generated
    public String getIssueID() {
        return this.issueID;
    }

    @Generated
    public String getSelf() {
        return this.self;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Object getEtc() {
        return this.etc;
    }

    @Generated
    public List<String> getPercolatorQueries() {
        return this.percolatorQueries;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public IssueType getIssuetype() {
        return this.issuetype;
    }

    @Generated
    public Creator getCreator() {
        return this.creator;
    }

    @Generated
    public Reporter getReporter() {
        return this.reporter;
    }

    @Generated
    public Assignee getAssignee() {
        return this.assignee;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Priority getPriority() {
        return this.priority;
    }

    @Generated
    public \uc0c1\ud0dc getStatus() {
        return this.status;
    }

    @Generated
    public String getArmsStateCategory() {
        return this.armsStateCategory;
    }

    @Generated
    public Resolution getResolution() {
        return this.resolution;
    }

    @Generated
    public String getResolutiondate() {
        return this.resolutiondate;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public Date getUpdated() {
        return this.updated;
    }

    @Generated
    public Date getOverallUpdatedDate() {
        return this.overallUpdatedDate;
    }

    @Generated
    public Deleted getDeleted() {
        return this.deleted;
    }

    @Generated
    public List<Worklogs> getWorklogs() {
        return this.worklogs;
    }

    @Generated
    public Integer getTimespent() {
        return this.timespent;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public CReqProperty getCReqProperty() {
        return this.cReqProperty;
    }

    @Generated
    public String getRawData() {
        return this.rawData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlmIssueEntity)) {
            return false;
        }
        AlmIssueEntity other = (AlmIssueEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isReq = this.getIsReq();
        Boolean other$isReq = other.getIsReq();
        if (this$isReq == null ? other$isReq != null : !((Object)this$isReq).equals(other$isReq)) {
            return false;
        }
        Long this$cReqLink = this.getCReqLink();
        Long other$cReqLink = other.getCReqLink();
        if (this$cReqLink == null ? other$cReqLink != null : !((Object)this$cReqLink).equals(other$cReqLink)) {
            return false;
        }
        Long this$cReqStatusId = this.getCReqStatusId();
        Long other$cReqStatusId = other.getCReqStatusId();
        if (this$cReqStatusId == null ? other$cReqStatusId != null : !((Object)this$cReqStatusId).equals(other$cReqStatusId)) {
            return false;
        }
        Long this$pdServiceId = this.getPdServiceId();
        Long other$pdServiceId = other.getPdServiceId();
        if (this$pdServiceId == null ? other$pdServiceId != null : !((Object)this$pdServiceId).equals(other$pdServiceId)) {
            return false;
        }
        Integer this$timespent = this.getTimespent();
        Integer other$timespent = other.getTimespent();
        if (this$timespent == null ? other$timespent != null : !((Object)this$timespent).equals(other$timespent)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$recentId = this.getRecentId();
        String other$recentId = other.getRecentId();
        if (this$recentId == null ? other$recentId != null : !this$recentId.equals(other$recentId)) {
            return false;
        }
        List<Long> this$pdServiceVersions = this.getPdServiceVersions();
        List<Long> other$pdServiceVersions = other.getPdServiceVersions();
        if (this$pdServiceVersions == null ? other$pdServiceVersions != null : !((Object)this$pdServiceVersions).equals(other$pdServiceVersions)) {
            return false;
        }
        List<Long> this$linkedIssuePdServiceIds = this.getLinkedIssuePdServiceIds();
        List<Long> other$linkedIssuePdServiceIds = other.getLinkedIssuePdServiceIds();
        if (this$linkedIssuePdServiceIds == null ? other$linkedIssuePdServiceIds != null : !((Object)this$linkedIssuePdServiceIds).equals(other$linkedIssuePdServiceIds)) {
            return false;
        }
        List<Long> this$linkedIssuePdServiceVersions = this.getLinkedIssuePdServiceVersions();
        List<Long> other$linkedIssuePdServiceVersions = other.getLinkedIssuePdServiceVersions();
        if (this$linkedIssuePdServiceVersions == null ? other$linkedIssuePdServiceVersions != null : !((Object)this$linkedIssuePdServiceVersions).equals(other$linkedIssuePdServiceVersions)) {
            return false;
        }
        List<String> this$linkedIssues = this.getLinkedIssues();
        List<String> other$linkedIssues = other.getLinkedIssues();
        if (this$linkedIssues == null ? other$linkedIssues != null : !((Object)this$linkedIssues).equals(other$linkedIssues)) {
            return false;
        }
        String this$jira_server_id = this.getJira_server_id();
        String other$jira_server_id = other.getJira_server_id();
        if (this$jira_server_id == null ? other$jira_server_id != null : !this$jira_server_id.equals(other$jira_server_id)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$parentReqKey = this.getParentReqKey();
        String other$parentReqKey = other.getParentReqKey();
        if (this$parentReqKey == null ? other$parentReqKey != null : !this$parentReqKey.equals(other$parentReqKey)) {
            return false;
        }
        String this$upperKey = this.getUpperKey();
        String other$upperKey = other.getUpperKey();
        if (this$upperKey == null ? other$upperKey != null : !this$upperKey.equals(other$upperKey)) {
            return false;
        }
        String this$issueID = this.getIssueID();
        String other$issueID = other.getIssueID();
        if (this$issueID == null ? other$issueID != null : !this$issueID.equals(other$issueID)) {
            return false;
        }
        String this$self = this.getSelf();
        String other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Object this$etc = this.getEtc();
        Object other$etc = other.getEtc();
        if (this$etc == null ? other$etc != null : !this$etc.equals(other$etc)) {
            return false;
        }
        List<String> this$percolatorQueries = this.getPercolatorQueries();
        List<String> other$percolatorQueries = other.getPercolatorQueries();
        if (this$percolatorQueries == null ? other$percolatorQueries != null : !((Object)this$percolatorQueries).equals(other$percolatorQueries)) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        IssueType this$issuetype = this.getIssuetype();
        IssueType other$issuetype = other.getIssuetype();
        if (this$issuetype == null ? other$issuetype != null : !((Object)this$issuetype).equals(other$issuetype)) {
            return false;
        }
        Creator this$creator = this.getCreator();
        Creator other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !((Object)this$creator).equals(other$creator)) {
            return false;
        }
        Reporter this$reporter = this.getReporter();
        Reporter other$reporter = other.getReporter();
        if (this$reporter == null ? other$reporter != null : !((Object)this$reporter).equals(other$reporter)) {
            return false;
        }
        Assignee this$assignee = this.getAssignee();
        Assignee other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !((Object)this$assignee).equals(other$assignee)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Priority this$priority = this.getPriority();
        Priority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        \uc0c1\ud0dc this$status = this.getStatus();
        \uc0c1\ud0dc other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$armsStateCategory = this.getArmsStateCategory();
        String other$armsStateCategory = other.getArmsStateCategory();
        if (this$armsStateCategory == null ? other$armsStateCategory != null : !this$armsStateCategory.equals(other$armsStateCategory)) {
            return false;
        }
        Resolution this$resolution = this.getResolution();
        Resolution other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !((Object)this$resolution).equals(other$resolution)) {
            return false;
        }
        String this$resolutiondate = this.getResolutiondate();
        String other$resolutiondate = other.getResolutiondate();
        if (this$resolutiondate == null ? other$resolutiondate != null : !this$resolutiondate.equals(other$resolutiondate)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Date this$updated = this.getUpdated();
        Date other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        Date this$overallUpdatedDate = this.getOverallUpdatedDate();
        Date other$overallUpdatedDate = other.getOverallUpdatedDate();
        if (this$overallUpdatedDate == null ? other$overallUpdatedDate != null : !((Object)this$overallUpdatedDate).equals(other$overallUpdatedDate)) {
            return false;
        }
        Deleted this$deleted = this.getDeleted();
        Deleted other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        List<Worklogs> this$worklogs = this.getWorklogs();
        List<Worklogs> other$worklogs = other.getWorklogs();
        if (this$worklogs == null ? other$worklogs != null : !((Object)this$worklogs).equals(other$worklogs)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        CReqProperty this$cReqProperty = this.getCReqProperty();
        CReqProperty other$cReqProperty = other.getCReqProperty();
        return !(this$cReqProperty == null ? other$cReqProperty != null : !((Object)this$cReqProperty).equals(other$cReqProperty));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlmIssueEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isReq = this.getIsReq();
        result = result * 59 + ($isReq == null ? 43 : ((Object)$isReq).hashCode());
        Long $cReqLink = this.getCReqLink();
        result = result * 59 + ($cReqLink == null ? 43 : ((Object)$cReqLink).hashCode());
        Long $cReqStatusId = this.getCReqStatusId();
        result = result * 59 + ($cReqStatusId == null ? 43 : ((Object)$cReqStatusId).hashCode());
        Long $pdServiceId = this.getPdServiceId();
        result = result * 59 + ($pdServiceId == null ? 43 : ((Object)$pdServiceId).hashCode());
        Integer $timespent = this.getTimespent();
        result = result * 59 + ($timespent == null ? 43 : ((Object)$timespent).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $recentId = this.getRecentId();
        result = result * 59 + ($recentId == null ? 43 : $recentId.hashCode());
        List<Long> $pdServiceVersions = this.getPdServiceVersions();
        result = result * 59 + ($pdServiceVersions == null ? 43 : ((Object)$pdServiceVersions).hashCode());
        List<Long> $linkedIssuePdServiceIds = this.getLinkedIssuePdServiceIds();
        result = result * 59 + ($linkedIssuePdServiceIds == null ? 43 : ((Object)$linkedIssuePdServiceIds).hashCode());
        List<Long> $linkedIssuePdServiceVersions = this.getLinkedIssuePdServiceVersions();
        result = result * 59 + ($linkedIssuePdServiceVersions == null ? 43 : ((Object)$linkedIssuePdServiceVersions).hashCode());
        List<String> $linkedIssues = this.getLinkedIssues();
        result = result * 59 + ($linkedIssues == null ? 43 : ((Object)$linkedIssues).hashCode());
        String $jira_server_id = this.getJira_server_id();
        result = result * 59 + ($jira_server_id == null ? 43 : $jira_server_id.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $parentReqKey = this.getParentReqKey();
        result = result * 59 + ($parentReqKey == null ? 43 : $parentReqKey.hashCode());
        String $upperKey = this.getUpperKey();
        result = result * 59 + ($upperKey == null ? 43 : $upperKey.hashCode());
        String $issueID = this.getIssueID();
        result = result * 59 + ($issueID == null ? 43 : $issueID.hashCode());
        String $self = this.getSelf();
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Object $etc = this.getEtc();
        result = result * 59 + ($etc == null ? 43 : $etc.hashCode());
        List<String> $percolatorQueries = this.getPercolatorQueries();
        result = result * 59 + ($percolatorQueries == null ? 43 : ((Object)$percolatorQueries).hashCode());
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        IssueType $issuetype = this.getIssuetype();
        result = result * 59 + ($issuetype == null ? 43 : ((Object)$issuetype).hashCode());
        Creator $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : ((Object)$creator).hashCode());
        Reporter $reporter = this.getReporter();
        result = result * 59 + ($reporter == null ? 43 : ((Object)$reporter).hashCode());
        Assignee $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : ((Object)$assignee).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Priority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        \uc0c1\ud0dc $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $armsStateCategory = this.getArmsStateCategory();
        result = result * 59 + ($armsStateCategory == null ? 43 : $armsStateCategory.hashCode());
        Resolution $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : ((Object)$resolution).hashCode());
        String $resolutiondate = this.getResolutiondate();
        result = result * 59 + ($resolutiondate == null ? 43 : $resolutiondate.hashCode());
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Date $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        Date $overallUpdatedDate = this.getOverallUpdatedDate();
        result = result * 59 + ($overallUpdatedDate == null ? 43 : ((Object)$overallUpdatedDate).hashCode());
        Deleted $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        List<Worklogs> $worklogs = this.getWorklogs();
        result = result * 59 + ($worklogs == null ? 43 : ((Object)$worklogs).hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        CReqProperty $cReqProperty = this.getCReqProperty();
        result = result * 59 + ($cReqProperty == null ? 43 : ((Object)$cReqProperty).hashCode());
        return result;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Project {
        @Field(type=FieldType.Text, name="project_self")
        @JsonProperty(value="project_self")
        private String self;
        @Field(type=FieldType.Text, name="project_id")
        @JsonProperty(value="project_id")
        private String id;
        @Field(type=FieldType.Text, name="project_key")
        @JsonProperty(value="project_key")
        private String key;
        @Field(type=FieldType.Text, name="project_name")
        @JsonProperty(value="project_name")
        private String name;

        @Generated
        public static ProjectBuilder builder() {
            return new ProjectBuilder();
        }

        @Generated
        public String getSelf() {
            return this.self;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setSelf(String self) {
            this.self = self;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Project(self=" + this.getSelf() + ", id=" + this.getId() + ", key=" + this.getKey() + ", name=" + this.getName() + ")";
        }

        @Generated
        public Project() {
        }

        @Generated
        public Project(String self, String id, String key, String name) {
            this.self = self;
            this.id = id;
            this.key = key;
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Project)) {
                return false;
            }
            Project other = (Project)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$self = this.getSelf();
            String other$self = other.getSelf();
            if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Project;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : $self.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public static class ProjectBuilder {
            @Generated
            private String self;
            @Generated
            private String id;
            @Generated
            private String key;
            @Generated
            private String name;

            @Generated
            ProjectBuilder() {
            }

            @JsonProperty(value="project_self")
            @Generated
            public ProjectBuilder self(String self) {
                this.self = self;
                return this;
            }

            @JsonProperty(value="project_id")
            @Generated
            public ProjectBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="project_key")
            @Generated
            public ProjectBuilder key(String key) {
                this.key = key;
                return this;
            }

            @JsonProperty(value="project_name")
            @Generated
            public ProjectBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public Project build() {
                return new Project(this.self, this.id, this.key, this.name);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Project.ProjectBuilder(self=" + this.self + ", id=" + this.id + ", key=" + this.key + ", name=" + this.name + ")";
            }
        }
    }

    @Generated
    public static class AlmIssueEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String recentId;
        @Generated
        private boolean recent;
        @Generated
        private Boolean isReq;
        @Generated
        private Long cReqLink;
        @Generated
        private Long cReqStatusId;
        @Generated
        private Long pdServiceId;
        @Generated
        private List<Long> pdServiceVersions;
        @Generated
        private List<Long> linkedIssuePdServiceIds;
        @Generated
        private List<Long> linkedIssuePdServiceVersions;
        @Generated
        private List<String> linkedIssues;
        @Generated
        private String jira_server_id;
        @Generated
        private String key;
        @Generated
        private String parentReqKey;
        @Generated
        private String upperKey;
        @Generated
        private String issueID;
        @Generated
        private String self;
        @Generated
        private Date timestamp;
        @Generated
        private Object etc;
        @Generated
        private List<String> percolatorQueries;
        @Generated
        private Project project;
        @Generated
        private IssueType issuetype;
        @Generated
        private Creator creator;
        @Generated
        private Reporter reporter;
        @Generated
        private Assignee assignee;
        @Generated
        private List<String> labels;
        @Generated
        private Priority priority;
        @Generated
        private \uc0c1\ud0dc status;
        @Generated
        private String armsStateCategory;
        @Generated
        private Resolution resolution;
        @Generated
        private String resolutiondate;
        @Generated
        private Date created;
        @Generated
        private Date updated;
        @Generated
        private Date overallUpdatedDate;
        @Generated
        private Deleted deleted;
        @Generated
        private List<Worklogs> worklogs;
        @Generated
        private Integer timespent;
        @Generated
        private String summary;
        @Generated
        private CReqProperty cReqProperty;
        @Generated
        private String rawData;

        @Generated
        AlmIssueEntityBuilder() {
        }

        @Generated
        public AlmIssueEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="recent_id")
        @Generated
        public AlmIssueEntityBuilder recentId(String recentId) {
            this.recentId = recentId;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder recent(boolean recent) {
            this.recent = recent;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder isReq(Boolean isReq) {
            this.isReq = isReq;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder cReqLink(Long cReqLink) {
            this.cReqLink = cReqLink;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder cReqStatusId(Long cReqStatusId) {
            this.cReqStatusId = cReqStatusId;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder pdServiceId(Long pdServiceId) {
            this.pdServiceId = pdServiceId;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder pdServiceVersions(List<Long> pdServiceVersions) {
            this.pdServiceVersions = pdServiceVersions;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder linkedIssuePdServiceIds(List<Long> linkedIssuePdServiceIds) {
            this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder linkedIssuePdServiceVersions(List<Long> linkedIssuePdServiceVersions) {
            this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder linkedIssues(List<String> linkedIssues) {
            this.linkedIssues = linkedIssues;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder jira_server_id(String jira_server_id) {
            this.jira_server_id = jira_server_id;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder parentReqKey(String parentReqKey) {
            this.parentReqKey = parentReqKey;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder upperKey(String upperKey) {
            this.upperKey = upperKey;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder issueID(String issueID) {
            this.issueID = issueID;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder self(String self) {
            this.self = self;
            return this;
        }

        @JsonProperty(value="@timestamp")
        @Generated
        public AlmIssueEntityBuilder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder etc(Object etc) {
            this.etc = etc;
            return this;
        }

        @JsonProperty(value="queries")
        @Generated
        public AlmIssueEntityBuilder percolatorQueries(List<String> percolatorQueries) {
            this.percolatorQueries = percolatorQueries;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder project(Project project) {
            this.project = project;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder issuetype(IssueType issuetype) {
            this.issuetype = issuetype;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder creator(Creator creator) {
            this.creator = creator;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder assignee(Assignee assignee) {
            this.assignee = assignee;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder priority(Priority priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder status(\uc0c1\ud0dc status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="armsStateCategory")
        @Generated
        public AlmIssueEntityBuilder armsStateCategory(String armsStateCategory) {
            this.armsStateCategory = armsStateCategory;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder resolutiondate(String resolutiondate) {
            this.resolutiondate = resolutiondate;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder created(Date created) {
            this.created = created;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder overallUpdatedDate(Date overallUpdatedDate) {
            this.overallUpdatedDate = overallUpdatedDate;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder deleted(Deleted deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder worklogs(List<Worklogs> worklogs) {
            this.worklogs = worklogs;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder timespent(Integer timespent) {
            this.timespent = timespent;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        @Generated
        public AlmIssueEntityBuilder cReqProperty(CReqProperty cReqProperty) {
            this.cReqProperty = cReqProperty;
            return this;
        }

        @JsonIgnore
        @Generated
        public AlmIssueEntityBuilder rawData(String rawData) {
            this.rawData = rawData;
            return this;
        }

        @Generated
        public AlmIssueEntity build() {
            return new AlmIssueEntity(this.id, this.recentId, this.recent, this.isReq, this.cReqLink, this.cReqStatusId, this.pdServiceId, this.pdServiceVersions, this.linkedIssuePdServiceIds, this.linkedIssuePdServiceVersions, this.linkedIssues, this.jira_server_id, this.key, this.parentReqKey, this.upperKey, this.issueID, this.self, this.timestamp, this.etc, this.percolatorQueries, this.project, this.issuetype, this.creator, this.reporter, this.assignee, this.labels, this.priority, this.status, this.armsStateCategory, this.resolution, this.resolutiondate, this.created, this.updated, this.overallUpdatedDate, this.deleted, this.worklogs, this.timespent, this.summary, this.cReqProperty, this.rawData);
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.AlmIssueEntityBuilder(id=" + this.id + ", recentId=" + this.recentId + ", recent=" + this.recent + ", isReq=" + this.isReq + ", cReqLink=" + this.cReqLink + ", cReqStatusId=" + this.cReqStatusId + ", pdServiceId=" + this.pdServiceId + ", pdServiceVersions=" + String.valueOf(this.pdServiceVersions) + ", linkedIssuePdServiceIds=" + String.valueOf(this.linkedIssuePdServiceIds) + ", linkedIssuePdServiceVersions=" + String.valueOf(this.linkedIssuePdServiceVersions) + ", linkedIssues=" + String.valueOf(this.linkedIssues) + ", jira_server_id=" + this.jira_server_id + ", key=" + this.key + ", parentReqKey=" + this.parentReqKey + ", upperKey=" + this.upperKey + ", issueID=" + this.issueID + ", self=" + this.self + ", timestamp=" + String.valueOf(this.timestamp) + ", etc=" + String.valueOf(this.etc) + ", percolatorQueries=" + String.valueOf(this.percolatorQueries) + ", project=" + String.valueOf(this.project) + ", issuetype=" + String.valueOf(this.issuetype) + ", creator=" + String.valueOf(this.creator) + ", reporter=" + String.valueOf(this.reporter) + ", assignee=" + String.valueOf(this.assignee) + ", labels=" + String.valueOf(this.labels) + ", priority=" + String.valueOf(this.priority) + ", status=" + String.valueOf(this.status) + ", armsStateCategory=" + this.armsStateCategory + ", resolution=" + String.valueOf(this.resolution) + ", resolutiondate=" + this.resolutiondate + ", created=" + String.valueOf(this.created) + ", updated=" + String.valueOf(this.updated) + ", overallUpdatedDate=" + String.valueOf(this.overallUpdatedDate) + ", deleted=" + String.valueOf(this.deleted) + ", worklogs=" + String.valueOf(this.worklogs) + ", timespent=" + this.timespent + ", summary=" + this.summary + ", cReqProperty=" + String.valueOf(this.cReqProperty) + ", rawData=" + this.rawData + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class IssueType {
        @Field(type=FieldType.Text, name="issuetype_self")
        @JsonProperty(value="issuetype_self")
        private String self;
        @Field(type=FieldType.Text, name="issuetype_id")
        @JsonProperty(value="issuetype_id")
        private String id;
        @Field(type=FieldType.Text, name="issuetype_description")
        @JsonProperty(value="issuetype_description")
        private String description;
        @Field(type=FieldType.Text, name="issuetype_name")
        @JsonProperty(value="issuetype_name")
        private String name;
        @Field(type=FieldType.Boolean, name="issuetype_subtask")
        @JsonProperty(value="issuetype_subtask")
        private Boolean subtask;
        @Field(type=FieldType.Text, name="issuetype_untranslatedName")
        @JsonProperty(value="issuetype_untranslatedName")
        private String untranslatedName;
        @Field(type=FieldType.Integer, name="issuetype_hierarchyLevel")
        @JsonProperty(value="issuetype_hierarchyLevel")
        private Integer hierarchyLevel;

        @Generated
        public static IssueTypeBuilder builder() {
            return new IssueTypeBuilder();
        }

        @Generated
        public String getSelf() {
            return this.self;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Boolean getSubtask() {
            return this.subtask;
        }

        @Generated
        public String getUntranslatedName() {
            return this.untranslatedName;
        }

        @Generated
        public Integer getHierarchyLevel() {
            return this.hierarchyLevel;
        }

        @Generated
        public void setSelf(String self) {
            this.self = self;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setSubtask(Boolean subtask) {
            this.subtask = subtask;
        }

        @Generated
        public void setUntranslatedName(String untranslatedName) {
            this.untranslatedName = untranslatedName;
        }

        @Generated
        public void setHierarchyLevel(Integer hierarchyLevel) {
            this.hierarchyLevel = hierarchyLevel;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.IssueType(self=" + this.getSelf() + ", id=" + this.getId() + ", description=" + this.getDescription() + ", name=" + this.getName() + ", subtask=" + this.getSubtask() + ", untranslatedName=" + this.getUntranslatedName() + ", hierarchyLevel=" + this.getHierarchyLevel() + ")";
        }

        @Generated
        public IssueType() {
        }

        @Generated
        public IssueType(String self, String id, String description, String name, Boolean subtask, String untranslatedName, Integer hierarchyLevel) {
            this.self = self;
            this.id = id;
            this.description = description;
            this.name = name;
            this.subtask = subtask;
            this.untranslatedName = untranslatedName;
            this.hierarchyLevel = hierarchyLevel;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IssueType)) {
                return false;
            }
            IssueType other = (IssueType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$subtask = this.getSubtask();
            Boolean other$subtask = other.getSubtask();
            if (this$subtask == null ? other$subtask != null : !((Object)this$subtask).equals(other$subtask)) {
                return false;
            }
            Integer this$hierarchyLevel = this.getHierarchyLevel();
            Integer other$hierarchyLevel = other.getHierarchyLevel();
            if (this$hierarchyLevel == null ? other$hierarchyLevel != null : !((Object)this$hierarchyLevel).equals(other$hierarchyLevel)) {
                return false;
            }
            String this$self = this.getSelf();
            String other$self = other.getSelf();
            if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$untranslatedName = this.getUntranslatedName();
            String other$untranslatedName = other.getUntranslatedName();
            return !(this$untranslatedName == null ? other$untranslatedName != null : !this$untranslatedName.equals(other$untranslatedName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IssueType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $subtask = this.getSubtask();
            result = result * 59 + ($subtask == null ? 43 : ((Object)$subtask).hashCode());
            Integer $hierarchyLevel = this.getHierarchyLevel();
            result = result * 59 + ($hierarchyLevel == null ? 43 : ((Object)$hierarchyLevel).hashCode());
            String $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : $self.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $untranslatedName = this.getUntranslatedName();
            result = result * 59 + ($untranslatedName == null ? 43 : $untranslatedName.hashCode());
            return result;
        }

        @Generated
        public static class IssueTypeBuilder {
            @Generated
            private String self;
            @Generated
            private String id;
            @Generated
            private String description;
            @Generated
            private String name;
            @Generated
            private Boolean subtask;
            @Generated
            private String untranslatedName;
            @Generated
            private Integer hierarchyLevel;

            @Generated
            IssueTypeBuilder() {
            }

            @JsonProperty(value="issuetype_self")
            @Generated
            public IssueTypeBuilder self(String self) {
                this.self = self;
                return this;
            }

            @JsonProperty(value="issuetype_id")
            @Generated
            public IssueTypeBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="issuetype_description")
            @Generated
            public IssueTypeBuilder description(String description) {
                this.description = description;
                return this;
            }

            @JsonProperty(value="issuetype_name")
            @Generated
            public IssueTypeBuilder name(String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="issuetype_subtask")
            @Generated
            public IssueTypeBuilder subtask(Boolean subtask) {
                this.subtask = subtask;
                return this;
            }

            @JsonProperty(value="issuetype_untranslatedName")
            @Generated
            public IssueTypeBuilder untranslatedName(String untranslatedName) {
                this.untranslatedName = untranslatedName;
                return this;
            }

            @JsonProperty(value="issuetype_hierarchyLevel")
            @Generated
            public IssueTypeBuilder hierarchyLevel(Integer hierarchyLevel) {
                this.hierarchyLevel = hierarchyLevel;
                return this;
            }

            @Generated
            public IssueType build() {
                return new IssueType(this.self, this.id, this.description, this.name, this.subtask, this.untranslatedName, this.hierarchyLevel);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.IssueType.IssueTypeBuilder(self=" + this.self + ", id=" + this.id + ", description=" + this.description + ", name=" + this.name + ", subtask=" + this.subtask + ", untranslatedName=" + this.untranslatedName + ", hierarchyLevel=" + this.hierarchyLevel + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Creator {
        @Field(type=FieldType.Text, name="creator_accountId")
        @JsonProperty(value="creator_accountId")
        private String accountId;
        @Field(type=FieldType.Text, name="creator_emailAddress")
        @JsonProperty(value="creator_emailAddress")
        private String emailAddress;
        @Field(type=FieldType.Text, name="creator_displayName")
        @JsonProperty(value="creator_displayName")
        private String displayName;

        @Generated
        public static CreatorBuilder builder() {
            return new CreatorBuilder();
        }

        @Generated
        public String getAccountId() {
            return this.accountId;
        }

        @Generated
        public String getEmailAddress() {
            return this.emailAddress;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Generated
        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Creator(accountId=" + this.getAccountId() + ", emailAddress=" + this.getEmailAddress() + ", displayName=" + this.getDisplayName() + ")";
        }

        @Generated
        public Creator() {
        }

        @Generated
        public Creator(String accountId, String emailAddress, String displayName) {
            this.accountId = accountId;
            this.emailAddress = emailAddress;
            this.displayName = displayName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Creator)) {
                return false;
            }
            Creator other = (Creator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accountId = this.getAccountId();
            String other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                return false;
            }
            String this$emailAddress = this.getEmailAddress();
            String other$emailAddress = other.getEmailAddress();
            if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Creator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountId = this.getAccountId();
            result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
            String $emailAddress = this.getEmailAddress();
            result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        @Generated
        public static class CreatorBuilder {
            @Generated
            private String accountId;
            @Generated
            private String emailAddress;
            @Generated
            private String displayName;

            @Generated
            CreatorBuilder() {
            }

            @JsonProperty(value="creator_accountId")
            @Generated
            public CreatorBuilder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            @JsonProperty(value="creator_emailAddress")
            @Generated
            public CreatorBuilder emailAddress(String emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            @JsonProperty(value="creator_displayName")
            @Generated
            public CreatorBuilder displayName(String displayName) {
                this.displayName = displayName;
                return this;
            }

            @Generated
            public Creator build() {
                return new Creator(this.accountId, this.emailAddress, this.displayName);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Creator.CreatorBuilder(accountId=" + this.accountId + ", emailAddress=" + this.emailAddress + ", displayName=" + this.displayName + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Reporter {
        @Field(type=FieldType.Text, name="reporter_accountId")
        @JsonProperty(value="reporter_accountId")
        private String accountId;
        @Field(type=FieldType.Text, name="reporter_emailAddress")
        @JsonProperty(value="reporter_emailAddress")
        private String emailAddress;
        @Field(type=FieldType.Text, name="reporter_displayName")
        @JsonProperty(value="reporter_displayName")
        private String displayName;

        @Generated
        public static ReporterBuilder builder() {
            return new ReporterBuilder();
        }

        @Generated
        public String getAccountId() {
            return this.accountId;
        }

        @Generated
        public String getEmailAddress() {
            return this.emailAddress;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Generated
        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Reporter(accountId=" + this.getAccountId() + ", emailAddress=" + this.getEmailAddress() + ", displayName=" + this.getDisplayName() + ")";
        }

        @Generated
        public Reporter() {
        }

        @Generated
        public Reporter(String accountId, String emailAddress, String displayName) {
            this.accountId = accountId;
            this.emailAddress = emailAddress;
            this.displayName = displayName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reporter)) {
                return false;
            }
            Reporter other = (Reporter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accountId = this.getAccountId();
            String other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                return false;
            }
            String this$emailAddress = this.getEmailAddress();
            String other$emailAddress = other.getEmailAddress();
            if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Reporter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountId = this.getAccountId();
            result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
            String $emailAddress = this.getEmailAddress();
            result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        @Generated
        public static class ReporterBuilder {
            @Generated
            private String accountId;
            @Generated
            private String emailAddress;
            @Generated
            private String displayName;

            @Generated
            ReporterBuilder() {
            }

            @JsonProperty(value="reporter_accountId")
            @Generated
            public ReporterBuilder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            @JsonProperty(value="reporter_emailAddress")
            @Generated
            public ReporterBuilder emailAddress(String emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            @JsonProperty(value="reporter_displayName")
            @Generated
            public ReporterBuilder displayName(String displayName) {
                this.displayName = displayName;
                return this;
            }

            @Generated
            public Reporter build() {
                return new Reporter(this.accountId, this.emailAddress, this.displayName);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Reporter.ReporterBuilder(accountId=" + this.accountId + ", emailAddress=" + this.emailAddress + ", displayName=" + this.displayName + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Assignee {
        @Field(type=FieldType.Text, name="assignee_accountId")
        @JsonProperty(value="assignee_accountId")
        private String accountId;
        @Field(type=FieldType.Text, name="assignee_emailAddress", fielddata=true)
        @JsonProperty(value="assignee_emailAddress")
        private String emailAddress;
        @Field(type=FieldType.Text, name="assignee_displayName")
        @JsonProperty(value="assignee_displayName")
        private String displayName;

        @Generated
        public static AssigneeBuilder builder() {
            return new AssigneeBuilder();
        }

        @Generated
        public String getAccountId() {
            return this.accountId;
        }

        @Generated
        public String getEmailAddress() {
            return this.emailAddress;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Generated
        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Assignee(accountId=" + this.getAccountId() + ", emailAddress=" + this.getEmailAddress() + ", displayName=" + this.getDisplayName() + ")";
        }

        @Generated
        public Assignee() {
        }

        @Generated
        public Assignee(String accountId, String emailAddress, String displayName) {
            this.accountId = accountId;
            this.emailAddress = emailAddress;
            this.displayName = displayName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assignee)) {
                return false;
            }
            Assignee other = (Assignee)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accountId = this.getAccountId();
            String other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                return false;
            }
            String this$emailAddress = this.getEmailAddress();
            String other$emailAddress = other.getEmailAddress();
            if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Assignee;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountId = this.getAccountId();
            result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
            String $emailAddress = this.getEmailAddress();
            result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        @Generated
        public static class AssigneeBuilder {
            @Generated
            private String accountId;
            @Generated
            private String emailAddress;
            @Generated
            private String displayName;

            @Generated
            AssigneeBuilder() {
            }

            @JsonProperty(value="assignee_accountId")
            @Generated
            public AssigneeBuilder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            @JsonProperty(value="assignee_emailAddress")
            @Generated
            public AssigneeBuilder emailAddress(String emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            @JsonProperty(value="assignee_displayName")
            @Generated
            public AssigneeBuilder displayName(String displayName) {
                this.displayName = displayName;
                return this;
            }

            @Generated
            public Assignee build() {
                return new Assignee(this.accountId, this.emailAddress, this.displayName);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Assignee.AssigneeBuilder(accountId=" + this.accountId + ", emailAddress=" + this.emailAddress + ", displayName=" + this.displayName + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Priority {
        @Field(type=FieldType.Text, name="priority_self")
        @JsonProperty(value="priority_self")
        private String self;
        @Field(type=FieldType.Text, name="priority_id")
        @JsonProperty(value="priority_id")
        private String id;
        @Field(type=FieldType.Text, name="priority_name")
        @JsonProperty(value="priority_name")
        private String name;
        @Field(type=FieldType.Text, name="priority_description")
        @JsonProperty(value="priority_description")
        private String description;
        @Field(type=FieldType.Boolean, name="priority_isDefault")
        @JsonProperty(value="priority_isDefault")
        private boolean isDefault;

        @Generated
        public static PriorityBuilder builder() {
            return new PriorityBuilder();
        }

        @Generated
        public String getSelf() {
            return this.self;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public boolean isDefault() {
            return this.isDefault;
        }

        @Generated
        public void setSelf(String self) {
            this.self = self;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Priority(self=" + this.getSelf() + ", id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", isDefault=" + this.isDefault() + ")";
        }

        @Generated
        public Priority() {
        }

        @Generated
        public Priority(String self, String id, String name, String description, boolean isDefault) {
            this.self = self;
            this.id = id;
            this.name = name;
            this.description = description;
            this.isDefault = isDefault;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Priority)) {
                return false;
            }
            Priority other = (Priority)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDefault() != other.isDefault()) {
                return false;
            }
            String this$self = this.getSelf();
            String other$self = other.getSelf();
            if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Priority;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDefault() ? 79 : 97);
            String $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : $self.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public static class PriorityBuilder {
            @Generated
            private String self;
            @Generated
            private String id;
            @Generated
            private String name;
            @Generated
            private String description;
            @Generated
            private boolean isDefault;

            @Generated
            PriorityBuilder() {
            }

            @JsonProperty(value="priority_self")
            @Generated
            public PriorityBuilder self(String self) {
                this.self = self;
                return this;
            }

            @JsonProperty(value="priority_id")
            @Generated
            public PriorityBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="priority_name")
            @Generated
            public PriorityBuilder name(String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="priority_description")
            @Generated
            public PriorityBuilder description(String description) {
                this.description = description;
                return this;
            }

            @JsonProperty(value="priority_isDefault")
            @Generated
            public PriorityBuilder isDefault(boolean isDefault) {
                this.isDefault = isDefault;
                return this;
            }

            @Generated
            public Priority build() {
                return new Priority(this.self, this.id, this.name, this.description, this.isDefault);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Priority.PriorityBuilder(self=" + this.self + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", isDefault=" + this.isDefault + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class \uc0c1\ud0dc {
        @Field(type=FieldType.Text, name="status_self")
        @JsonProperty(value="status_self")
        private String self;
        @Field(type=FieldType.Text, name="status_id")
        @JsonProperty(value="status_id")
        private String id;
        @Field(type=FieldType.Text, name="status_name", fielddata=true)
        @JsonProperty(value="status_name")
        private String name;
        @Field(type=FieldType.Text, name="status_description")
        @JsonProperty(value="status_description")
        private String description;

        @Generated
        public static \uc0c1\ud0dcBuilder builder() {
            return new \uc0c1\ud0dcBuilder();
        }

        @Generated
        public String getSelf() {
            return this.self;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setSelf(String self) {
            this.self = self;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.\uc0c1\ud0dc(self=" + this.getSelf() + ", id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public \uc0c1\ud0dc() {
        }

        @Generated
        public \uc0c1\ud0dc(String self, String id, String name, String description) {
            this.self = self;
            this.id = id;
            this.name = name;
            this.description = description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof \uc0c1\ud0dc)) {
                return false;
            }
            \uc0c1\ud0dc other = (\uc0c1\ud0dc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$self = this.getSelf();
            String other$self = other.getSelf();
            if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof \uc0c1\ud0dc;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : $self.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public static class \uc0c1\ud0dcBuilder {
            @Generated
            private String self;
            @Generated
            private String id;
            @Generated
            private String name;
            @Generated
            private String description;

            @Generated
            \uc0c1\ud0dcBuilder() {
            }

            @JsonProperty(value="status_self")
            @Generated
            public \uc0c1\ud0dcBuilder self(String self) {
                this.self = self;
                return this;
            }

            @JsonProperty(value="status_id")
            @Generated
            public \uc0c1\ud0dcBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="status_name")
            @Generated
            public \uc0c1\ud0dcBuilder name(String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="status_description")
            @Generated
            public \uc0c1\ud0dcBuilder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public \uc0c1\ud0dc build() {
                return new \uc0c1\ud0dc(this.self, this.id, this.name, this.description);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.\uc0c1\ud0dc.\uc0c1\ud0dcBuilder(self=" + this.self + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Resolution {
        @Field(type=FieldType.Text, name="resolution_self")
        @JsonProperty(value="resolution_self")
        private String self;
        @Field(type=FieldType.Text, name="resolution_id")
        @JsonProperty(value="resolution_id")
        private String id;
        @Field(type=FieldType.Text, name="resolution_name")
        @JsonProperty(value="resolution_name")
        private String name;
        @Field(type=FieldType.Text, name="resolution_description")
        @JsonProperty(value="resolution_description")
        private String description;
        @Field(type=FieldType.Boolean, name="resolution_isDefault")
        @JsonProperty(value="resolution_isDefault")
        private boolean isDefault;

        @Generated
        public static ResolutionBuilder builder() {
            return new ResolutionBuilder();
        }

        @Generated
        public String getSelf() {
            return this.self;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public boolean isDefault() {
            return this.isDefault;
        }

        @Generated
        public void setSelf(String self) {
            this.self = self;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Resolution(self=" + this.getSelf() + ", id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", isDefault=" + this.isDefault() + ")";
        }

        @Generated
        public Resolution() {
        }

        @Generated
        public Resolution(String self, String id, String name, String description, boolean isDefault) {
            this.self = self;
            this.id = id;
            this.name = name;
            this.description = description;
            this.isDefault = isDefault;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resolution)) {
                return false;
            }
            Resolution other = (Resolution)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDefault() != other.isDefault()) {
                return false;
            }
            String this$self = this.getSelf();
            String other$self = other.getSelf();
            if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Resolution;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDefault() ? 79 : 97);
            String $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : $self.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public static class ResolutionBuilder {
            @Generated
            private String self;
            @Generated
            private String id;
            @Generated
            private String name;
            @Generated
            private String description;
            @Generated
            private boolean isDefault;

            @Generated
            ResolutionBuilder() {
            }

            @JsonProperty(value="resolution_self")
            @Generated
            public ResolutionBuilder self(String self) {
                this.self = self;
                return this;
            }

            @JsonProperty(value="resolution_id")
            @Generated
            public ResolutionBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="resolution_name")
            @Generated
            public ResolutionBuilder name(String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="resolution_description")
            @Generated
            public ResolutionBuilder description(String description) {
                this.description = description;
                return this;
            }

            @JsonProperty(value="resolution_isDefault")
            @Generated
            public ResolutionBuilder isDefault(boolean isDefault) {
                this.isDefault = isDefault;
                return this;
            }

            @Generated
            public Resolution build() {
                return new Resolution(this.self, this.id, this.name, this.description, this.isDefault);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Resolution.ResolutionBuilder(self=" + this.self + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", isDefault=" + this.isDefault + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Deleted {
        @Field(type=FieldType.Boolean, name="deleted_isDeleted")
        @JsonProperty(value="deleted_isDeleted")
        private Boolean isDeleted;
        @Field(type=FieldType.Date, name="deleted_date")
        @JsonProperty(value="deleted_date")
        private Date deleted_date;

        @Generated
        public static DeletedBuilder builder() {
            return new DeletedBuilder();
        }

        @Generated
        public Boolean getIsDeleted() {
            return this.isDeleted;
        }

        @Generated
        public Date getDeleted_date() {
            return this.deleted_date;
        }

        @Generated
        public void setIsDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        @Generated
        public void setDeleted_date(Date deleted_date) {
            this.deleted_date = deleted_date;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Deleted(isDeleted=" + this.getIsDeleted() + ", deleted_date=" + String.valueOf(this.getDeleted_date()) + ")";
        }

        @Generated
        public Deleted() {
        }

        @Generated
        public Deleted(Boolean isDeleted, Date deleted_date) {
            this.isDeleted = isDeleted;
            this.deleted_date = deleted_date;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Deleted)) {
                return false;
            }
            Deleted other = (Deleted)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isDeleted = this.getIsDeleted();
            Boolean other$isDeleted = other.getIsDeleted();
            if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
                return false;
            }
            Date this$deleted_date = this.getDeleted_date();
            Date other$deleted_date = other.getDeleted_date();
            return !(this$deleted_date == null ? other$deleted_date != null : !((Object)this$deleted_date).equals(other$deleted_date));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Deleted;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isDeleted = this.getIsDeleted();
            result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
            Date $deleted_date = this.getDeleted_date();
            result = result * 59 + ($deleted_date == null ? 43 : ((Object)$deleted_date).hashCode());
            return result;
        }

        @Generated
        public static class DeletedBuilder {
            @Generated
            private Boolean isDeleted;
            @Generated
            private Date deleted_date;

            @Generated
            DeletedBuilder() {
            }

            @JsonProperty(value="deleted_isDeleted")
            @Generated
            public DeletedBuilder isDeleted(Boolean isDeleted) {
                this.isDeleted = isDeleted;
                return this;
            }

            @JsonProperty(value="deleted_date")
            @Generated
            public DeletedBuilder deleted_date(Date deleted_date) {
                this.deleted_date = deleted_date;
                return this;
            }

            @Generated
            public Deleted build() {
                return new Deleted(this.isDeleted, this.deleted_date);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Deleted.DeletedBuilder(isDeleted=" + this.isDeleted + ", deleted_date=" + String.valueOf(this.deleted_date) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class CReqProperty {
        @Field(type=FieldType.Long, name="cReqPriorityLink")
        @JsonProperty(value="cReqPriorityLink")
        private Long cReqPriorityLink;
        @Field(type=FieldType.Keyword, name="cReqPriorityName")
        @JsonProperty(value="cReqPriorityName")
        private String cReqPriorityName;
        @Field(type=FieldType.Long, name="cReqDifficultyLink")
        @JsonProperty(value="cReqDifficultyLink")
        private Long cReqDifficultyLink;
        @Field(type=FieldType.Keyword, name="cReqDifficultyName")
        @JsonProperty(value="cReqDifficultyName")
        private String cReqDifficultyName;
        @Field(type=FieldType.Long, name="cReqStateLink")
        @JsonProperty(value="cReqStateLink")
        private Long cReqStateLink;
        @Field(type=FieldType.Keyword, name="cReqStateName")
        @JsonProperty(value="cReqStateName")
        private String cReqStateName;

        @Generated
        public static CReqPropertyBuilder builder() {
            return new CReqPropertyBuilder();
        }

        @Generated
        public Long getCReqPriorityLink() {
            return this.cReqPriorityLink;
        }

        @Generated
        public String getCReqPriorityName() {
            return this.cReqPriorityName;
        }

        @Generated
        public Long getCReqDifficultyLink() {
            return this.cReqDifficultyLink;
        }

        @Generated
        public String getCReqDifficultyName() {
            return this.cReqDifficultyName;
        }

        @Generated
        public Long getCReqStateLink() {
            return this.cReqStateLink;
        }

        @Generated
        public String getCReqStateName() {
            return this.cReqStateName;
        }

        @Generated
        public void setCReqPriorityLink(Long cReqPriorityLink) {
            this.cReqPriorityLink = cReqPriorityLink;
        }

        @Generated
        public void setCReqPriorityName(String cReqPriorityName) {
            this.cReqPriorityName = cReqPriorityName;
        }

        @Generated
        public void setCReqDifficultyLink(Long cReqDifficultyLink) {
            this.cReqDifficultyLink = cReqDifficultyLink;
        }

        @Generated
        public void setCReqDifficultyName(String cReqDifficultyName) {
            this.cReqDifficultyName = cReqDifficultyName;
        }

        @Generated
        public void setCReqStateLink(Long cReqStateLink) {
            this.cReqStateLink = cReqStateLink;
        }

        @Generated
        public void setCReqStateName(String cReqStateName) {
            this.cReqStateName = cReqStateName;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.CReqProperty(cReqPriorityLink=" + this.getCReqPriorityLink() + ", cReqPriorityName=" + this.getCReqPriorityName() + ", cReqDifficultyLink=" + this.getCReqDifficultyLink() + ", cReqDifficultyName=" + this.getCReqDifficultyName() + ", cReqStateLink=" + this.getCReqStateLink() + ", cReqStateName=" + this.getCReqStateName() + ")";
        }

        @Generated
        public CReqProperty() {
        }

        @Generated
        public CReqProperty(Long cReqPriorityLink, String cReqPriorityName, Long cReqDifficultyLink, String cReqDifficultyName, Long cReqStateLink, String cReqStateName) {
            this.cReqPriorityLink = cReqPriorityLink;
            this.cReqPriorityName = cReqPriorityName;
            this.cReqDifficultyLink = cReqDifficultyLink;
            this.cReqDifficultyName = cReqDifficultyName;
            this.cReqStateLink = cReqStateLink;
            this.cReqStateName = cReqStateName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CReqProperty)) {
                return false;
            }
            CReqProperty other = (CReqProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$cReqPriorityLink = this.getCReqPriorityLink();
            Long other$cReqPriorityLink = other.getCReqPriorityLink();
            if (this$cReqPriorityLink == null ? other$cReqPriorityLink != null : !((Object)this$cReqPriorityLink).equals(other$cReqPriorityLink)) {
                return false;
            }
            Long this$cReqDifficultyLink = this.getCReqDifficultyLink();
            Long other$cReqDifficultyLink = other.getCReqDifficultyLink();
            if (this$cReqDifficultyLink == null ? other$cReqDifficultyLink != null : !((Object)this$cReqDifficultyLink).equals(other$cReqDifficultyLink)) {
                return false;
            }
            Long this$cReqStateLink = this.getCReqStateLink();
            Long other$cReqStateLink = other.getCReqStateLink();
            if (this$cReqStateLink == null ? other$cReqStateLink != null : !((Object)this$cReqStateLink).equals(other$cReqStateLink)) {
                return false;
            }
            String this$cReqPriorityName = this.getCReqPriorityName();
            String other$cReqPriorityName = other.getCReqPriorityName();
            if (this$cReqPriorityName == null ? other$cReqPriorityName != null : !this$cReqPriorityName.equals(other$cReqPriorityName)) {
                return false;
            }
            String this$cReqDifficultyName = this.getCReqDifficultyName();
            String other$cReqDifficultyName = other.getCReqDifficultyName();
            if (this$cReqDifficultyName == null ? other$cReqDifficultyName != null : !this$cReqDifficultyName.equals(other$cReqDifficultyName)) {
                return false;
            }
            String this$cReqStateName = this.getCReqStateName();
            String other$cReqStateName = other.getCReqStateName();
            return !(this$cReqStateName == null ? other$cReqStateName != null : !this$cReqStateName.equals(other$cReqStateName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CReqProperty;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $cReqPriorityLink = this.getCReqPriorityLink();
            result = result * 59 + ($cReqPriorityLink == null ? 43 : ((Object)$cReqPriorityLink).hashCode());
            Long $cReqDifficultyLink = this.getCReqDifficultyLink();
            result = result * 59 + ($cReqDifficultyLink == null ? 43 : ((Object)$cReqDifficultyLink).hashCode());
            Long $cReqStateLink = this.getCReqStateLink();
            result = result * 59 + ($cReqStateLink == null ? 43 : ((Object)$cReqStateLink).hashCode());
            String $cReqPriorityName = this.getCReqPriorityName();
            result = result * 59 + ($cReqPriorityName == null ? 43 : $cReqPriorityName.hashCode());
            String $cReqDifficultyName = this.getCReqDifficultyName();
            result = result * 59 + ($cReqDifficultyName == null ? 43 : $cReqDifficultyName.hashCode());
            String $cReqStateName = this.getCReqStateName();
            result = result * 59 + ($cReqStateName == null ? 43 : $cReqStateName.hashCode());
            return result;
        }

        @Generated
        public static class CReqPropertyBuilder {
            @Generated
            private Long cReqPriorityLink;
            @Generated
            private String cReqPriorityName;
            @Generated
            private Long cReqDifficultyLink;
            @Generated
            private String cReqDifficultyName;
            @Generated
            private Long cReqStateLink;
            @Generated
            private String cReqStateName;

            @Generated
            CReqPropertyBuilder() {
            }

            @JsonProperty(value="cReqPriorityLink")
            @Generated
            public CReqPropertyBuilder cReqPriorityLink(Long cReqPriorityLink) {
                this.cReqPriorityLink = cReqPriorityLink;
                return this;
            }

            @JsonProperty(value="cReqPriorityName")
            @Generated
            public CReqPropertyBuilder cReqPriorityName(String cReqPriorityName) {
                this.cReqPriorityName = cReqPriorityName;
                return this;
            }

            @JsonProperty(value="cReqDifficultyLink")
            @Generated
            public CReqPropertyBuilder cReqDifficultyLink(Long cReqDifficultyLink) {
                this.cReqDifficultyLink = cReqDifficultyLink;
                return this;
            }

            @JsonProperty(value="cReqDifficultyName")
            @Generated
            public CReqPropertyBuilder cReqDifficultyName(String cReqDifficultyName) {
                this.cReqDifficultyName = cReqDifficultyName;
                return this;
            }

            @JsonProperty(value="cReqStateLink")
            @Generated
            public CReqPropertyBuilder cReqStateLink(Long cReqStateLink) {
                this.cReqStateLink = cReqStateLink;
                return this;
            }

            @JsonProperty(value="cReqStateName")
            @Generated
            public CReqPropertyBuilder cReqStateName(String cReqStateName) {
                this.cReqStateName = cReqStateName;
                return this;
            }

            @Generated
            public CReqProperty build() {
                return new CReqProperty(this.cReqPriorityLink, this.cReqPriorityName, this.cReqDifficultyLink, this.cReqDifficultyName, this.cReqStateLink, this.cReqStateName);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.CReqProperty.CReqPropertyBuilder(cReqPriorityLink=" + this.cReqPriorityLink + ", cReqPriorityName=" + this.cReqPriorityName + ", cReqDifficultyLink=" + this.cReqDifficultyLink + ", cReqDifficultyName=" + this.cReqDifficultyName + ", cReqStateLink=" + this.cReqStateLink + ", cReqStateName=" + this.cReqStateName + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class UpdateAuthor {
        @Field(type=FieldType.Text, name="worklogs_updateAuthor_accountId")
        @JsonProperty(value="worklogs_updateAuthor_accountId")
        private String accountId;
        @Field(type=FieldType.Text, name="worklogs_updateAuthor_emailAddress")
        @JsonProperty(value="worklogs_updateAuthor_emailAddress")
        private String emailAddress;

        @Generated
        public static UpdateAuthorBuilder builder() {
            return new UpdateAuthorBuilder();
        }

        @Generated
        public String getAccountId() {
            return this.accountId;
        }

        @Generated
        public String getEmailAddress() {
            return this.emailAddress;
        }

        @Generated
        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Generated
        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.UpdateAuthor(accountId=" + this.getAccountId() + ", emailAddress=" + this.getEmailAddress() + ")";
        }

        @Generated
        public UpdateAuthor() {
        }

        @Generated
        public UpdateAuthor(String accountId, String emailAddress) {
            this.accountId = accountId;
            this.emailAddress = emailAddress;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateAuthor)) {
                return false;
            }
            UpdateAuthor other = (UpdateAuthor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accountId = this.getAccountId();
            String other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                return false;
            }
            String this$emailAddress = this.getEmailAddress();
            String other$emailAddress = other.getEmailAddress();
            return !(this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpdateAuthor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountId = this.getAccountId();
            result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
            String $emailAddress = this.getEmailAddress();
            result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
            return result;
        }

        @Generated
        public static class UpdateAuthorBuilder {
            @Generated
            private String accountId;
            @Generated
            private String emailAddress;

            @Generated
            UpdateAuthorBuilder() {
            }

            @JsonProperty(value="worklogs_updateAuthor_accountId")
            @Generated
            public UpdateAuthorBuilder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            @JsonProperty(value="worklogs_updateAuthor_emailAddress")
            @Generated
            public UpdateAuthorBuilder emailAddress(String emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            @Generated
            public UpdateAuthor build() {
                return new UpdateAuthor(this.accountId, this.emailAddress);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.UpdateAuthor.UpdateAuthorBuilder(accountId=" + this.accountId + ", emailAddress=" + this.emailAddress + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Author {
        @Field(type=FieldType.Text, name="worklogs_author_accountId")
        @JsonProperty(value="worklogs_author_accountId")
        private String accountId;
        @Field(type=FieldType.Text, name="worklogs_author_emailAddress")
        @JsonProperty(value="worklogs_author_emailAddress")
        private String emailAddress;

        @Generated
        public static AuthorBuilder builder() {
            return new AuthorBuilder();
        }

        @Generated
        public String getAccountId() {
            return this.accountId;
        }

        @Generated
        public String getEmailAddress() {
            return this.emailAddress;
        }

        @Generated
        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Generated
        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Author(accountId=" + this.getAccountId() + ", emailAddress=" + this.getEmailAddress() + ")";
        }

        @Generated
        public Author() {
        }

        @Generated
        public Author(String accountId, String emailAddress) {
            this.accountId = accountId;
            this.emailAddress = emailAddress;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Author)) {
                return false;
            }
            Author other = (Author)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accountId = this.getAccountId();
            String other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                return false;
            }
            String this$emailAddress = this.getEmailAddress();
            String other$emailAddress = other.getEmailAddress();
            return !(this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Author;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountId = this.getAccountId();
            result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
            String $emailAddress = this.getEmailAddress();
            result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
            return result;
        }

        @Generated
        public static class AuthorBuilder {
            @Generated
            private String accountId;
            @Generated
            private String emailAddress;

            @Generated
            AuthorBuilder() {
            }

            @JsonProperty(value="worklogs_author_accountId")
            @Generated
            public AuthorBuilder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            @JsonProperty(value="worklogs_author_emailAddress")
            @Generated
            public AuthorBuilder emailAddress(String emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            @Generated
            public Author build() {
                return new Author(this.accountId, this.emailAddress);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Author.AuthorBuilder(accountId=" + this.accountId + ", emailAddress=" + this.emailAddress + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Worklogs {
        @Field(type=FieldType.Text, name="worklogs_self")
        @JsonProperty(value="worklogs_self")
        private String self;
        @Field(type=FieldType.Nested)
        private Author author;
        @Field(type=FieldType.Nested)
        private UpdateAuthor updateAuthor;
        @Field(type=FieldType.Text, name="worklogs_created")
        @JsonProperty(value="worklogs_created")
        private String created;
        @Field(type=FieldType.Text, name="worklogs_updated")
        @JsonProperty(value="worklogs_updated")
        private String updated;
        @Field(type=FieldType.Text, name="worklogs_started")
        @JsonProperty(value="worklogs_started")
        private String started;
        @Field(type=FieldType.Text, name="worklogs_timeSpent")
        @JsonProperty(value="worklogs_timeSpent")
        private String timeSpent;
        @Field(type=FieldType.Integer, name="worklogs_timeSpentSeconds")
        @JsonProperty(value="worklogs_timeSpentSeconds")
        private Integer timeSpentSeconds;
        @Field(type=FieldType.Text, name="worklogs_id")
        @JsonProperty(value="worklogs_id")
        private String id;
        @Field(type=FieldType.Text, name="worklogs_issueId")
        @JsonProperty(value="worklogs_issueId")
        private String issueId;

        @Generated
        public static WorklogsBuilder builder() {
            return new WorklogsBuilder();
        }

        @Generated
        public String getSelf() {
            return this.self;
        }

        @Generated
        public Author getAuthor() {
            return this.author;
        }

        @Generated
        public UpdateAuthor getUpdateAuthor() {
            return this.updateAuthor;
        }

        @Generated
        public String getCreated() {
            return this.created;
        }

        @Generated
        public String getUpdated() {
            return this.updated;
        }

        @Generated
        public String getStarted() {
            return this.started;
        }

        @Generated
        public String getTimeSpent() {
            return this.timeSpent;
        }

        @Generated
        public Integer getTimeSpentSeconds() {
            return this.timeSpentSeconds;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getIssueId() {
            return this.issueId;
        }

        @Generated
        public void setSelf(String self) {
            this.self = self;
        }

        @Generated
        public void setAuthor(Author author) {
            this.author = author;
        }

        @Generated
        public void setUpdateAuthor(UpdateAuthor updateAuthor) {
            this.updateAuthor = updateAuthor;
        }

        @Generated
        public void setCreated(String created) {
            this.created = created;
        }

        @Generated
        public void setUpdated(String updated) {
            this.updated = updated;
        }

        @Generated
        public void setStarted(String started) {
            this.started = started;
        }

        @Generated
        public void setTimeSpent(String timeSpent) {
            this.timeSpent = timeSpent;
        }

        @Generated
        public void setTimeSpentSeconds(Integer timeSpentSeconds) {
            this.timeSpentSeconds = timeSpentSeconds;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setIssueId(String issueId) {
            this.issueId = issueId;
        }

        @Generated
        public String toString() {
            return "AlmIssueEntity.Worklogs(self=" + this.getSelf() + ", author=" + String.valueOf(this.getAuthor()) + ", updateAuthor=" + String.valueOf(this.getUpdateAuthor()) + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", started=" + this.getStarted() + ", timeSpent=" + this.getTimeSpent() + ", timeSpentSeconds=" + this.getTimeSpentSeconds() + ", id=" + this.getId() + ", issueId=" + this.getIssueId() + ")";
        }

        @Generated
        public Worklogs() {
        }

        @Generated
        public Worklogs(String self, Author author, UpdateAuthor updateAuthor, String created, String updated, String started, String timeSpent, Integer timeSpentSeconds, String id, String issueId) {
            this.self = self;
            this.author = author;
            this.updateAuthor = updateAuthor;
            this.created = created;
            this.updated = updated;
            this.started = started;
            this.timeSpent = timeSpent;
            this.timeSpentSeconds = timeSpentSeconds;
            this.id = id;
            this.issueId = issueId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Worklogs)) {
                return false;
            }
            Worklogs other = (Worklogs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$timeSpentSeconds = this.getTimeSpentSeconds();
            Integer other$timeSpentSeconds = other.getTimeSpentSeconds();
            if (this$timeSpentSeconds == null ? other$timeSpentSeconds != null : !((Object)this$timeSpentSeconds).equals(other$timeSpentSeconds)) {
                return false;
            }
            String this$self = this.getSelf();
            String other$self = other.getSelf();
            if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
                return false;
            }
            Author this$author = this.getAuthor();
            Author other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
                return false;
            }
            UpdateAuthor this$updateAuthor = this.getUpdateAuthor();
            UpdateAuthor other$updateAuthor = other.getUpdateAuthor();
            if (this$updateAuthor == null ? other$updateAuthor != null : !((Object)this$updateAuthor).equals(other$updateAuthor)) {
                return false;
            }
            String this$created = this.getCreated();
            String other$created = other.getCreated();
            if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
                return false;
            }
            String this$updated = this.getUpdated();
            String other$updated = other.getUpdated();
            if (this$updated == null ? other$updated != null : !this$updated.equals(other$updated)) {
                return false;
            }
            String this$started = this.getStarted();
            String other$started = other.getStarted();
            if (this$started == null ? other$started != null : !this$started.equals(other$started)) {
                return false;
            }
            String this$timeSpent = this.getTimeSpent();
            String other$timeSpent = other.getTimeSpent();
            if (this$timeSpent == null ? other$timeSpent != null : !this$timeSpent.equals(other$timeSpent)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$issueId = this.getIssueId();
            String other$issueId = other.getIssueId();
            return !(this$issueId == null ? other$issueId != null : !this$issueId.equals(other$issueId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Worklogs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $timeSpentSeconds = this.getTimeSpentSeconds();
            result = result * 59 + ($timeSpentSeconds == null ? 43 : ((Object)$timeSpentSeconds).hashCode());
            String $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : $self.hashCode());
            Author $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
            UpdateAuthor $updateAuthor = this.getUpdateAuthor();
            result = result * 59 + ($updateAuthor == null ? 43 : ((Object)$updateAuthor).hashCode());
            String $created = this.getCreated();
            result = result * 59 + ($created == null ? 43 : $created.hashCode());
            String $updated = this.getUpdated();
            result = result * 59 + ($updated == null ? 43 : $updated.hashCode());
            String $started = this.getStarted();
            result = result * 59 + ($started == null ? 43 : $started.hashCode());
            String $timeSpent = this.getTimeSpent();
            result = result * 59 + ($timeSpent == null ? 43 : $timeSpent.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $issueId = this.getIssueId();
            result = result * 59 + ($issueId == null ? 43 : $issueId.hashCode());
            return result;
        }

        @Generated
        public static class WorklogsBuilder {
            @Generated
            private String self;
            @Generated
            private Author author;
            @Generated
            private UpdateAuthor updateAuthor;
            @Generated
            private String created;
            @Generated
            private String updated;
            @Generated
            private String started;
            @Generated
            private String timeSpent;
            @Generated
            private Integer timeSpentSeconds;
            @Generated
            private String id;
            @Generated
            private String issueId;

            @Generated
            WorklogsBuilder() {
            }

            @JsonProperty(value="worklogs_self")
            @Generated
            public WorklogsBuilder self(String self) {
                this.self = self;
                return this;
            }

            @Generated
            public WorklogsBuilder author(Author author) {
                this.author = author;
                return this;
            }

            @Generated
            public WorklogsBuilder updateAuthor(UpdateAuthor updateAuthor) {
                this.updateAuthor = updateAuthor;
                return this;
            }

            @JsonProperty(value="worklogs_created")
            @Generated
            public WorklogsBuilder created(String created) {
                this.created = created;
                return this;
            }

            @JsonProperty(value="worklogs_updated")
            @Generated
            public WorklogsBuilder updated(String updated) {
                this.updated = updated;
                return this;
            }

            @JsonProperty(value="worklogs_started")
            @Generated
            public WorklogsBuilder started(String started) {
                this.started = started;
                return this;
            }

            @JsonProperty(value="worklogs_timeSpent")
            @Generated
            public WorklogsBuilder timeSpent(String timeSpent) {
                this.timeSpent = timeSpent;
                return this;
            }

            @JsonProperty(value="worklogs_timeSpentSeconds")
            @Generated
            public WorklogsBuilder timeSpentSeconds(Integer timeSpentSeconds) {
                this.timeSpentSeconds = timeSpentSeconds;
                return this;
            }

            @JsonProperty(value="worklogs_id")
            @Generated
            public WorklogsBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="worklogs_issueId")
            @Generated
            public WorklogsBuilder issueId(String issueId) {
                this.issueId = issueId;
                return this;
            }

            @Generated
            public Worklogs build() {
                return new Worklogs(this.self, this.author, this.updateAuthor, this.created, this.updated, this.started, this.timeSpent, this.timeSpentSeconds, this.id, this.issueId);
            }

            @Generated
            public String toString() {
                return "AlmIssueEntity.Worklogs.WorklogsBuilder(self=" + this.self + ", author=" + String.valueOf(this.author) + ", updateAuthor=" + String.valueOf(this.updateAuthor) + ", created=" + this.created + ", updated=" + this.updated + ", started=" + this.started + ", timeSpent=" + this.timeSpent + ", timeSpentSeconds=" + this.timeSpentSeconds + ", id=" + this.id + ", issueId=" + this.issueId + ")";
            }
        }
    }
}

