/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.bbs.controller;

import com.arms.api.bbs.model.constant.PostType;
import com.arms.api.bbs.model.dto.BbsDTO;
import com.arms.api.bbs.model.dto.CaptchaRequest;
import com.arms.api.bbs.model.entity.BbsEntity;
import com.arms.api.bbs.model.vo.BbsVO;
import com.arms.api.bbs.model.vo.SearchBbsVO;
import com.arms.api.bbs.service.BbsService;
import com.arms.api.util.response.CommonResponse;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import feign.Param;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/non-member/bbs"})
public class BbsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BbsController.class);
    private final BbsService bbsService;
    private final DefaultKaptcha captchaProducer;

    @GetMapping(value={"/verify/image"})
    public void getCaptchaImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String captchaText = this.captchaProducer.createText();
        request.getSession().setAttribute("captchaText", (Object)captchaText);
        BufferedImage image = this.captchaProducer.createImage(captchaText);
        response.setContentType("image/jpeg");
        ImageIO.write((RenderedImage)image, "jpg", (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/verify/captcha"})
    public ResponseEntity<String> verifyCaptcha(@RequestBody CaptchaRequest captchaRequest, HttpServletRequest request) {
        String sessionCaptcha = (String)request.getSession().getAttribute("captchaText");
        log.info("sessionCaptcha : {}", (Object)sessionCaptcha);
        log.info("captchaRequest.getCaptcha() : {}", (Object)captchaRequest.getCaptcha());
        if (captchaRequest.getCaptcha() == null) {
            return ResponseEntity.badRequest().body((Object)"\ucea1\ucc28 \uc785\ub825\uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if (sessionCaptcha == null) {
            return ResponseEntity.badRequest().body((Object)"\ucea1\ucc28\uac00 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
        if (sessionCaptcha.equals(captchaRequest.getCaptcha())) {
            request.getSession().removeAttribute("captchaText");
            return ResponseEntity.ok().body((Object)"\ucea1\ucc28 \uac80\uc99d \uc131\uacf5");
        }
        return ResponseEntity.badRequest().body((Object)"\ucea1\ucc28 \uac80\uc99d \uc2e4\ud328");
    }

    @GetMapping(value={"/board-list/only-post-list"})
    public ResponseEntity<CommonResponse.ApiResult<BbsVO>> postList(@Param(value="baseDTO") BbsDTO bbsDTO) {
        log.info("BbsController :: postList");
        bbsDTO.setPostType(PostType.POST);
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.bbsList(bbsDTO)));
    }

    @GetMapping(value={"/board-list/search-bbs"})
    public ResponseEntity<CommonResponse.ApiResult<BbsVO>> searchBbs(@Param(value="baseDTO") BbsDTO bbsDTO) {
        log.info("BbsController :: searchBbs");
        bbsDTO.setPostType(PostType.POST);
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.searchBbs(bbsDTO)));
    }

    @PostMapping(value={"/board-list/sort-bbs"})
    public ResponseEntity<CommonResponse.ApiResult<BbsVO>> sortBbs(@RequestBody SearchBbsVO searchBbsVO) {
        log.info("BbsController :: sortBbs");
        searchBbsVO.getBbsDTO().setPostType(PostType.POST);
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.sortBbs(searchBbsVO.getBbsDTO(), searchBbsVO.getField(), searchBbsVO.getValue())));
    }

    @GetMapping(value={"/board-list"})
    public ResponseEntity<CommonResponse.ApiResult<BbsVO>> boardList(@Param(value="baseDTO") BbsDTO bbsDTO) {
        log.info("BbsController :: boardList");
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.bbsList(bbsDTO)));
    }

    @PostMapping(value={"/post-message"})
    public ResponseEntity<CommonResponse.ApiResult<String>> savePostMessage(@RequestBody BbsDTO bbsDTO) {
        log.info("BbsController :: savePostMessage");
        bbsDTO.setPostType(PostType.POST);
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.postMessage(bbsDTO)));
    }

    @PostMapping(value={"/reply-message"})
    public ResponseEntity<CommonResponse.ApiResult<String>> saveReplyMessage(@RequestBody BbsDTO bbsDTO) {
        log.info("BbsController :: saveReplyMessage");
        if (ObjectUtils.isEmpty((Object)bbsDTO.getPath())) {
            throw new IllegalArgumentException("\uc798\ubabb\ub41c \uc694\uccad \uc785\ub2c8\ub2e4.");
        }
        bbsDTO.setPostType(PostType.REPLY);
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.replyMessage(bbsDTO)));
    }

    @PostMapping(value={"check-password"})
    public ResponseEntity<CommonResponse.ApiResult<String>> checkPassword(@RequestBody BbsDTO bbsDTO) {
        log.info("BbsController :: checkPassword");
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.checkPassword(bbsDTO)));
    }

    @PutMapping(value={"/update-id/{updateId}"})
    public ResponseEntity<CommonResponse.ApiResult<String>> update(@PathVariable(name="updateId") String updateId, @RequestBody BbsDTO bbsDTO) {
        log.info("BbsController :: update");
        bbsDTO.setId(updateId);
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.updateBbsAndGetId(bbsDTO)));
    }

    @GetMapping(value={"/find-path/find-id/{findId}"})
    public ResponseEntity<CommonResponse.ApiResult<List<BbsEntity>>> findPath(@PathVariable(name="findId") String findId) {
        log.info("BbsController :: findPath");
        this.bbsService.asyncViewCountUp(findId);
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.findPathById(findId)));
    }

    @DeleteMapping(value={"/delete-id/{deleteId}"})
    public ResponseEntity<CommonResponse.ApiResult<String>> deleteById(@PathVariable(name="deleteId") String deleteId) {
        log.info("BbsController :: deleteById");
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.deleteBbsAndGetId(deleteId)));
    }

    @Generated
    public BbsController(BbsService bbsService, DefaultKaptcha captchaProducer) {
        this.bbsService = bbsService;
        this.captchaProducer = captchaProducer;
    }
}

