/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.backoffice.information.timeoff.service;

import com.arms.api.backoffice.information.timeoff.modal.vo.UsersInfoVO;
import com.arms.api.backoffice.information.timeoff.service.TimeOffService;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeOffServiceImpl
implements TimeOffService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeOffServiceImpl.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private ServerInfoService serverInfoService;

    @Override
    public List<UsersInfoVO> getUsersInfo() {
        Map<String, String> serverIdToTypeMap = this.serverInfoService.getServerIdToTypeMap();
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("assignee.assignee_emailAddress.keyword").mainFieldAlias("emailAddress").addGroup(SubGroupFieldDTO.builder().subFieldAlias("jiraServerId").subField("jira_server_id").build(), SubGroupFieldDTO.builder().subFieldAlias("displayName").subField("assignee.assignee_displayName.keyword").build(), SubGroupFieldDTO.builder().subFieldAlias("accountId").subField("assignee.assignee_accountId.keyword").build()).build()).andExistsQueryFilter("assignee"));
        List<DocumentBucket> deepestList = documentAggregations.deepestList();
        HashSet<UsersInfoVO> userList = new HashSet<UsersInfoVO>();
        if (documentAggregations.getTotalHits() == 0L) {
            log.info("[ Time Off ServiceImpl :: \uc791\uc5c5\uc790_\ubaa9\ub85d_\uac00\uc838\uc624\uae30 ] :: \uc791\uc5c5\uc790 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \uc0ac\uc774\uc988 => 0");
        } else {
            for (DocumentBucket documentBucket : deepestList) {
                UsersInfoVO user = new UsersInfoVO();
                user.setEmailAddress(documentBucket.valueByName("emailAddress"));
                user.setServerType(serverIdToTypeMap.get(documentBucket.valueByName("jiraServerId")));
                user.setDisplayName(documentBucket.valueByName("displayName"));
                user.setAccountId(documentBucket.valueByName("accountId"));
                userList.add(user);
            }
        }
        if (userList.isEmpty()) {
            return new ArrayList<UsersInfoVO>(Collections.emptyList());
        }
        return new ArrayList<UsersInfoVO>(userList);
    }

    @Generated
    public TimeOffServiceImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, ServerInfoService serverInfoService) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.serverInfoService = serverInfoService;
    }
}

