/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.schedule.controller;

import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.dto.CReqProperty;
import com.arms.api.issue.almapi.model.dto.\uc99d\ubd84\uc774\uc288\uc218\uc9d1RequestDTO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.schedule.service.IssueScheduleService;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.api.util.aspect.SlackSendAlarm;
import com.arms.api.util.msa_communicate.BackendCoreClient;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/jira"})
public class IssueScheduleController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueScheduleController.class);
    private final IssueScheduleService issueScheduleService;
    private final BackendCoreClient backendCoreClient;

    @ResponseBody
    @GetMapping(value={"/{connectId}/issue/get/{reqProjectKey}/{reqIssueKey}"})
    public AlmIssueEntity findIssueByRecentId(@PathVariable(value="connectId") Long connectId, @PathVariable(value="reqProjectKey") String reqProjectKey, @PathVariable(value="reqIssueKey") String reqIssueKey) {
        String recentId = connectId + "_" + reqProjectKey + "_" + reqIssueKey;
        log.info("[ \uc774\uc288_\uc2a4\ucf00\uc904_\ucee8\ud2b8\ub864\ub7ec :: \uc694\uad6c\uc0ac\ud56d\uc774\uc288_\uc870\ud68c ] :: \uc870\ud68c\uc870\uac74_\uc544\uc774\ub514 = {}", (Object)recentId);
        return this.issueScheduleService.findIssueByRecentId(recentId);
    }

    @PostMapping(value={"/{connectId}/issue/pre-process/req-status-to-es"})
    public void preSaveReqStatus(@PathVariable(value="connectId") String connectId, @RequestParam(value="cTitle") String cTitle, @RequestParam(value="cReqStatusId") Long cReqStatusId, @RequestParam(value="issueKey") String issueKey, @RequestParam(value="pdServiceId") Long pdServiceId, @RequestParam(value="pdServiceVersions") List<Long> pdServiceVersions, @RequestParam(value="cReqLink") Long cReqLink, @RequestParam(value="projectKeyOrId") String projectKeyOrId, CReqProperty CReqProperty2) {
        AlmIssueWithRequirementDTO requirementDTO = AlmIssueWithRequirementDTO.builder().jiraServerId(connectId).cTitle(cTitle).cReqStatusId(cReqStatusId).issueKey(issueKey).serviceId(pdServiceId).versions(pdServiceVersions).cReqLink(cReqLink).cReqProperty(CReqProperty2).projectKeyOrId(projectKeyOrId).build();
        this.issueScheduleService.preSaveReqStatus(requirementDTO);
    }

    @Async
    @DwrSendAlarm(messageOnStart="ALM \uc218\uc9d1 \uc2dc\uc791(ALM TO ES)", messageOnEnd="ALM \uc218\uc9d1 \uc644\ub8cc(ALM TO ES)")
    @SlackSendAlarm(messageOnStart="ALM \uc218\uc9d1 \uc2dc\uc791(ALM TO ES)", messageOnEnd="ALM \uc218\uc9d1 \uc644\ub8cc(ALM TO ES)")
    @PostMapping(value={"/issue/loadToES/bulk/increment"})
    public void discoverIncrementalIssues(@RequestBody \uc99d\ubd84\uc774\uc288\uc218\uc9d1RequestDTO requestDTO) {
        log.info("[ IssueScheduleController :: discoverIncrementalIssues start] :: serverProjectInfos size : {}, startDate : {}, endDate : {}", new Object[]{requestDTO.getServerProjectInfos() != null ? requestDTO.getServerProjectInfos().size() : 0, requestDTO.getStartDate(), requestDTO.getEndDate()});
        ArrayList allCollectedIssues = new ArrayList();
        for (\uc99d\ubd84\uc774\uc288\uc218\uc9d1RequestDTO.ServerProjectInfo serverProjectInfo : requestDTO.getServerProjectInfos()) {
            AlmIssueIncrementDTO almIssueIncrementDTO = AlmIssueIncrementDTO.builder().serverId(serverProjectInfo.getServerId()).projectKey(serverProjectInfo.getProjectKey()).startDate(requestDTO.getStartDate()).endDate(requestDTO.getEndDate()).build();
            List collectedIssues = this.issueScheduleService.discoveryIncrementALmIssue(almIssueIncrementDTO);
            if (collectedIssues == null || collectedIssues.isEmpty()) continue;
            allCollectedIssues.addAll(collectedIssues);
        }
        log.info("[ IssueScheduleController :: discoverIncrementalIssues ] :: \ucd1d \uc218\uc9d1\ub41c \uc694\uad6c\uc0ac\ud56d \uc218 = {}", (Object)allCollectedIssues.size());
        try {
            this.backendCoreClient.transferAlmDataToBackend(allCollectedIssues);
            log.info("[ IssueScheduleController :: discoverIncrementalIssues ] :: Backend-Core \ub3d9\uae30\ud654 \uc694\uccad \uc644\ub8cc");
        }
        catch (Exception e) {
            log.error("[ IssueScheduleController :: discoverIncrementalIssues ] :: Backend-Core \ub3d9\uae30\ud654 \uc694\uccad \uc2e4\ud328", (Throwable)e);
        }
        log.info("[ IssueScheduleController :: discoverIncrementalIssues end] ");
    }

    @ResponseBody
    @GetMapping(value={"/issue/test/api-request"})
    public void cloudJiraTestApiRequest() {
        this.issueScheduleService.cloudJiraTestApiRequest();
    }

    @ResponseBody
    @PostMapping(value={"/sync-data/delete-if-does-not-exist-doc"})
    public void deleteIfDoesNotExistDoc() {
        this.issueScheduleService.deleteIfDoesNotExistDoc();
    }

    @PutMapping(value={"/arms-state-category"})
    public ResponseEntity<?> updateArmsStateCategory() {
        this.issueScheduleService.updateArmsStateCategory();
        return ResponseEntity.ok((Object)"OK");
    }

    @Generated
    public IssueScheduleController(IssueScheduleService issueScheduleService, BackendCoreClient backendCoreClient) {
        this.issueScheduleService = issueScheduleService;
        this.backendCoreClient = backendCoreClient;
    }
}

