/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.cost.controller;

import com.arms.api.analysis.cost.model.dto.CostAggrDTO;
import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.dto.CostRequestDTO;
import com.arms.api.analysis.cost.model.vo.AssigneeTimeDiffVO;
import com.arms.api.analysis.cost.model.vo.CostVO;
import com.arms.api.analysis.cost.service.AnalysisCost;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/analysis-cost"})
public class AnalysisCostController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalysisCostController.class);
    private final AnalysisCost analysisCost;

    @PostMapping(value={"/assignee-list"})
    public ResponseEntity<List<CostVO>> getAssigneeList(@RequestBody CostAggrDTO costAggrDTO) {
        log.info("AnalysisCostController :: getAssigneeList");
        return ResponseEntity.ok((Object)this.analysisCost.getAssigneeList(costAggrDTO));
    }

    @PostMapping(value={"/version-requirement/assignee-list"})
    public ResponseEntity<List<CostVO>> getAssigneeListByProductVersionAndRequirement(@RequestBody CostAggrDTO costAggrDTO) {
        log.info("AnalysisCostController :: getAssigneeListByProductVersionAndRequirement");
        return ResponseEntity.ok((Object)this.analysisCost.getAssigneeListByProductVersionAndRequirement(costAggrDTO));
    }

    @PostMapping(value={"/aggregation/assignee-account-id"})
    public ResponseEntity<List<CostVO>> aggregationByAssigneeAccountId(@RequestBody CostAggrDTO costAggrDTO) {
        log.info("AnalysisCostController :: aggregationByAssigneeAccountId");
        return ResponseEntity.ok((Object)this.analysisCost.aggregationByAssigneeAccountId(costAggrDTO));
    }

    @PostMapping(value={"/aggregation/assignee-account-id-and-req-link"})
    public ResponseEntity<List<CostVO>> aggregationByReqLinkAndAssigneeAccountId(@RequestBody CostAggrDTO costAggrDTO) {
        log.info("AnalysisCostController :: aggregationByReqLinkAndAssigneeAccountId");
        return ResponseEntity.ok((Object)this.analysisCost.aggregationByReqLinkAndAssigneeAccountId(costAggrDTO));
    }

    @PostMapping(value={"/calculateWorkdayByAccountId"})
    public ResponseEntity<List<AssigneeTimeDiffVO>> calculateWorkdayByAccountId(@RequestBody CostRequestDTO costRequestDTO) {
        log.info("AnalysisCostController :: calculateWorkdayByAccountId");
        return ResponseEntity.ok((Object)this.analysisCost.calculateWorkdayByAccountId(costRequestDTO));
    }

    @PostMapping(value={"/calculation-cost"})
    public ResponseEntity<?> calculationCost(@RequestBody CostDTO costDTO) {
        log.info("AnalysisCostController :: calculationCost");
        return ResponseEntity.ok((Object)this.analysisCost.calculationCost(costDTO));
    }

    @Generated
    public AnalysisCostController(AnalysisCost analysisCost) {
        this.analysisCost = analysisCost;
    }
}

