/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.account.strategy;

import com.arms.api.account.model.AlmAccount;
import com.arms.api.account.strategy.AccountStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorCode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class CloudJiraAccountStrategy
implements AccountStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudJiraAccountStrategy.class);
    private final ServerInfoService serverInfoService;
    private final JiraUtil jiraUtil;

    public AlmAccount verifyAccount(ServerInfo serverInfo) {
        log.info("\ud074\ub77c\uc6b0\ub4dc_\uc9c0\ub77c_\uacc4\uc815\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uac80\uc99d");
        return this.findAccount(serverInfo);
    }

    public AlmAccount getAccount(String connectId) {
        log.info("\ud074\ub77c\uc6b0\ub4dc_\uc9c0\ub77c_\uacc4\uc815\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uac00\uc838\uc624\uae30, \uc5f0\uacb0_\uc544\uc774\ub514: {}", (Object)connectId);
        if (connectId == null) {
            throw new IllegalArgumentException(ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(connectId);
        return this.findAccount(serverInfo);
    }

    private AlmAccount findAccount(ServerInfo serverInfo) {
        try {
            String uri = serverInfo.getUri();
            String serverType = serverInfo.getType();
            String apiToken = this.serverInfoService.getDecryptPasswordOrToken(serverInfo);
            String userId = serverInfo.getUserId();
            log.info("\ud074\ub77c\uc6b0\ub4dc_\uc9c0\ub77c_\uacc4\uc815\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uc870\ud68c, \uc11c\ubc84 \uc8fc\uc18c: {}, \uc11c\ubc84 \ud0c0\uc785: {}, apiToken: {}, \uc720\uc800 \uc544\uc774\ub514: {}", new Object[]{uri, serverType, apiToken, userId});
            WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(uri, userId, apiToken);
            String endpoint = "/rest/api/3/myself";
            AlmAccount \uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc = (AlmAccount)this.jiraUtil.get(webClient, endpoint, AlmAccount.class).block();
            if (\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc == null) {
                log.error("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c \uacc4\uc815 \uc870\ud68c \uacb0\uacfc\uac00 Null\uc785\ub2c8\ub2e4.");
                throw new IllegalArgumentException(ErrorCode.ACCOUNT_INFO_RETRIEVAL_ERROR.getErrorMsg(new Object[0]));
            }
            return \uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc;
        }
        catch (Exception e) {
            log.error("\ud074\ub77c\uc6b0\ub4dc \uacc4\uc815 \uc815\ubcf4 \uc870\ud68c\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.{}", (Object)e.getMessage());
            throw new IllegalArgumentException(ErrorCode.ACCOUNT_INFO_RETRIEVAL_ERROR.getErrorMsg(new Object[0]));
        }
    }

    @Generated
    public CloudJiraAccountStrategy(ServerInfoService serverInfoService, JiraUtil jiraUtil) {
        this.serverInfoService = serverInfoService;
        this.jiraUtil = jiraUtil;
    }
}

