/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.listener;

import com.arms.api.wiki.dto.DocumentState;
import com.arms.api.wiki.service.OtService;
import com.arms.api.wiki.service.SessionRegistryService;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionConnectedEvent;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;

@Component
public class WebSocketEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketEventListener.class);
    private final SessionRegistryService sessionRegistryService;
    private final SimpMessagingTemplate messagingTemplate;
    private final OtService otService;
    private final StringRedisTemplate stringRedisTemplate;
    private final SetOperations<String, String> setOperations;
    private static final String USER_ACTIVE_DOCS_KEY_PREFIX = "user:active_docs:";

    @Autowired
    public WebSocketEventListener(SessionRegistryService sessionRegistryService, SimpMessagingTemplate messagingTemplate, OtService otService, StringRedisTemplate stringRedisTemplate) {
        this.sessionRegistryService = sessionRegistryService;
        this.messagingTemplate = messagingTemplate;
        this.otService = otService;
        this.stringRedisTemplate = stringRedisTemplate;
        this.setOperations = stringRedisTemplate.opsForSet();
    }

    private String getUserTrackingKey(String userId) {
        return USER_ACTIVE_DOCS_KEY_PREFIX + userId;
    }

    @EventListener
    public void handleWebSocketConnectListener(SessionConnectedEvent event) {
        MessageHeaders headers = event.getMessage().getHeaders();
        Principal userPrincipal = SimpMessageHeaderAccessor.getUser((Map)headers);
        String simpSessionId = SimpMessageHeaderAccessor.getSessionId((Map)headers);
        if (userPrincipal != null) {
            log.info("WebSocket Connected: User={}, WebSocket SessionId={}", (Object)userPrincipal.getName(), (Object)simpSessionId);
        } else {
            log.warn("WebSocket Connected: No user principal found. WebSocket SessionId={}", (Object)simpSessionId);
        }
    }

    @EventListener
    public void handleWebSocketSubscribeListener(SessionSubscribeEvent event) {
        MessageHeaders headers = event.getMessage().getHeaders();
        Principal userPrincipal = SimpMessageHeaderAccessor.getUser((Map)headers);
        String simpSessionId = SimpMessageHeaderAccessor.getSessionId((Map)headers);
        String destination = SimpMessageHeaderAccessor.getDestination((Map)headers);
        if (userPrincipal != null) {
            log.info("WebSocket Subscribed: User={}, WebSocket SessionId={}, Destination={}", new Object[]{userPrincipal.getName(), simpSessionId, destination});
        } else {
            log.warn("WebSocket Subscribed: No user principal found. WebSocket SessionId={}, Destination={}", (Object)simpSessionId, (Object)destination);
        }
    }

    @EventListener
    public void handleWebSocketDisconnectListener(SessionDisconnectEvent event) {
        MessageHeaders headers = event.getMessage().getHeaders();
        Principal userPrincipal = SimpMessageHeaderAccessor.getUser((Map)headers);
        String simpSessionId = SimpMessageHeaderAccessor.getSessionId((Map)headers);
        if (userPrincipal != null) {
            String userId = userPrincipal.getName();
            log.info("WebSocket Disconnected: User={}, WebSocket SessionId={}", (Object)userId, (Object)simpSessionId);
            String trackingKey = this.getUserTrackingKey(userId);
            Set<String> activeDocuments = null;
            try {
                activeDocuments = this.setOperations.members((Object)trackingKey);
            }
            catch (Exception e) {
                log.error("Redis error retrieving active documents for user [{}], key [{}]: {}", new Object[]{userId, trackingKey, e.getMessage(), e});
                log.warn("Could not retrieve active documents for user [{}], unable to perform targeted cleanup.", (Object)userId);
                activeDocuments = Collections.emptySet();
            }
            if (activeDocuments != null && !activeDocuments.isEmpty()) {
                log.info("Processing disconnect for user [{}]. Found {} active document entries in tracking set [{}].", new Object[]{userId, activeDocuments.size(), trackingKey});
                activeDocuments.forEach(docEntry -> {
                    block5: {
                        String[] parts = docEntry.split(":", 2);
                        if (parts.length == 2) {
                            String sessionId = parts[0];
                            String documentId = parts[1];
                            log.info("Attempting to remove user [{}] from session [{}], doc [{}] based on tracking info.", new Object[]{userId, sessionId, documentId});
                            try {
                                boolean removed = this.sessionRegistryService.userLeftDocument(sessionId, documentId, userId);
                                if (removed) {
                                    log.info("User [{}] successfully removed from session [{}], doc [{}]. Triggering state broadcast.", new Object[]{userId, sessionId, documentId});
                                    this.broadcastFullDocumentState(sessionId, documentId, userId);
                                    break block5;
                                }
                                log.warn("Call to userLeftDocument for user [{}], session [{}], doc [{}] returned false (user might have already been removed?).", new Object[]{userId, sessionId, documentId});
                            }
                            catch (Exception e) {
                                log.error("Error calling userLeftDocument or broadcasting state for user [{}], session [{}], doc [{}]: {}", new Object[]{userId, sessionId, documentId, e.getMessage(), e});
                            }
                        } else {
                            log.warn("Invalid document entry format '{}' found in tracking set '{}' for user [{}]", new Object[]{docEntry, trackingKey, userId});
                        }
                    }
                });
                try {
                    this.stringRedisTemplate.delete((Object)trackingKey);
                    log.info("Deleted user tracking set '{}' for user [{}]", (Object)trackingKey, (Object)userId);
                }
                catch (Exception e) {
                    log.error("Redis error deleting tracking key [{}] for user [{}]: {}", new Object[]{trackingKey, userId, e.getMessage(), e});
                }
            } else {
                log.info("No active document entries found in tracking set [{}] for disconnected user [{}]. No specific cleanup needed based on tracking.", (Object)trackingKey, (Object)userId);
            }
        } else {
            log.warn("WebSocket Disconnected: No user principal found. WebSocket SessionId={}. Cannot clean up registry.", (Object)simpSessionId);
        }
    }

    private void broadcastFullDocumentState(String sessionId, String documentId, String triggerUserId) {
        log.info("Broadcasting full document state for session [{}], doc [{}] triggered by user action (disconnect/activity) of user [{}]", new Object[]{sessionId, documentId, triggerUserId});
        try {
            List participants = this.sessionRegistryService.getActiveParticipantsForDocument(sessionId, documentId, null);
            String currentContent = this.otService.getDocumentContent(sessionId, documentId);
            int currentRevision = this.otService.getRevision(sessionId, documentId);
            DocumentState fullState = new DocumentState();
            fullState.setSessionId(sessionId);
            fullState.setDocumentId(documentId);
            fullState.setDocument(currentContent);
            fullState.setRevision(currentRevision);
            fullState.setParticipants(participants);
            String stateDestination = String.format("/topic/sessions/%s/state/document/%s", sessionId, documentId);
            this.messagingTemplate.convertAndSend((Object)stateDestination, (Object)fullState);
            log.info("Successfully broadcasted full document state to {} for session [{}], doc [{}]", new Object[]{stateDestination, sessionId, documentId});
        }
        catch (Exception e) {
            log.error("Error broadcasting full document state for session [{}], doc [{}]: {}", new Object[]{sessionId, documentId, e.getMessage(), e});
        }
    }
}

