////////////////////////////////////////////////////////////////////////////////////////
//Page 전역 변수
////////////////////////////////////////////////////////////////////////////////////////
var dataTableRef;
var searchString; // 검색어
var searchRangeType; //날짜 검색 기준. 모든날짜 / 1일 / 7일 / 1달 / 1년 등...
// 해당아이디로 all-time, previous-day, previous-week, previous-month, previous-year, custom-range
////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		[
			"../reference/light-blue/lib/vendor/jquery.ui.widget.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Templates_js_tmpl.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Load-Image_js_load-image.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Canvas-to-Blob_js_canvas-to-blob.js",
			"../reference/light-blue/lib/jquery.iframe-transport.js",
			"../reference/light-blue/lib/jquery.fileupload.js",
			"../reference/light-blue/lib/jquery.fileupload-fp.js",
			"../reference/light-blue/lib/jquery.fileupload-ui.js"
		],
		[
			"../reference/jquery-plugins/select2-4.0.2/dist/css/select2_lightblue4.css",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/css/multiselect-lightblue4.css",
			"../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select-bluelight.css",
			"../reference/jquery-plugins/select2-4.0.2/dist/js/select2.min.js",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.quicksearch.js",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.multi-select.js",
			"../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select.min.js"
		],
		[
			"../reference/lightblue4/docs/lib/slimScroll/jquery.slimscroll.min.js",
			"../reference/jquery-plugins/unityping-0.1.0/dist/jquery.unityping.min.js",
			"../reference/lightblue4/docs/lib/widgster/widgster.js"
		],
		[
			// 하이라이트
			"../reference/jquery-plugins/highlight.js-11.10.0/highlight.js.lib/highlight.min.js",
			"../reference/jquery-plugins/highlight.js-11.10.0/highlight.js.lib/src/styles/arta.css",
			// 검색엔진
			"css/searchEngine.css",
			"js/searchEngine/searchApiModule.js",
			//날짜 검색
			"../reference/light-blue/lib/bootstrap-datepicker.js",
			"../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.min.css",
			"../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.full.min.js"
		]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");
			//상단 메뉴
			$(".widget").widgster();

			//highlight.js 설정.
			hljs.highlightAll();
			//이벤트리스너 활성화
			eventListenersActivator();

			//날짜검색 이벤트리스너
			dateRangeFilterEvent();
			datetTimePicker();

			//페이지 로드 시  - 상단 검색 확인
			checkQueryStringOnUrl();
		})
		.catch(function (e) {
			console.error("플러그인 로드 중 오류 발생");
		});
}

/////////////////////////
//이벤트 리스너 활성화
/////////////////////////
function eventListenersActivator() {
	$("#search-input").on("keyup", function (event) {
		if (event.keyCode === 13) {
			// 엔터의 keyCode 13
			console.log("[searchEngine :: search-input] :: 검색어 입력 값 => " + $("#search-input").val());
			$("#search-button").click(); //검색시작 트리거 역할
		}
	});

	$("#search-button").on("click", function (event) {
		$("#nav-search-input").val("");
		let searchTerm = $("#search-input").val();

		validateSearchString(searchTerm);

		if (searchString) {
			console.log("[searchEngine :: search-button] :: 검색어 -> " + searchString);
			setParameter("searchString", searchString);
			let rangeDate = SearchApiModule.getRangeDate();

			SearchApiModule.resetSearchFilters(); // 새로 검색을 넣을 때, 검색 조건 초기화
			$("#checkedListProjectName").html("");
			$("#checkedListLogName").html("");
			engineSearch(
				appendWildcard(searchString),
				"almIssue",
				rangeDate,
				"project",
				SearchApiModule.getSearchFilters("project")
			);
			engineSearch(appendWildcard(searchString), "log", rangeDate, "log", SearchApiModule.getSearchFilters("log"));
		} else {
			setParameter("searchString", ""); // 검색어 url 초기화
			console.log("[searchEngine :: search-button] :: 검색어가 없거나 빈값 입니다.");
		}
	});

	//검색 결과 리스트 클릭 이벤트
	$(".search_main_wrapper .search_result_group .search_result_items").on("click", function (event) {
		console.log($(event.target).closest(".search-result")[0]);
		var clicked_content_id = $(event.target).closest(".search-result").find(".search_head").attr("id");
		if (!clicked_content_id.includes("no_search_result")) {
			let section_and_order = getDataSectionAndOrder(clicked_content_id);
			SearchApiModule.mapDataToModal(section_and_order["search_section"], section_and_order["order"]);
		}
	});
}

/////////////////////////////////////////
// 검색_날짜필터(검색조건) 이벤트리스너
/////////////////////////////////////////
function dateRangeFilterEvent() {
	$("#date-range-group .dropdown-menu li:not(:last)").on("click", function (event) {
		// console.log($(event.target));
		var rangeTypeId = $(event.target).closest("a").attr("id");
		var rangeText = $("#" + rangeTypeId).text();
		$("#date-range").text(rangeText); // 드롭다운 타이틀 변경

		searchRangeType = rangeTypeId; // 검색 레인지 타입아이디
		SearchApiModule.setRangeDateAsync(rangeTypeId)
			.then(() => {
				//날짜 구간 세팅
				let rangeDate = SearchApiModule.getRangeDate();
				let start = rangeDate["start-date"] ? SearchApiModule.setMidnightToZero(rangeDate["start-date"]) : "";
				let end = rangeDate["end-date"]
					? new Date(rangeDate["end-date"]).toLocaleString("ko-KR", { timeZone: "Asia/Seoul" })
					: "";
				let rangeText = start + " ~ " + end;
				let blank = `&nbsp;&nbsp;`;
				if (searchRangeType === "all-time") {
					rangeText = "";
					blank = ``;
				}
				$("#filter_list").html("");
				$("#filter_list").append(`<li style="margin: 0 3px"><a>${blank}${rangeText}</a></li>`);

				if (searchString) {
					engineSearch(
						appendWildcard(searchString),
						"almIssue",
						rangeDate,
						"project",
						SearchApiModule.getSearchFilters("project")
					);
					engineSearch(appendWildcard(searchString), "log", rangeDate, "log", SearchApiModule.getSearchFilters("log"));
				} else {
					console.log("[searchEngine :: dateRangeFilterEvent] :: 검색어가 없습니다.");
				}
			})
			.catch((error) => {
				console.error("[searchEngine :: dateRangeFilterEvent] :: 검색 오류 발생 =>", error);
			});
	});

	// 기간 설정 선택
	$("#date-range-group .dropdown-menu li:last").on("click", function (event) {
		var rangeTypeId = $(event.target).closest("a").attr("id");
		var rangeText = $("#" + rangeTypeId).text();
		$("#date-range").text(rangeText);

		$("#date_timepicker_start").val("");
		$("#date_timepicker_end").val("");
	});
}
/////////////////////////
// 검색 프로세스
/////////////////////////
function engineSearch(searchString, searchSection, rangeDate, filterKey = "", filterValues = [], page = 0, size = 10) {
	let showPage = 1; // 보는 페이지
	if (page - 1 <= 0) {
		page = 0;
	} else {
		showPage = page;
		page = page - 1;
	}
	$.ajax({
		url: "/engine-search-api/engine/search/" + searchSection,
		type: "POST",
		contentType: "application/json",
		data: JSON.stringify({
			searchString: searchString,
			page: page,
			size: size,
			from: page * size,
			startDate: rangeDate["start-date"],
			endDate: rangeDate["end-date"],
			filter: {
				// 필터 객체 (중첩 객체)
				name: filterKey,
				values: filterValues
			}
		}),
		dataType: "json",
		success: function (result) {
			console.log("[searchEngine :: engineSearch] :: almIssue_search_results 실행");
			console.log(result);
			const pageSize = 10; //페이지당 아이템 수

			SearchApiModule.setSearchResult(searchSection, result, showPage, pageSize); // searchSection :: almIssue, log
			if (page > 0) {
				let pageStart = Math.floor(page / 10) * 10 + 1;
				SearchApiModule.updateButtons(searchSection, showPage, pageStart);
			}
		}
	});

	if (searchSection === "almIssue" && !SearchApiModule.isSearchFiltersExist(filterKey)) {
		getTop5projectName(searchString, rangeDate);
	}
	if (searchSection === "log" && !SearchApiModule.isSearchFiltersExist(filterKey)) {
		getTop5LogName(searchString, rangeDate);
	}
}

//////////////////////////////
// 프로젝트명(Top5) 집계
//////////////////////////////
function getTop5projectName(searchString, rangeDate) {
	console.log("[searchEngine :: getTop5projectName] 실행");

	$.ajax({
		url: "/engine-search-api/engine/search/almIssue/project-aggr-top5",
		type: "POST",
		contentType: "application/json",
		data: JSON.stringify({
			searchString: searchString,
			startDate: rangeDate["start-date"],
			endDate: rangeDate["end-date"]
		}),
		dataType: "json",
		success: function (result) {
			console.log("[searchEngine :: getTop5projectName] :: proeject-aggs-top5 => 집계 실행");
			console.log(result);
			if (result) {
				var resultArr = result["docFieldNameAndCounts"];
				console.log(resultArr);

				var total = result["totalHits"] ? result["totalHits"] : 0;
				var resultArrTotal = 0;
				resultArr.forEach((element) => {
					resultArrTotal += parseInt(element["docCount"]);
				});

				$("#project-agg-top5").html("");
				var setting = `<ul>`;
				if (total === 0) {
					setting += `<li><a style="text-align: center;">집계 데이터 없음</a></li>`;
				} else {
					resultArr.forEach((element, idx) => {
						var ratio = +((parseInt(element["docCount"]) / resultArrTotal) * 100).toFixed(1);
						setting += `<li>
													<div style="margin: 5px 10px; display: flex; justify-content: space-between" >
														<p style="line-heignt:18px">
															<input type="checkbox" id="projAggs-${idx}" class="projectAggs" name="${element["docFieldName"]}" style="vertical-align: middle; margin:0"/>
															<label for="projAggs-${idx}" style="color: #a4c6ff; margin-bottom: 0px">${element["docFieldName"]}</label>
														</p>
														<p style="color: #2D8515; margin-bottom: 0px">${element["docCount"]}(${ratio}%)</p>
													</div>
													<div class="progress progress-small" style="margin: 0 10px 5px 10px">
														<div class="progress-bar progress-bar-inverse" style="width: ${ratio}%;"></div>
													</div>
													</li>`;
					});
				}
				setting += `</ul>`;
				$("#project-agg-top5").html(setting);

				// 집계 체크박스 이벤트 실행 (∵ 동적 HTML 추가이기 때문에 기존에 추가한 이벤트가 동작하지 않음)
				projectAggrCheckBoxEvent();
			} else {
				$("#project-agg-top5").html(`<a style="text-align: center;">집계 데이터 없음</a>`);
			}
		}
	});
}

//////////////////////////////
// 로그명(Top5) 집계
//////////////////////////////
function getTop5LogName(searchString, rangeDate) {
	console.log("[searchEngine :: getTop5LogName] 실행");

	$.ajax({
		url: "/engine-search-api/engine/search/log/aggr-top5",
		type: "POST",
		contentType: "application/json",
		data: JSON.stringify({
			searchString: searchString,
			startDate: rangeDate["start-date"],
			endDate: rangeDate["end-date"]
		}),
		dataType: "json",
		success: function (result) {
			console.log("[searchEngine :: getTop5LogName] :: log-aggs-top5 => 집계 실행");
			console.log(result);
			if (result) {
				var resultArr = result["docFieldNameAndCounts"];
				console.log(resultArr);

				var total = result["totalHits"] ? result["totalHits"] : 0;
				var resultArrTotal = 0;
				resultArr.forEach((element) => {
					resultArrTotal += parseInt(element["docCount"]);
				});

				$("#log-agg-top5").html("");
				var setting = `<ul>`;
				if (total === 0) {
					setting += `<li><a style="text-align: center;">집계 데이터 없음</a></li>`;
				} else {
					resultArr.forEach((element, idx) => {
						var ratio = +((parseInt(element["docCount"]) / resultArrTotal) * 100).toFixed(1);
						setting += `<li>
													<div style="margin: 5px 10px; display: flex; justify-content: space-between" >
														<p style="line-heignt:18px">
															<input type="checkbox" id="logAggs-${idx}" class="logAggs" name="${element["docFieldName"]}" style="vertical-align: middle; margin:0"/>
															<label for="logAggs-${idx}" style="color: #a4c6ff; margin-bottom: 0px">${element["docFieldName"]}</label>
														</p>
														<p style="color: #2D8515; margin-bottom: 0px">${element["docCount"]}(${ratio}%)</p>
													</div>
													<div class="progress progress-small" style="margin: 0 10px 5px 10px">
														<div class="progress-bar progress-bar-inverse" style="width: ${ratio}%;"></div>
													</div>
													</li>`;
					});
				}
				setting += `</ul>`;

				$("#log-agg-top5").html(setting);
				// 집계 체크박스 이벤트 실행 (∵ 동적 HTML 추가이기 때문에 기존에 추가한 이벤트가 동작하지 않음)
				logAggrCheckBoxEvent();
			} else {
				$("#log-agg-top5").html(`<a style="text-align: center;">집계 데이터 없음</a>`);
			}
		}
	});
}

function projectAggrCheckBoxEvent() {
	let filterName = "project";
	$("#project-agg-top5 .projectAggs").change(function () {
		var checkedLabels = [];
		$(".projectAggs:checked").each(function () {
			var label = $("label[for='" + this.id + "']").text();
			checkedLabels.push(label); // 체크된 label을 배열에 저장
		});

		// 결과 출력
		console.log("Checked labels:", checkedLabels);
		// 검색조건:
		$("#checkedListProjectName").html("");
		if (checkedLabels.length !== 0) {
			var checdListStr = `(ALM-PROJECT)`;
			checkedLabels.forEach((element) => {
				checdListStr += `&nbsp;${element}`;
			});

			$("#checkedListProjectName").html(checdListStr);
		}

		if (checkedLabels.length > 0) {
			// projectName 이 있는 것으로 검색조회
			SearchApiModule.setSearchFilters(filterName, checkedLabels);
			engineSearch(
				appendWildcard(searchString),
				"almIssue",
				SearchApiModule.getRangeDate(),
				filterName,
				SearchApiModule.getSearchFilters(filterName)
			);
		} else {
			// projectName 이 없는 것으로 검색조회
			engineSearch(appendWildcard(searchString), "almIssue", SearchApiModule.getRangeDate());
		}
	});
}

function logAggrCheckBoxEvent() {
	let filterName = "log";
	$("#log-agg-top5 .logAggs").change(function () {
		var checkedLabels = [];
		$(".logAggs:checked").each(function () {
			var label = $("label[for='" + this.id + "']").text();
			checkedLabels.push(label); // 체크된 label을 배열에 저장
		});

		// 결과 출력
		console.log("Checked labels:", checkedLabels);
		// 검색조건:
		$("#checkedListLogName").html("");
		if (checkedLabels.length !== 0) {
			var checdListStr = `&nbsp;(Log)`;
			checkedLabels.forEach((element) => {
				checdListStr += `&nbsp;${element}`;
			});

			$("#checkedListLogName").html(checdListStr);
		}

		if (checkedLabels.length > 0) {
			// logName 이 있는 것으로 검색조회
			SearchApiModule.setSearchFilters(filterName, checkedLabels);
			engineSearch(
				appendWildcard(searchString),
				"log",
				SearchApiModule.getRangeDate(),
				filterName,
				SearchApiModule.getSearchFilters(filterName)
			);
		} else {
			// logtName 이 없는 것으로 검색조회
			engineSearch(appendWildcard(searchString), "log", SearchApiModule.getRangeDate());
		}
	});
}

/////////////////////////////////////
// 클릭한 아이디에서 section과 결과순서 가져오기
/////////////////////////////////////
function getDataSectionAndOrder(id) {
	const targetId = id;
	const matches = targetId.match(/hits_order_(almIssue|log)_(\d+)/);
	let returnVal = { search_section: null, order: null };

	if (matches) {
		returnVal["search_section"] = matches[1];
		returnVal["order"] = matches[2];
		console.log("[searchEngine :: getDataSectionAndOrder] :: section -> " + matches[1] + ", order -> " + matches[2]);
		return returnVal;
	} else {
		console.log("[searchEngine :: getDataSectionAndOrder] No Match Found :: id -> " + targetId);
		return returnVal;
	}
}

////////////////////////////////////////
// 페이지 로드 시, 상단 검색어 기입 확인
////////////////////////////////////////
function checkQueryStringOnUrl() {
	var queryString = window.location.search;
	var urlParams = new URLSearchParams(queryString);
	var searchTerm = urlParams.get("searchString");
	console.log("[searchEngine :: checkQueryStringOnUrl] :: 상단_검색 검색어 => " + searchTerm);

	if (searchTerm) {
		$("#search-input").val(searchTerm);
		$("#search-button").click();
	} else {
		console.log("[searchEngine :: checkQueryStringOnUrl] :: 상단_검색 검색어가 없습니다.");
	}
}

////////////////////////////////////////
// 페이지 변경 시
////////////////////////////////////////
function changePage(searchSection, page) {
	console.log("[searchEngine :: change] :: searchSection -> " + searchSection + ", page -> " + page);
	let requestPage = page;
	if (requestPage < 0) {
		requestPage = 0;
	}
	let filterName = null;
	if (searchSection === "almIssue") {
		filterName = "project";
	} else if (searchSection === "log") {
		filterName = "log";
	}

	engineSearch(
		appendWildcard(searchString),
		searchSection,
		SearchApiModule.getRangeDate(),
		filterName,
		SearchApiModule.getSearchFilters(filterName),
		requestPage
	);
}

////////////////////////////////////////
// 검색날짜 기간 설정 세팅
////////////////////////////////////////
function datetTimePicker() {
	$("#date_timepicker_start").datetimepicker({
		format: "Y-m-d", // 날짜 및 시간 형식 지정
		formatDate: "Y/m/d",
		timepicker: false,
		theme: "dark",
		lang: "kr",
		onSelectTime: function (current_time, $input) {
			$("#date_timepicker_end").datetimepicker("setOptions", { minDate: current_time });
		},
		onShow: function (ct) {
			this.setOptions({
				maxDate: $("#date_timepicker_end").val() ? $("#date_timepicker_end").val() : false
			});
		}
	});
	$("#date_timepicker_end").datetimepicker({
		format: "Y-m-d", // 날짜 및 시간 형식 지정
		formatDate: "Y/m/d",
		timepicker: false,
		theme: "dark",
		lang: "kr",
		onSelectTime: function (current_time, $input) {
			$("#date_timepicker_start").datetimepicker("setOptions", { maxDate: current_time });
		},
		onShow: function (ct) {
			this.setOptions({
				minDate: $("#date_timepicker_start").val() ? $("#date_timepicker_start").val() : false
			});
		}
	});
}

////////////////////////////
// 검색날짜 기간 설정 모달 -
////////////////////////////
function customRangeSetting() {
	console.log("[searchEngine :: customRangeSetting] :: 실행");
	searchRangeType = "custom-range";
	SearchApiModule.setRangeDateAsync("custom-range")
		.then(() => {
			let rangeDate = SearchApiModule.getRangeDate();
			let start = rangeDate["start-date"]
				? new Date(rangeDate["start-date"]).toLocaleString("ko-KR", { timeZone: "Asia/Seoul" })
				: "";
			let end = rangeDate["end-date"]
				? new Date(rangeDate["end-date"]).toLocaleString("ko-KR", { timeZone: "Asia/Seoul" })
				: "";
			let rangeText = start + " ~ " + end;
			$("#filter_list").html("");
			$("#filter_list").append(`<li style="margin: 0 3px"><a>${rangeText}</a></li>`);

			if (searchString) {
				engineSearch(
					appendWildcard(searchString),
					"almIssue",
					rangeDate,
					"project",
					SearchApiModule.getSearchFilters("project")
				);
				engineSearch(appendWildcard(searchString), "log", rangeDate, "log", SearchApiModule.getSearchFilters("log"));
			} else {
				console.log("[searchEngine :: dateRangeFilterEvent] :: 검색어가 없습니다.");
			}
		})
		.catch((error) => {
			console.error("[searchEngine :: 날짜검색 이벤트리스너] :: 검색 오류 발생 =>", error);
		});
}

function validateSearchString(search_string) {
	if (search_string && $.trim(search_string) !== "" && !/^\*+$/.test($.trim(search_string))) {
		let searchTerm = $.trim(search_string);
		searchString = searchTerm;
	} else {
		// url 검색어 param 초기화
		setParameter("searchString", "");
		searchString = null;
		console.log("[searchEngine :: validateSearchString ] :: 검색어가 유효하지 않습니다.");
	}
}

function appendWildcard(searchTerm) {
	// 검색어의 마지막 문자가 *인지 확인
	if (searchTerm.slice(-1) !== "*") {
		// *이 없다면 *을 추가하여 반환
		return searchTerm + "*";
	}
	// *이 이미 있으면 검색어를 그대로 반환
	return searchTerm;
}
