var selectId; // 제품 아이디
var selectName; // 제품 이름
var selectedIndex; // 데이터테이블 선택한 인덱스
var selectedPage; // 데이터테이블 선택한 인덱스
var selectVersion; // 선택한 버전 아이디
var dataTableRef; // 데이터테이블 참조 변수
var versionList;

function execDocReady() {

    var pluginGroups = [
        [	"../reference/lightblue4/docs/lib/slimScroll/jquery.slimscroll.min.js",
            "../reference/lightblue4/docs/lib/d3/d3.min.js",
            "../reference/lightblue4/docs/lib/nvd3/build/nv.d3.min.js",
            "../reference/jquery-plugins/unityping-0.1.0/dist/jquery.unityping.min.js",
            "../reference/lightblue4/docs/lib/widgster/widgster.js",
            "../reference/jquery-plugins/html2canvas-1.4.1/html2canvas.js"],

        [	"../reference/jquery-plugins/select2-4.0.2/dist/css/select2_lightblue4.css",
            "../reference/jquery-plugins/lou-multi-select-0.9.12/css/multiselect-lightblue4.css",
            "../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select-bluelight.css",
            "../reference/jquery-plugins/select2-4.0.2/dist/js/select2.min.js",
            "../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.quicksearch.js",
            "../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.multi-select.js",
            "../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select.min.js"],

        [	"../reference/jquery-plugins/dataTables-1.10.16/media/css/jquery.dataTables_lightblue4.css",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/css/responsive.dataTables_lightblue4.css",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/css/select.dataTables_lightblue4.css",
            "../reference/jquery-plugins/dataTables-1.10.16/media/js/jquery.dataTables.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/js/dataTables.responsive.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/js/dataTables.select.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/RowGroup/js/dataTables.rowsGroup.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/dataTables.buttons.min.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.html5.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.print.js",
            "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/jszip.min.js"
        ]
    ];

    loadPluginGroupsParallelAndSequential(pluginGroups)
        .then(function() {

            console.log('모든 플러그인 로드 완료');

            //vfs_fonts 파일이 커서 defer 처리 함.
            setTimeout(function () {
                var script = document.createElement("script");
                script.src = "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/vfs_fonts.js";
                script.defer = true; // defer 속성 설정
                document.head.appendChild(script);
            }, 5000); // 5초 후에 실행됩니다.

            //pdfmake 파일이 커서 defer 처리 함.
            setTimeout(function () {
                var script = document.createElement("script");
                script.src = "../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/pdfmake.min.js";
                script.defer = true; // defer 속성 설정
                document.head.appendChild(script);
            }, 5000); // 5초 후에 실행됩니다.

            //사이드 메뉴 처리
            $('.widget').widgster();
            setSideMenu("sidebar_menu_support", "sidebar_menu_jira", "sidebar_menu_product_jira_connect");

            // 데이터 테이블 로드 함수
            var waitDataTable = setInterval(function () {
                try {
                    if (!$.fn.DataTable.isDataTable("#pdservice_table")) {
                        dataTableLoad();
                        clearInterval(waitDataTable);
                    }
                } catch (err) {
                    console.log("서비스 데이터 테이블 로드가 완료되지 않아서 초기화 재시도 중...");
                }
            }, 313 /*milli*/);


            setdata_for_multiSelect();//멀티셀렉트 세팅
            connect_pdservice_jira(); //제품서비스와 지라프로젝트 연결 실행
            init_versionList();   	  //버전 요소 생성
            downloadChartImage();     //차트 이미지 다운로드

            //d3Chart 그리기
            $.getScript("./js/pdServiceVersion/initD3Chart.js").done(function (script, textStatus) {
                initD3Chart("/auth-user/api/arms/pdService/getD3ChartData.do");
            });

            //스크립트 실행 로직을 이곳에 추가합니다.
            var 라따적용_클래스이름_배열 = ['.pdservice_version_alm_connect'];
            laddaBtnSetting(라따적용_클래스이름_배열);

        })
        .catch(function() {
            console.error('플러그인 로드 중 오류 발생');
        });

}
////////////////////////////////////////////////////////////////////////////////////////
// --- 데이터 테이블 설정 --- //
////////////////////////////////////////////////////////////////////////////////////////
function dataTableLoad() {
    // 데이터 테이블 컬럼 및 열그룹 구성
    var columnList = [
        { name: "c_id", title: "제품(서비스) 아이디", data: "c_id", visible: false },
        {
            name: "c_title",
            title: "제품(서비스) 이름",
            data: "c_title",
            render: function (data, type, row, meta) {
                if (type === "display") { //// 렌더링 시 이름을 라벨로 감싸서 표시
                    return '<label style="color: #a4c6ff">' + data + "</label>";
                }

                return data;
            },
            className: "dt-body-left",  // 좌측 정렬
            visible: true
        }
    ];
    var rowsGroupList = [];
    var columnDefList = [];
    var selectList = {};
    var orderList = [[0, "asc"]];
    var buttonList = [
        "copy",
        "excel",
        "print",
        {
            extend: "csv",
            text: "Export csv",
            charset: "utf-8",
            extension: ".csv",
            fieldSeparator: ",",
            fieldBoundary: "",
            bom: true
        },
        {
            extend: "pdfHtml5",
            orientation: "landscape",
            pageSize: "LEGAL"
        }
    ];

    var jquerySelector = "#pdservice_table";
    var ajaxUrl = "/auth-user/api/arms/pdServicePure/getPdServiceMonitor.do";
    var jsonRoot = "response";
    var isServerSide = false;
    console.log("jsonRoot:", jsonRoot);

    dataTableRef = dataTable_build(
        jquerySelector,
        ajaxUrl,
        jsonRoot,
        columnList,
        rowsGroupList,
        columnDefList,
        selectList,
        orderList,
        buttonList,
        isServerSide
    );

}

function copychecker() {
    dataTableRef.button(".buttons-copy").trigger();
}
function printchecker() {
    dataTableRef.button(".buttons-print").trigger();
}
function csvchecker() {
    dataTableRef.button(".buttons-csv").trigger();
}
function excelchecker() {
    dataTableRef.button(".buttons-excel").trigger();
}
function pdfchecker() {
    dataTableRef.button(".buttons-pdf").trigger();
}


// 데이터 테이블 구성 이후 꼭 구현해야 할 메소드 : 열 클릭시 이벤트
function dataTableClick(tempDataTable, selectedData) {
    $("#version_contents").html("");  //// 버전 상세 명세 초기화

    selectedIndex = selectedData.selectedIndex;
    selectedPage = selectedData.selectedPage;
    selectId = selectedData.c_id;
    selectName = selectedData.c_title;

    // console.log("selectedIndex:::::" + selectedIndex);
    // console.log("dataTableClick:: dataTableClick -> " + selectedData.c_id);


    $(".searchable").multiSelect("deselect_all");  // // 멀티셀렉트에서 모든 선택 해제
    $("#pdservice_connect").removeClass("btn-success");
    $("#pdservice_connect").addClass("btn-primary");
    $("#pdservice_connect").text("제품(서비스)-버전-ALM 연결 등록");

    //초기 태그 삭제
    $("#initDefaultVersion").remove();

    // //버전 리스트 로드
    dataLoad(selectedData.c_id, selectedData.c_title);



    // D3 업데이트
    // updateD3ByDataTable();

}

function dataTableDrawCallback(tableInfo) {
    $("#" + tableInfo.sInstance)
        .DataTable()
        .columns.adjust()
        .responsive.recalc();
}

//데이터 테이블 ajax load 이후 콜백.
function dataTableCallBack(settings, json) {}

////////////////////////////////////////////////////////////////////////////////////////
// 버전 리스트를 재로드하는 함수 ( 버전 추가, 갱신, 삭제 시 호출 )
////////////////////////////////////////////////////////////////////////////////////////
function dataLoad(getSelectedText, selectedText) {
    // ajax 처리 후 에디터 바인딩.
    console.log("dataLoad :: getSelectedID → " + getSelectedText);

    $.ajax("/auth-user/api/arms/pdService/getVersionList?c_id=" + getSelectedText).done(function (json) {
        console.log("dataLoad :: success → ", json);
        versionList = json.response;
        console.log("dataLoad :: versionList → ", versionList);
        $("#version_accordion").jsonMenu("set", json.response, { speed: 5000 });

        var selectedHtml =
            ` 
 			<div class="chat-message">
				<div    class="chat-message-body"
						style="margin-left: 0px !important; padding:!important;  border-left: 2px solid #a4c6ff; border-right: 2px solid #e5603b;">
					 <span  id="toRight"
							class="arrow"
							style="top: 10px !important; right: -7px; border-top: 5px solid transparent;
							border-bottom: 5px solid transparent;
							border-left: 5px solid #e5603b; border-right: 0px; left:unset;"></span>
					<span   class="arrow"
							style="top: 10px !important; border-right: 5px solid #a4c6ff;"></span>
					<div    class="sender"
							style="padding-bottom: 5px; padding-top: 5px">
						선택된 제품(서비스) :
						<span style="color: #a4c6ff;">
							` +  selectedText + `
						</span>
					</div>
				</div>
			</div>
			`;

        $(".list-group-item").html(selectedHtml);

        $("#tooltip_enabled_service_name").val(selectedText);
        // $("#select_PdService").text(selectedText); // sender 이름 바인딩


        //updateD3ByVersionList();
        setTimeout(function () {
            $("#pdService_Version_First_Child").trigger("click");
        }, 500);
    });
}

////////////////////////////////////////////////////////////////////////////////////////
// versionlist 이니셜라이즈
////////////////////////////////////////////////////////////////////////////////////////
function init_versionList() {
    let menu;
    $.fn.jsonMenu = function (action, items, options) {
        $(this).addClass("json-menu");
        if (action == "add") {
            menu.body.push(items);
            draw($(this), menu);
        } else if (action == "set") {
            menu = items;
            draw($(this), menu);
        }
        return this;
    };
}

////////////////////////////////////////////////////////////////////////////////////////
// version list html 삽입
////////////////////////////////////////////////////////////////////////////////////////
function draw(main, menu) {
    console.log("menu :: " + JSON.stringify(menu));
    console.table(menu);
    console.log("test data:: " + selectName);


    main.html("");
    var data ="";

    for (let i = 0; i < menu.length; i++) {

        if (i == 0) {  // select version\
            data += `
			   <div class="panel">
				   <div class="panel-heading">
					   <a class="accordion-toggle collapsed"
					   			data-toggle="collapse"
					   			id="pdService_Version_First_Child"
					   			name="versionLink_List"
					   			style="color: #a4c6ff; text-decoration: none; cursor: pointer;  "
           						onclick="versionClicks(this, ${menu[i].c_id}, '${menu[i].c_title}')">
						    ${menu[i].c_title}
 					   </a>
				   </div>
			   </div>`;
        } else {  // basic version
            data += `
			   <div class="panel">
				   <div class="panel-heading">
					   <a class="accordion-toggle collapsed"
					   			data-toggle="collapse"
					   			name="versionLink_List"
					   			style="color: #a4c6ff; text-decoration: none; cursor: pointer; "
           						onclick="versionClicks(this, ${menu[i].c_id}, '${menu[i].c_title}')">
						   ${menu[i].c_title}
					   </a>
				   </div>
			   </div>`;
        }
    }

    main.html(data);
}

////////////////////////////////////////////////////////////////////////////////////////
//버전 클릭할 때 동작하는 함수
////////////////////////////////////////////////////////////////////////////////////////
function versionClicks(element, c_id, c_title) {
    $("a[name='versionLink_List']").each(function () {
        this.style.background = "";
    });
    if (element == null) {
        console.log("element is empty");
    } else {
        element.style.background = "rgba(229, 96, 59, 0.3)";
        console.log("element is = " + element);
    }

    selectVersion = c_id;  // version c_id

    var coloredTitleHtml =
        `<div class="chat-message">
				<div class="chat-message-body" style="margin-left: 0px !important; border-left: 2px solid #e5603b;  ">
					<span 	class="arrow"
							style="top: 17px !important; border-right: 5px solid #e5603b;">
					</span>
					 <div    class="sender"
							style="padding-bottom: 5px; padding-top: 3px">
						<i class="fa fa-check"></i>
							선택된 제품
						<sup>서비스</sup> :
						<span   id="select_PdService"
								style="color: #a4c6ff">
								 ` +  selectName + `
						</span>
					</div>
					<div    class="sender"
							style="padding-bottom: 5px; padding-top: 3px">
						<i class="fa fa-check"></i> 선택된 버전 :
						<span   id="select_Version"
								style="color: #a4c6ff">
							   ` +  c_title + `
						</span>
					</div>
				</div>
			</div>`;
    //console.log("dataLoad :: coloredTitleHtml - >", coloredTitleHtml);

    $(".list-item").html(coloredTitleHtml);

    console.log("click :: C_ID ->  " + c_id);
    $(".searchable").multiSelect("deselect_all");  //선택된 항목들을 모두 선택 해제(해당 요소들에서 선택을 없애는)하는 코드
    // console.log("pdservice_link -> " +   $("#pdservice_table").DataTable().rows(".selected").data()[0].c_id);
    // console.log("pdserviceversion_link -> " +  c_id );

    // 이미 등록된 제품(서비스)-버전-지라 연결 정보가 있는지 확인
    console.log("선택한 버전의 제품서비스 아이디 : " + c_id);
    $.ajax({
        url: "/auth-user/api/arms/globaltreemap/getConnectInfo/pdService/pdServiceVersion/jiraProject.do",
        type: "GET",
        data: {
            pdserviceversion_link: c_id
        },
        contentType: "application/json;charset=UTF-8",
        dataType: "json",
        progress: true
    })
        .done(function (data) {
            var versionClickData = [];

            var multiSelectData = [];
            for (var k in data.response) {

                var obj = data.response[k];
                console.log("response data check:: obj ->   " + JSON.stringify(obj));
                console.table(obj);
                console.log("push obj.jiraproject_link :: => " + obj.jiraproject_link);

                multiSelectData.push(obj.jiraproject_link);
                console.log("push jiraproject :: => " + multiSelectData.push(obj.jiraproject_link));

                versionClickData.push(obj);
            }

            if (versionClickData.length == 0) {
                $("#pdservice_connect").removeClass("btn-success");
                $("#pdservice_connect").addClass("btn-primary");
                $("#pdservice_connect").text("제품(서비스)-버전-ALM 연결 등록");
            } else {
                $("#pdservice_connect").removeClass("btn-primary");
                $("#pdservice_connect").addClass("btn-success");
                $("#pdservice_connect").text("제품(서비스)-버전-ALM 연결 변경");

                $("#multiselect").multiSelect("select", multiSelectData.toString().split(","));
            }
        })
        .fail(function (e) {
            console.log("fail call");
        })
        .always(function () {
            console.log("always call");
        });
}

////////////////////////////////////////////////////////////////////////////////////////
// 제품(서비스)-버전-지라 저장
////////////////////////////////////////////////////////////////////////////////////////
function connect_pdservice_jira(){
    // console.log("pdservice_jira::: pdservice_version_id -> " + selectVersion);
    $("#pdservice_connect").click(function () {
        if ($("#pdservice_connect").hasClass("btn-primary") == true) {
            // data가 존재하지 않음.
            $.ajax({
                url: "/auth-user/api/arms/globaltreemap/setConnectInfo/pdService/pdServiceVersion/jiraProject.do",
                type: "POST",
                data: {
                    pdservice_link: $("#pdservice_table").DataTable().rows(".selected").data()[0].c_id,
                    pdserviceversion_link: selectVersion,
                    c_pdservice_jira_ids: JSON.stringify($("#multiselect").val())
                },
                progress: true
            })
                .done(function (data) {
                    //versionClick(null, selectVersion);
                    jSuccess("제품(서비스) - 버전 - JiraProject 가 연결되었습니다.");
                    initD3Chart("/auth-user/api/arms/pdService/getD3ChartData.do");
                })
                .fail(function (e) {
                    console.log("fail call");
                })
                .always(function (data) {
                    console.log("always call");
                    console.log("데이터 연결 등록  완료!");
                    console.log('multiselect data -> ' + JSON.stringify($("#multiselect").val()));

                });
        } else if ($("#pdservice_connect").hasClass("btn-success") == true) {
            // data가 이미 있음
            $.ajax({
                url: "/auth-user/api/arms/globaltreemap/setConnectInfo/pdService/pdServiceVersion/jiraProject.do",
                type: "POST",
                data: {
                    pdservice_link: $("#pdservice_table").DataTable().rows(".selected").data()[0].c_id,
                    pdserviceversion_link: selectVersion,
                    c_pdservice_jira_ids: JSON.stringify($("#multiselect").val())
                },
                progress: true
            })
                .done(function (data) {
                    //versionClick(null, selectVersion);
                    jSuccess("제품(서비스) - 버전 - JiraProject 가 연결되었습니다.");
                    console.log('connect data -> ' + data);
                })
                .fail(function (e) {
                    console.log("fail call");
                })
                .always(function (data) {
                    // 변경이 되면 그래프에도 변화가 있어야한다.
                    console.log("이미 있는 데이터 변경 완료 !");
                    initD3Chart("/auth-user/api/arms/pdService/getD3ChartData.do");
                });
        } else {
            jError("who are you?");
        }
    });
}


////////////////////////////////////////////////////////////////////////////////////////
// JIRA 프로젝트 데이터 로드 후 멀티 셀렉트 빌드 하고 슬림스크롤 적용
////////////////////////////////////////////////////////////////////////////////////////
/* --------------------------- multi select & slim scroll ---------------------------------- */
function setdata_for_multiSelect() {
    $.ajax({
        url: "/auth-user/api/arms/jiraServerProjectPure/getALMServerProjectPureListWithSoftDelete.do",
        type: "GET",
        contentType: "application/json;charset=UTF-8",
        dataType: "json",
        progress: true
    })
        .done(function (data) {
            console.log(data);
            let option_data = [];
            for (let i in data) {
                let alm_server = data[i];
                let server_name = alm_server.jiraServerProjectPureEntity.c_jira_server_name;
                let server_type = alm_server.jiraServerProjectPureEntity.c_jira_server_type;

                for (let j in alm_server.jiraServerProjectPureEntity.jiraProjectIssueTypePureEntities) {
                    let alm_project = alm_server.jiraServerProjectPureEntity.jiraProjectIssueTypePureEntities[j];
                    let alm_project_name = alm_project.c_jira_name;
                    let alm_project_c_id = alm_project.c_id;

                    // 온프레미스 -> 전역 이슈 타입, 클라우드 and 레마 -> 프로젝트별 이슈 타입
                    let issue_type_entities = server_type === "온프레미스" ?
                                                                alm_server.jiraServerProjectPureEntity.jiraIssueTypePureEntities : alm_project.jiraIssueTypePureEntities;

                    const issue_type = find_checked_true_entity(issue_type_entities);

                    let is_add_option = issue_type && (server_type === "클라우드" || server_type === "온프레미스");

                    if (server_type === "레드마인_온프레미스") {
                        const issue_priority = find_checked_true_entity(alm_server.jiraServerProjectPureEntity.jiraIssuePriorityEntities);
                        is_add_option = issue_type && issue_priority;
                    }

                    if (is_add_option) {
                        option_data.push(`<option data-server-type='${server_type}' value='${alm_project_c_id}'>[${server_name}] ${alm_project_name}</option>`);
                    }
                }
            }

            //프로젝트 목록 추가
            $(".searchable").html(option_data.join(""));

            ////////////////////////////////////////////////
            // 멀티 셀렉트 빌드
            buildMultiSelect();
            ////////////////////////////////////////////////
        })
        .fail(function (e) {
            console.log("fail call");
        })
        .always(function () {
            console.log("always call");
        });
}

function find_checked_true_entity(entities) {
    return entities && entities.length > 0 ? entities.find(entity => entity.c_check === "true") : null;
}

////////////////////////////////////////////////////////////////////////////////////////
// 멀티 셀렉트 초기화 함수
////////////////////////////////////////////////////////////////////////////////////////
function buildMultiSelect() {
    //multiselect
    $(".searchable").multiSelect({
        selectableHeader: "<input type='text' class='search-input' autocomplete='off' placeholder='Search Jira Project'>",
        selectionHeader: "<input type='text' class='search-input' autocomplete='off' placeholder='Selected Jira Project'>",
        afterInit: function (ms) {
            var that = this,
                $selectableSearch = that.$selectableUl.prev(),
                $selectionSearch = that.$selectionUl.prev(),
                selectableSearchString = "#" + that.$container.attr("id") + " .ms-elem-selectable:not(.ms-selected)",
                selectionSearchString = "#" + that.$container.attr("id") + " .ms-elem-selection.ms-selected";

            that.qs1 = $selectableSearch.quicksearch(selectableSearchString).on("keydown", function (e) {
                if (e.which === 40) {
                    that.$selectableUl.focus();
                    return false;
                }
            });

            that.qs2 = $selectionSearch.quicksearch(selectionSearchString).on("keydown", function (e) {
                if (e.which == 40) {
                    that.$selectionUl.focus();
                    return false;
                }
            });

            //slim scroll
            $(".ms-list").slimscroll({
                //size: '8px',
                //width: '100%',
                //height: 'fit-content',
                height: "450px"
                //color: '#ff4800',
                //allowPageScroll: true,
                //alwaysVisible: false,
                //railVisible: true,
                // scroll amount applied to each mouse wheel step
                //wheelStep: 20,
                // scroll amount applied when user is using gestures
                //touchScrollStep: 200,
                // distance in pixels between the side edge and the scrollbar
                //distance: '10px',
            });
        },
        afterSelect: function (value, text) {
            this.qs1.cache();
            this.qs2.cache();
            //d3Update();
        },
        afterDeselect: function (value, text) {
            this.qs1.cache();
            this.qs2.cache();
            //d3Update();
        }
    });
}

////////////////////////////////////////////////////////////////////////////////////////
// 이미지 다운로드
////////////////////////////////////////////////////////////////////////////////////////
function downloadChartImage() {
    $("#imageDownload").click( function () {
        // html2canvas 라이브러리를 사용하여 이미지로 렌더링
        html2canvas($(".darkBack")[0], {
            backgroundColor: null, // 기본 백그라운드 색상을 유지하기 위해 null로 설정
        }).then(function (canvas) {
            // 이미지 다운로드 링크 생성
            var downloadLink = document.createElement("a");
            downloadLink.download = "darkBack_image.png";
            downloadLink.href = canvas.toDataURL("image/png");

            // 이미지 다운로드
            downloadLink.click();
        });
    });
}
