(function ($) {
	"use strict";

	function EditorOperation(editor) {
		this.editor = editor;
	}

	EditorOperation.prototype.openClientSession = function () {};

	$(document).on("init.editor", function (event) {
		var target = event.target;
		var editor;

		CKEDITOR.replace(target.id, {
			contentsCss: ["../reference/bootstrap-3.4.1/css/bootstrap.min.css", "./css/ckeditor.css"],
			extraPlugins: ["drawio", "requirement", "linkeddoc", "accordion", "autogrow", "fixed"],
			allowedContent: true,
			removePlugins: ["resize"],
			autoGrow_minHeight: 650,
			autoGrow_bottomSpace: 50,
			autoGrow_onStartup: true,
			readOnly: true,
			on: {
				instanceReady: function (event) {
					editor = event.editor;
					var docHead = editor.document.getHead();

					function loadScript(src, callback) {
						var script = new CKEDITOR.dom.element("script");
						script.setAttribute("type", "text/javascript");
						script.setAttribute("src", src);

						if (callback) {
							script.on("load", callback);
						}

						docHead.append(script);
					}

					loadScript("../reference/lightblue4/docs/lib/jquery/dist/jquery.min.js", function () {
						loadScript("../reference/bootstrap-3.4.1/js/bootstrap.min.js");
					});
				},
				dataReady: function (event) {
					var iframeWindow = event.editor.document.getWindow().$;
					var $ = iframeWindow.jQuery;

					if ($) {
						var $body = $(event.editor.document.getBody().$);

						$body.on("click.bs.collapse.data-api", '[data-toggle="collapse"]', function (e) {
							var $this = $(this);

							if (!$this.attr("data-target")) e.preventDefault();

							var href;
							var $target = $(
								$this.attr("data-target") || ((href = $this.attr("href")) && href.replace(/.*(?=#[^\s]+$)/, ""))
							);

							var data = $target.data("bs.collapse");
							var option = data ? "toggle" : $this.data();

							if (!$target.hasClass("in")) {
								$.ajax({
									type: "GET",
									url: "/auth-user/api/arms/wiki/" + $target.attr("id") + "/getWiki.do",
									contentType: "application/json;charset=UTF-8",
									dataType: "json",
									success: function (data) {
										$target.find(".panel-body").html(data.contents);
									}
								});
							}

							$.fn.collapse.call($target, option);
						});
					}
				},
				saveDiagram: function (diagram) {
					var base64ToBlob = function (base64) {
						var parts = base64.split(";base64,");
						var contentType = parts[0].split(":")[1];
						var raw = window.atob(parts[1]);
						var rawLength = raw.length;
						var uInt8Array = new Uint8Array(rawLength);

						for (var i = 0; i < rawLength; i++) {
							uInt8Array[i] = raw.charCodeAt(i);
						}

						return new Blob([uInt8Array], { type: contentType });
					};

					var imageBlob = base64ToBlob(diagram.data.img);

					var formData = new FormData();
					formData.append("file", imageBlob, getWikiId() + "_" + "diagram.png");

					$.ajax({
						url: "/auth-user/api/arms/wiki/imageUpload.do",
						type: "POST",
						data: formData,
						processData: false,
						contentType: false,
						success: function (data) {
							var diagramImg = new CKEDITOR.dom.element("img", editor.document);
							diagramImg.setAttribute("src", data[0].url);
							diagramImg.setAttribute("alt", "draw.io Diagram");

							editor.insertElement(diagramImg);
						}
					});
				},
				editDiagram: function (imgSrc) {
					$.ajax({
						url: imgSrc.data,
						type: "GET",
						xhrFields: {
							responseType: "blob"
						},
						success: function (data) {
							var reader = new FileReader();
							reader.onloadend = function () {
								var base64data = reader.result;
								editor.execCommand("drawio", { src: base64data });
							};
							reader.readAsDataURL(data);
						}
					});
				},
				createRequirement: function (requirement) {
					var requirementModal = $("#requirement_modal");

					requirementModal.modal("show");
					requirementModal.on("shown.bs.modal", function () {
						var selectedPdServiceText = $("#selected_pdService").select2("data")[0].text;
						var datepickerOption = {
							theme: "dark",
							lang: "kr",
							format: "Y/m/d",
							formatDate: "Y/m/d",
							value: null,
							scrollInput: false
						};

						$("#addview_req_pdservice_name").val(selectedPdServiceText);
						$("#add_multi_version").multipleSelect("uncheckAll");
						$("#addview_req_title").val(requirement.data.reqTitle);
						$("#addview_req_writer").val("[" + userName + "]" + " - " + userID);
						$("#addview_req_reviewers").val(null).trigger("change");

						$("#addview_req_start_date").val(null);
						$("#addview_req_end_date").val(null);
						$("#addview_req_start_date").datetimepicker(datepickerOption);
						$("#addview_req_end_date").datetimepicker(datepickerOption);

						$("#addview_req_priority").children(".btn.active").removeClass("active");
						$("#addview_req_difficulty").children(".btn.active").removeClass("active");
						$("#addview_req_state").children(".btn.active").removeClass("active");

						CKEDITOR.instances.add_tabmodal_editor.setData($("<p />").text("요구사항 내용을 기록합니다."));
					});
				},
				selectionChange: function (evt) {
					var selection = evt.data.selection;
					var element = selection.getStartElement();
					var path = selection.getStartElement().getParents(true);

					console.log("Cursor position changed");
					console.log("Current element:", element.getName());
					console.log(
						"Path:",
						path.map((el) => (el.getName ? el.getName() : el))
					);
				}
			}
		});
	});
})(window.jQuery);
