package com.arms.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix = "gitea")
@Getter
@Setter
public class GiteaUserConfig {
    @Value("${spring.cloud.config.server.git.username}")
    private String gitUsername;
    @Value("${spring.cloud.config.server.git.password}")
    private String gitPassword;
    @Value("${spring.cloud.config.server.git.default-label}")
    private String gitBranch;
    @Value("${gitea.base-url}")
    private String baseUrl;
    @Value("${gitea.replace-url}")
    private String replaceUrl;
    @Value("${gitea.owner}")
    private String owner;

}
