package com.arms.api.util.alm.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;

import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CloudJiraIssueCreationFieldMetadata {

    private Integer startAt;
    private Integer maxResults;
    private Integer total;
    private List<FieldMetadata> fields;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class FieldMetadata {
        private boolean required;
        private String name;
        private String key;
        private String fieldId;
    }
}
