function validateAdminRole(valid, invalid, error) {
	$.ajax({
		url: "/auth-user/me",
		type: "GET",
		timeout: 7313,
		global: false,
		statusCode: {
			200: function (json) {
				var permissions = json.realm_access.roles;
				if (!permissions || permissions.indexOf("ROLE_ADMIN") === -1) {
					if (invalid) invalid();
				} else {
					// 어드민일 경우 json을 콜백으로 전달하니 json.preferred_username 등도 사용 가능
					if (valid) valid(json);
				}
			},
			401: function () {
				if (invalid) invalid();
			}
		},
		error: function () {
			if (error) error();
		}
	});
}
