/* jshint esversion: 6 */
/* jshint browser: true */
/* jshint devel: true */

////////////////////////////////////////////////////////////////////////////////////////
// Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
    let pluginGroups = [
        ["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
        ["../cover/css/faq.css"]
    ];

    loadPluginGroupsParallelAndSequential(pluginGroups)
        .then(function () {
            $(".widget").widgster();
            $("#sidebar").hide();
            $(".wrap").css("margin-left", 0);
            $("#footer").load("/cover/html/template/landing-footer.html");
            
            // 채팅 인터페이스 초기화
            initializeChatInterface();
        })
        .catch(function (error) {
            console.error("플러그인 로드 중 오류 발생");
            console.error(error);
        });
}


// chatInterface 클로저 모듈
const chatInterface = (function() {
    // private 변수들 (클로저 내부에서만 접근 가능)
    let messageInput;
    let sendBtn;
    
    // private 함수들
    function checkInput() {
        const hasText = messageInput.value.trim().length > 0;
        sendBtn.disabled = !hasText;
    }
    
    function handleSendClick() {
        if (!sendBtn.disabled) {
            const message = messageInput.value.trim();
            if (message) {
                // 메시지 전송 로직 (여기에 AI 응답 처리 추가)
                console.log('전송된 메시지:', message);
                
                // 입력창 초기화
                messageInput.value = '';
                checkInput(); // 버튼 상태 업데이트
            }
        }
    }
    
    function handleKeyDown(e) {
        if (e.key === 'Enter' && !e.shiftKey) {
            e.preventDefault();
            if (!sendBtn.disabled) {
                handleSendClick();
            }
        }
    }
    
    function setupEventListeners() {
        // 입력 이벤트 리스너
        messageInput.addEventListener('input', checkInput);
        messageInput.addEventListener('keyup', checkInput);
        messageInput.addEventListener('paste', checkInput);
        
        // 전송 버튼 클릭 이벤트
        sendBtn.addEventListener('click', handleSendClick);
        
        // 키보드 이벤트
        messageInput.addEventListener('keydown', handleKeyDown);
    }
    
    // public API 반환
    return {
        // 초기화 함수
        initialize: function() {
            messageInput = document.getElementById('messageInput');
            sendBtn = document.getElementById('sendBtn');
            
            if (messageInput && sendBtn) {
                setupEventListeners();
                checkInput(); // 초기 상태 설정
            }
        },
        
        // AI 질문 함수
        askAI: function(question) {
            if (messageInput && sendBtn) {
                messageInput.value = question;
                messageInput.focus();
                
                // 버튼 활성화
                checkInput();
                
                // 우측 AI 채팅 패널로 스크롤 (모바일에서 유용)
                const aiChatContainer = document.querySelector('.ai-chat-container');
                if (aiChatContainer) {
                    aiChatContainer.scrollIntoView({ behavior: 'smooth' });
                }
            }
        }
    };
})();

// 기존 함수명과 호환성을 위한 별칭
function initializeChatInterface() {
    chatInterface.initialize();
}

function askAI(question) {
    chatInterface.askAI(question);
}
