var isLoading = false;
var searchQuery = "";
var afterCount = 0;
var hasMoreData = true;
var currentSearchAfter = [];
////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		["../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js"]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			$(".widget").widgster();
            $("#sidebar").hide();
			$(".wrap").css("margin-left", 0);
            $("#footer").load("/cover/html/template/landing-footer.html");

			// 초기 데이터 로드
			drawBoardList([], "", false);
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}

// trace currentSearchAfter and loading-status
var boardComponents = (function () {
	return {
		loading: function () {
			return $(
				`<li
								role="status"
								class="list-group-item list-group-item-action util-animate-pulse">
								<h4 class="list-group-item-heading util-mb-4 util-h-4 util-w-48 util-rounded-full util-bg-gray-300 dark:util-bg-gray-600"></h4>

								<p class="list-group-item-text util-h-2.5 util-w-64 util-rounded-full util-bg-gray-200 dark:util-bg-gray-700"></p>

								<span class="sr-only">Loading...</span>
							</li>`
			);
		},
		main: function (board) {
			return $(
				`<section class="search-result">
								<h4>
									<a
										href="/cover/template.html?page=boardDetail&id=${board.id}"
										class="util-truncate">
										${board.subjectName}
									</a>
								</h4>
								<p class="text-success">
									<i class="fa fa-user"></i>
									${board.userName}
								</p>
								<p>
									<span class="util-mr-2">
										<i class="fa-solid fa-eye"></i>
										${board.viewCount || 0}
									</span>
									<span>${new Date(board.createdDate).toLocaleString()}</span>
								</p>
							</section>`
			);
		},
		noData: function () {
			return $(
				`<li class="list-group-item list-group-item-action">
								<p class="list-group-item-text text-center util-py-8 util-text-base" style="color: #313131">
									<i class="fa-solid fa-text-slash"></i>
									등록된 게시글이 없습니다.
								</p>
							</li>`
			);
		}
	};
})();

// 검색 시 페이지 초기화 및 무한 스크롤 재설정
$("#search_form").on("submit", function (event) {
	event.preventDefault();

	if (isLoading) {
		console.log("요청이 진행 중입니다. 잠시만 기다려 주세요.");
		return;
	}

	searchQuery = $(event.target).find("input").val();
	afterCount = 0; // append 수 초기화
	drawBoardList([], searchQuery, false);
});

// 로딩 표시기 요소 생성
function createMoreDataIndicator(_searchAfter, _subjectName, _append) {
	var $loadMoreContents = $(`<div id="loading-indicator" 
									class="text-center py-3 btn-info" 
									onclick="drawBoardList('${_searchAfter}', '${_subjectName}', '${_append}')">더 보기</div>`);
	$("#bbs").append($loadMoreContents);

	return document.getElementById("loading-indicator");
}

var drawBoardList = function (_searchAfter, _subjectName, _append) {
	var $bbs = $("#bbs");
	var SIZE = 10;

	// 로딩 중이면 중복 요청 방지
	if (isLoading) {
		return;
	}
	isLoading = true;

	if (_searchAfter && _searchAfter.length > 0) {
		afterCount++;
	}

	var params = {
		size: SIZE,
		searchAfter: _searchAfter
	};

	if (_subjectName) {
		params.subjectName = _subjectName;
	}

	$.ajax({
		url: "/bbs/board-list/only-post-list",
		type: "GET",
		data: params,
		beforeSend: function () {
			// 첫 로딩 시에만 전체 교체, 아니면 로딩 표시만
			if (!_append) {
				$bbs.html(boardComponents.loading());
			}
		},
		success: function (data) {
			let totalCount = data.response.totalHits;
			let strTotalCount = Number(totalCount).toLocaleString();
			if (totalCount >= 10000) {
				strTotalCount += "+";
			}
			$("#total_counts").text(strTotalCount);

			// 첫 로딩 시에만 페이지네이션 초기화
			if (!_append) {
				// 첫 로딩 시 목록 초기화
				$bbs.empty();
			} else {
				$("#loading-indicator").remove();
			}
			// 더 이상 데이터가 없는지 확인
			if (totalCount > 0 && totalCount < (1 + afterCount) * SIZE) {
				hasMoreData = false;
			} else hasMoreData = !(data.response.bbsEntities && data.response.bbsEntities.size < 10);

			if (totalCount === 0 || !data.response.bbsEntities || data.response.bbsEntities.size === 0) {
				return $bbs.append(boardComponents.noData());
			}

			// 데이터 추가
			data.response.bbsEntities.forEach(function (board) {
				$bbs.append(boardComponents.main(board));
			});

			currentSearchAfter = data.response.searchAfter;

			if (hasMoreData) {
				createMoreDataIndicator(currentSearchAfter, _subjectName, _append);
			}

			// 로딩 상태 해제
			isLoading = false;
		},
		error: function () {
			isLoading = false;
			$("#loading-indicator").remove();
		},
		complete: function () {
			isLoading = false; // 성공/실패 여부에 상관없이 요청 완료 시점에 해제
		}
	});
};
