////////////////////////////////////////////////////////////////////////////////////////
//Page 전역 변수
////////////////////////////////////////////////////////////////////////////////////////
var dataTableRef; // 데이터테이블 참조 변수
var groupMembersDataTable;
var attributesDataTable;
var realm = 'master'; // realm 명
var selectedGroup = { id: null, name: null, attributes: {} };

////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
  var pluginGroups = [
    [
      '../reference/light-blue/lib/vendor/jquery.ui.widget.js',
      '../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Templates_js_tmpl.js',
      '../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Load-Image_js_load-image.js',
      '../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Canvas-to-Blob_js_canvas-to-blob.js',
      '../reference/light-blue/lib/jquery.iframe-transport.js',
      '../reference/light-blue/lib/jquery.fileupload.js',
      '../reference/light-blue/lib/jquery.fileupload-fp.js',
      '../reference/light-blue/lib/jquery.fileupload-ui.js',
    ],

    [
      '../reference/jquery-plugins/select2-4.0.2/dist/css/select2_lightblue4.css',
      '../reference/jquery-plugins/lou-multi-select-0.9.12/css/multiselect-lightblue4.css',
      '../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select-bluelight.css',
      '../reference/jquery-plugins/select2-4.0.2/dist/js/select2.min.js',
      '../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.quicksearch.js',
      '../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.multi-select.js',
      '../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select.min.js',
    ],

    [
      '../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.min.css',
      '../reference/light-blue/lib/bootstrap-datepicker.js',
      '../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.full.min.js',
      '../reference/lightblue4/docs/lib/widgster/widgster.js',
      '../reference/lightblue4/docs/lib/slimScroll/jquery.slimscroll.min.js',
      '../reference/lightblue4/docs/lib/jquery.sparkline/index.js',
      '../reference/lightblue4/docs/js/charts.js',
      //jsTree
      '../reference/jquery-plugins/jstree-v.pre1.0/jquery.jstree.js',
      '../arms/js/common/table_new.js',
    ],

    [
      // datatables(13)
      '../reference/jquery-plugins/dataTables-1.10.16/media/css/jquery.dataTables_lightblue4.css',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/css/responsive.dataTables_lightblue4.css',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/css/select.dataTables_lightblue4.css',
      '../reference/jquery-plugins/dataTables-1.10.16/media/js/jquery.dataTables.min.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/js/dataTables.responsive.min.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/js/dataTables.select.min.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/RowGroup/js/dataTables.rowsGroup.min.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/dataTables.buttons.min.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.html5.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.print.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/jszip.min.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/pdfmake.min.js',
      '../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/vfs_fonts.js',
    ],
    // 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
  ];

  loadPluginGroupsParallelAndSequential(pluginGroups)
    .then(function () {
      console.log('모든 플러그인 로드 완료');

      // 사이드 메뉴 색상 설정
      $('.widget').widgster();
      setSideMenu('sidebar_menu_security', 'sidebar_menu_security_group');

      tabClickEvent();
      btnClickEvent();

      var waitDataTable = setInterval(function () {
        try {
          if (!$.fn.DataTable.isDataTable('#attributesTable')) {
            clearInterval(waitDataTable);
            $(document).trigger($.Event('init.attributeTable'));
          }
        } catch (err) {
          console.log('서비스 데이터 테이블 로드가 완료되지 않아서 초기화 재시도 중...');
        }
      }, 313 /*milli*/);

      // group List 조회
      getGroups();
    })
    .catch(function (error) {
      console.error('플러그인 로드 중 오류 발생');
      console.log(error);
    });
}

// 데이터 테이블 데이터 렌더링 이후 콜백 함수.
function dataTableCallBack() {
  console.log('table Callback');
}

function dataTableDrawCallback(tableInfo) {
  console.log('dataTableDrawCallback => ', tableInfo);
}

function dataTableClick(tempDataTable, selectedData) {
  console.log('tempDataTable => ', tempDataTable);
  console.log('tempDataTable => ', tempDataTable.context[0].sTableId);
  console.log('selectedData => ', selectedData);

  if (tempDataTable.context[0].sTableId === 'membersTable') {
    // 페이지 이동 with userId 함께
    let url = '/backoffice/template.html?page=securityUser&userId=' + selectedData.id;
    // user page 클릭 이벤트 연결 필요
    window.location.href = url;
  }
}

/////////////////////////////////
// jsTree 선택된 노드 판별 함수
/////////////////////////////////
function isDefaultOrFolderNode() {
  // root node 선택 또는 아무 노드도 선택하지 않았을 때
  if (selectedGroup.id === 'root_id' || selectedGroup.id === null) {
    return false;
  }
  // root 노드 제외하고 선택
  else {
    return true;
  }
}

//////////////////////
// Button Click Event
//////////////////////
function btnClickEvent() {
  /*
   * Group 추가
   */
  $('#btnGroupCreateSave').on('click', function () {
    console.log('btnClickEvent :: btnGroupCreateSave is submitted');
    let groupName = $('#modalCreateGroupName').val().trim();

    if (groupName) {
      if (isDefaultOrFolderNode()) {
        createChildGroup(selectedGroup.id, groupName);
      } else {
        createGroup(groupName);
      }
    } else {
      jError('그룹 이름을 입력해 주세요.');
    }
  });

  /*
   * Group 삭제
   */
  // 삭제모달
  $('#groupDeleteBtn').on('click', function () {
    console.log('btnClickEvent :: groupDeleteDtn is submitted');
    console.log('selectedGroup.name => ', selectedGroup.name);

    if (typeof selectedGroup.name === 'object') {
      $('#modalDeleteGroupName').val(selectedGroup.name.title);
    } else {
      $('#modalDeleteGroupName').val(selectedGroup.name);
    }
  });
  // 삭제 실행
  $('#btnGroupDelete').on('click', function () {
    deleteGroups(selectedGroup.id, selectedGroup.name);
  });

  /*
   * Group 명 변경
   */
  $('#name-edit-btn').on('click', function () {
    console.log('btnClickEvent :: name-edit-btn is submitted');
    if ($('#group-name').val() == '' || $('#group-name').val() === selectedGroup.name) {
      return false;
    } else {
      editGroupName(selectedGroup.id, $('#group-name').val());
    }
  });

  /*
   * Role Mappings
   */
  $('#available').on('change', function () {
    if ($(this).find('option:selected').length > 0) {
      $('#addSelected').removeAttr('disabled').addClass('btn-primary');
    } else {
      $('#addSelected').attr('disabled', 'disabled').removeClass('btn-primary');
    }

    $('#assigned').prop('selectedIndex', -1); // #assigned의 선택 해제
    $('#removeSelected').attr('disabled', 'disabled').removeClass('btn-danger');
  });

  $('#assigned').on('change', function () {
    if ($(this).find('option:selected').length > 0) {
      $('#removeSelected').removeAttr('disabled').addClass('btn-danger');
    } else {
      $('#removeSelected').attr('disabled', 'disabled').removeClass('btn-danger');
    }

    $('#available').prop('selectedIndex', -1); // #available의 선택 해제
    $('#addSelected').attr('disabled', 'disabled').removeClass('btn-primary');
  });

  $('#addSelected').on('click', function () {
    $('#available option:selected').each(function () {
      addRoleMapping(realm, selectedGroup.id, $(this).val());
    });
    if ($('#available option').length === 0) {
      $('#addSelected').attr('disabled', 'disabled').removeClass('btn-primary');
    }
    $('#assigned').prop('selectedIndex', -1); // #assigned의 선택 해제
    $('#addSelected').attr('disabled', 'disabled').removeClass('btn-primary');
    $('#removeSelected').attr('disabled', 'disabled').removeClass('btn-danger');
  });

  $('#removeSelected').on('click', function () {
    $('#assigned option:selected').each(function () {
      deleteRoleMapping(realm, selectedGroup.id, $(this).val());
    });
    if ($('#assigned option').length === 0) {
      $('#removeSelected').attr('disabled', 'disabled').removeClass('btn-danger');
    }
    $('#available').prop('selectedIndex', -1); // #available의 선택 해제
    $('#addSelected').attr('disabled', 'disabled').removeClass('btn-primary');
    $('#removeSelected').attr('disabled', 'disabled').removeClass('btn-danger');
  });
}

//////////////////////
// Tab Click Event
//////////////////////
function tabClickEvent() {
  $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    var target = $(e.target).attr('href'); // activated tab
    console.log('[ security :: group ] :: target => ' + target);

    if (target === '#groupSettings') {
      $('.tab-content .tab-pane').addClass('hidden');
      $('#groupSettings').removeClass('hidden');
    } else if (target === '#attributes') {
      $('.tab-content .tab-pane').addClass('hidden');
      $('#attributes').removeClass('hidden');
      if (!selectedGroup.id) {
        jError('선택된 그룹이 없습니다. 폴더 또는 일반 그룹을 선택해주세요.');
      } else if (selectedGroup.id === 'root_id') {
        jError('루트를 선택하셨습니다. 폴더 또는 일반 그룹을 선택해주세요.');
      }

      getAttributeInfo(selectedGroup.id);
    } else if (target === '#roleMappings') {
      $('.tab-content .tab-pane').addClass('hidden');
      $('#roleMappings').removeClass('hidden');
      if (!selectedGroup.id) {
        jError('선택된 그룹이 없습니다. 폴더 또는 일반 그룹을 선택해주세요.');
      } else if (selectedGroup.id === 'root_id') {
        jError('루트를 선택하셨습니다. 폴더 또는 일반 그룹을 선택해주세요.');
      }

      getComposite('master', selectedGroup.id);
      getAvailableRoles('master', selectedGroup.id);
      getAssignedRoles('master', selectedGroup.id);
    } else if (target === '#members') {
      // 그룹 유저

      $('.tab-content .tab-pane').addClass('hidden');
      $('#members').removeClass('hidden');
      if (!selectedGroup.id) {
        jError('선택된 그룹이 없습니다. 폴더 또는 일반 그룹을 선택해주세요.');
      } else if (selectedGroup.id === 'root_id') {
        jError('루트를 선택하셨습니다. 폴더 또는 일반 그룹을 선택해주세요.');
      }

      getGroupMembers('master', selectedGroup.id);
    }
  });
}

function groupMembersTableLoad(tableData) {
  var columnList = [
    {
      name: 'username',
      title: 'Username',
      data: 'username',
      render: function (data, type, row, meta) {
        if (isEmpty(data) || data === 'false') {
          return "<div style='color: #808080'>N/A</div>";
        } else {
          let displayText = data;
          let color = '#a4c6ff'; // color = "#f8f8f8"; // 기본 텍스트 색상
          return "<div style='white-space: nowrap; color: " + color + "'>" + displayText + '</div>';
        }
      },
      className: 'dt-body-left',
      visible: true,
    },
    {
      name: 'lastName',
      title: 'Last Name (Family Name)',
      data: 'lastName',
      render: function (data, type, row, meta) {
        if (isEmpty(data) || data === 'false') {
          return "<div style='color: #808080'>N/A</div>";
        } else {
          let displayText = data;
          let color = '#a4c6ff'; // color = "#f8f8f8"; // 기본 텍스트 색상
          return "<div style='white-space: nowrap; color: " + color + "'>" + displayText + '</div>';
        }
      },
      className: 'dt-body-left',
      visible: true,
    },
    {
      name: 'firstName',
      title: 'First Name',
      data: 'firstName',
      render: function (data, type, row, meta) {
        if (isEmpty(data) || data === 'false') {
          return "<div style='color: #808080'>N/A</div>";
        } else {
          let displayText = data;
          let color = '#a4c6ff'; // color = "#f8f8f8"; // 기본 텍스트 색상
          return "<div style='white-space: nowrap; color: " + color + "'>" + displayText + '</div>';
        }
      },
      className: 'dt-body-left',
      visible: true,
    },
    {
      name: 'email',
      title: 'Email',
      data: 'email',
      render: function (data, type, row, meta) {
        if (isEmpty(data) || data === 'false') {
          return "<div style='color: #808080'>N/A</div>";
        } else {
          let displayText = data;
          let color = '#a4c6ff'; // color = "#f8f8f8"; // 기본 텍스트 색상
          return "<div style='white-space: nowrap; color: " + color + "'>" + displayText + '</div>';
        }
      },
      className: 'dt-body-left',
      visible: true,
    },
    {
      name: 'id',
      title: '',
      data: 'id',
      orderable: false,
      render: function (data, type) {
        if (type === 'display' && data) {
          return $(`<button class='btn btn-sm btn-default' id="${data}">`).text('edit').prop('outerHTML');
        }
      },
      visible: true,
    },
  ];

  var rowsGroupList = [];
  var columnDefList = [
    {
      defaultContent: "<div style='color: #808080'>N/A</div>",
      targets: '_all',
    },
  ];
  var orderList = [[0, 'asc']];
  var jquerySelector = '#membersTable';
  var ajaxUrl = '';
  var jsonRoot = '';
  var buttonList = [];
  var selectList = {};
  var isServerSide = false;
  var isAjax = false;

  groupMembersDataTable = dataTable_build(
    jquerySelector,
    ajaxUrl,
    jsonRoot,
    columnList,
    rowsGroupList,
    columnDefList,
    selectList,
    orderList,
    buttonList,
    isServerSide,
    300,
    tableData,
    isAjax,
  );
}

function selectRoleMappings(targetElementId, results) {
  let optionData = [];

  results.forEach((item) => {
    if (item.name) {
      const optionValue = JSON.stringify({
        id: item.id,
        name: item.name,
        composite: item.composite,
        clientRole: item.clientRole,
        containerId: item.containerId,
      });

      optionData.push(`<option value='${optionValue}' title="${item.name}">${item.name}</option>`);
    }
  });

  $(`#${targetElementId}`).html(optionData);
}

function getRealmInfo() {
  $.ajax({
    url: '/auth-admin/realms/', // roleMapping 가져오는 api 연결
    type: 'GET',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    success: function (data) {
      // 'data' will be the List<RealmRepresentation> (as a JavaScript array)
      console.log('Realm data:', data);
    },
  });
}

function getGroups() {
  $.ajax({
    url: '/auth-admin/realms/master/groups', // roleMapping 가져오는 api 연결
    type: 'GET',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    success: function (response) {
      // 'data' will be the List<RealmRepresentation> (as a JavaScript array)
      console.log('Realm Groups :: data :', response);

      // 데이터를 변환하는 함수
      let convertData = convertDataToJsTreeFormat(response);
      console.log('[ jstree_build :: getGroups ] 변환 데이터: ', convertData);
      // 루트 추가하여 Tree 그리기
      drawTree(addRootNode(convertData));
    },
  });
}

function drawTree(data) {
  var $target = $('#groupTree');
  console.log('[ jstree_build :: drawTree ] 트리 데이터: ', data);
  if ($target.jstree(true)) {
    $target.jstree('destroy').html("<p class='text-center'>조회된 데이터가 없습니다.</p>");
  }

  $target
    .on('loaded.jstree', function (e, data) {
      $('#alog').append(data.func + '<br />');
      $("li:not([rel='default']).jstree-open > a > .jstree-icon").css(
        'background-image',
        'url(../reference/jquery-plugins/jstree-v.pre1.0/themes/toolbar_open.png)',
      );
      $("li:not([rel='default']).jstree-closed > a > .jstree-icon").css(
        'background-image',
        'url(../reference/jquery-plugins/jstree-v.pre1.0/themes/ic_explorer.png)',
      );
      $('#groupTree > ul > li:first-child > a > ins.jstree-icon').css(
        'background-image',
        'url("../reference/jquery-plugins/jstree-v.pre1.0/themes/home.png")',
      );
    })
    .jstree({
      plugins: ['themes', 'json_data', 'ui', 'crrm', 'dnd', 'types'],
      themes: { theme: ['lightblue4'] },
      json_data: data,
      search: {
        show_only_matches: true,
        search_callback: function (str, node) {
          return node.data().search(str);
        },
      },
      types: {
        types: {
          drive: {
            valid_children: ['default', 'folder'],
            icon: {
              image: '../reference/jquery-plugins/jstree-v.pre1.0/themes/home.png',
            },
            start_drag: false,
            move_node: false,
            delete_node: false,
            remove: false,
          },
          root: {
            valid_children: ['default', 'folder'],
            icon: {
              image: '../reference/jquery-plugins/jstree-v.pre1.0/themes/home.png',
            },
            start_drag: false,
            move_node: false,
            delete_node: false,
            remove: false,
          },
          folder: {
            valid_children: ['default', 'folder'],
            icon: {
              image: '../reference/jquery-plugins/jstree-v.pre1.0/themes/toolbar_open.png',
            },
          },
          default: {
            icon: {
              image: '../reference/jquery-plugins/jstree-v.pre1.0/themes/attibutes.png',
            },
          },
        },
      },
    })
    .on('select_node.jstree', function (_, data) {
      var type = data.rslt.obj.attr('rel');
      console.log('selected data.data=> ', data);
      console.log(type);
      console.log(data.inst.get_json()[0].metadata.id);
      var selectedId = data.inst.get_json()[0].metadata.id;
      var selectedName = data.inst.get_json()[0].data;
      console.log('Selected ID:', selectedId);

      selectedGroup.id = selectedId;
      selectedGroup.name = selectedName;

      // Group Settings > Settings tab - click trigger
      $('#nav-settings>a').click();

      initializeTabInputs(); // input 초기화

      if (selectedId === 'root_id') {
        // 그룹삭제 버튼 비활성화
        $('#groupDeleteBtn').prop('disabled', true);
        $('#groupDeleteBtn').removeClass('btn-danger');

        console.log('root is selected => ', selectedName);
        senderUpdate('root'); // Sender 표시 설정
      } else {
        // 그룹삭제 버튼 활성화
        $('#groupDeleteBtn').prop('disabled', false);
        $('#groupDeleteBtn').addClass('btn-danger');
        if (typeof selectedName === 'string') {
          getGroupInfo(selectedId); // API Call
          senderUpdate(selectedName); // Sender 표시 설정
        } else if (typeof selectedName === 'object') {
          getGroupInfo(selectedId); // API Call
          senderUpdate(selectedName.title); // Sender 표시 설정
        }
      }
    });
}

// auth-admin/realms/{realm}/group/{group}
function getGroupInfo(groupId) {
  $.ajax({
    url: '/auth-admin/realms/master/groups/' + groupId,
    type: 'GET',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    success: function (result) {
      // 'data' will be the List<RealmRepresentation> (as a JavaScript array)
      console.log('[Security Groups :: getGroupInfo] ::result :', result);
      selectedGroup = result;
      $('#group-name').val(result.name);
      senderUpdate(result.name); // Sender 표시 설정
    },
  });
}

function getAttributeInfo(groupId) {
  $.ajax({
    url: '/auth-admin/realms/master/groups/' + groupId,
    type: 'GET',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    success: function (result) {
      // 'data' will be the List<RealmRepresentation> (as a JavaScript array)
      console.log('[Realm Groups :: getAttributeInfo] :: result => ', result);
      let attributesMap = extractAttributes(result);
      console.log(attributesMap);
      $('#attributesTable').table().reDraw(attributesMap);
    },
  });
}

// 그룹명 변경
function editGroupName(groupId, groupName) {
  selectedGroup.name = groupName;

  $.ajax({
    url: '/auth-admin/realms/master/groups/' + groupId,
    type: 'PUT',
    contentType: 'application/json;charset=UTF-8',
    data: JSON.stringify(selectedGroup),
    success: function () {
      // 'data' will be the List<RealmRepresentation> (as a JavaScript array)
      console.log('[Security Groups :: editGroupName]');
      $('.jstree-clicked').html(`<ins class="jstree-icon">&nbsp;</ins> ${groupName}`);
      getGroups();
      getGroupInfo(groupId);
    },
    error: function (xhr, status, error) {
      getGroups();
      getGroupInfo(groupId);
      console.error('[Security Groups :: editGroupName] :: Error => ', error);
    },
  });
}

// 그룹 삭제
function deleteGroups(groupId, groupName) {
  $.ajax({
    url: '/auth-admin/realms/master/groups/' + groupId, //
    type: 'DELETE',
    contentType: 'application/json;charset=UTF-8',
    success: function () {
      // 'data' will be the List<RealmRepresentation> (as a JavaScript array)
      console.log('[Security Groups :: deleteGroups]');
      // 선택된 그룹 초기화
      selectedGroup = { id: null, name: null, attributes: {} };
      // sender 초기화
      initializeSender();

      jSuccess('그룹 ' + groupName + ' 삭제 성공');
      // 그룹 목록 조회
      getGroups();
    },
    error: function (xhr, status, error) {
      console.error('[Security Groups :: deleteGroups] :: Error => ', error);
    },
  });
}

// 신규 그룹 생성
function createGroup(groupName) {
  $.ajax({
    url: `/auth-admin/realms/${realm}/groups`,
    type: 'POST',
    contentType: 'application/json;charset=UTF-8',
    data: JSON.stringify({ name: groupName }),
    success: function () {
      // 'data' will be the List<RoleRepresentation> (as a JavaScript array)
      console.log('[Security Groups :: createGroup]');
      jSuccess('그룹 ' + groupName + ' 생성 완료');

      $('#modalCreateGroupName').val(null);
      // 그룹 목록 조회
      getGroups();
    },
  });
}

// 신규 자녀 그룹 생성
function createChildGroup(parentGoupId, groupName) {
  $.ajax({
    url: `/auth-admin/realms/${realm}/groups/${parentGoupId}/children`,
    type: 'POST',
    contentType: 'application/json;charset=UTF-8',
    data: JSON.stringify({ name: groupName }),
    success: function () {
      // 'data' will be the List<RoleRepresentation> (as a JavaScript array)
      console.log('[Security Groups :: createChildGroup]');
      jSuccess('그룹 ' + groupName + ' 생성 완료');

      $('#modalCreateGroupName').val(null);
      // 그룹 목록 조회
      getGroups();
    },
  });
}

// Role Mappings - Composite
function getComposite(realm, groupId) {
  $.ajax({
    url: `/auth-admin/realms/${realm}/groups/${groupId}/role-mappings/realm/composite`,
    type: 'GET',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    success: function (result) {
      // 'data' will be the List<RoleRepresentation> (as a JavaScript array)
      console.log('Realm getComposite :: result :', result);
      selectRoleMappings('effective', result);
    },
  });
}

function getAvailableRoles(realm, groupId) {
  $.ajax({
    url: `/auth-admin/realms/${realm}/groups/${groupId}/role-mappings/realm/available`,
    type: 'GET',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    success: function (result) {
      // 'data' will be the List<RoleRepresentation> (as a JavaScript array)
      console.log('Realm getAvailableRoles :: result :', result);
      selectRoleMappings('available', result);
    },
  });
}

function getAssignedRoles(realm, groupId) {
  $.ajax({
    url: `/auth-admin/realms/${realm}/groups/${groupId}/role-mappings/realm`,
    type: 'GET',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    success: function (result) {
      // 'data' will be the List<RoleRepresentation> (as a JavaScript array)
      console.log('Realm getAssignedRoles :: result :', result);
      selectRoleMappings('assigned', result);
    },
  });
}

function addRoleMapping(realm, groupId, role) {
  let roleArray = [JSON.parse(role)];
  $.ajax({
    url: `/auth-admin/realms/${realm}/groups/${groupId}/role-mappings/realm`,
    type: 'POST',
    contentType: 'application/json;charset=UTF-8',
    data: JSON.stringify(roleArray),
    success: function () {
      // 'data' will be the List<RoleRepresentation> (as a JavaScript array)
      console.log('Realm addRoleMapping');
      getAvailableRoles(realm, selectedGroup.id);
      getAssignedRoles(realm, selectedGroup.id);
      getComposite(realm, selectedGroup.id);
    },
  });
}

function deleteRoleMapping(realm, groupId, role) {
  let roleArray = [JSON.parse(role)];
  $.ajax({
    url: `/auth-admin/realms/${realm}/groups/${groupId}/role-mappings/realm`,
    type: 'DELETE',
    contentType: 'application/json;charset=UTF-8',
    data: JSON.stringify(roleArray),
    success: function () {
      console.log('Realm deleteRoleMapping');
      getAvailableRoles(realm, selectedGroup.id);
      getAssignedRoles(realm, selectedGroup.id);
      getComposite(realm, selectedGroup.id);
    },
  });
}

////////////////////////////////////////
// group - Members
////////////////////////////////////////
function getGroupMembers(realm, groupId) {
  $.ajax({
    url: `/auth-admin/realms/${realm}/groups/${groupId}/members`,
    type: 'GET',
    contentType: 'application/json;charset=UTF-8',
    dataType: 'json',
    success: function (result) {
      // 'data' will be the List<RoleRepresentation> (as a JavaScript array)
      console.log('Realm getGroupMembers :: result :', result);
      groupMembersTableLoad(result);
      //groupMembersDataTable.clear().rows.add(result).draw();
    },
  });
}

// input 초기화
function initializeTabInputs() {
  console.log('securityGroups :: initializeTabInputs');
  $('#group-name').val('');
}

// sender update
function senderUpdate(groupName) {
  $('#selectedGroup').text(groupName);
  $('.chat-message-body').css('border-left', '');
  $('.chat-message-body .arrow').css('border-right', '');
}

function initializeSender() {
  $('#selectedGroup').text('선택되지 않음');
  $('.chat-message-body').css('border-left', '2px solid #a4c6ff;');
  $('.chat-message-body .arrow').css('border-right', '5px solid #a4c6ff;');
}

///////////////////////////
// jsTree format 으로 변경
///////////////////////////
function convertDataToJsTreeFormat(inputData) {
  let result = { data: [] };

  // 데이터를 변환하는 내부 함수
  function processNode(item) {
    let node = {
      data: item.name,
      metadata: { id: item.id },
      children: [], // 자식 그룹이 있으면 이곳에 추가,
      // subGroups가 있으면 "folder", 없으면 "default"
      rel: item.subGroups && item.subGroups.length > 0 ? 'folder' : 'default',
      type: item.subGroups && item.subGroups.length > 0 ? 'folder' : 'default',
      state: item.subGroups && item.subGroups.length > 0 ? 'open' : null,
    };

    // 자식 그룹이 있다면 재귀적으로 처리
    if (item.subGroups && item.subGroups.length > 0) {
      item.subGroups.forEach((subGroup) => {
        node.children.push(processNode(subGroup)); // 자식 그룹 추가
      });
    }

    return node;
  }

  // 입력 데이터를 순차적으로 처리
  inputData.forEach((item) => {
    result.data.push(processNode(item));
  });

  return result;
}

function extractAttributes(data) {
  console.log(data);
  const attributes = data.attributes || {};
  return Object.entries(attributes).map(([key, value]) => ({
    key: key,
    value: value[0],
    btn: key,
  }));
}

function reformatAttributes(attributeList) {
  const reformattedData = {};
  if (attributeList.length === 0) {
    return reformattedData;
  } else {
    attributeList.forEach((item) => {
      reformattedData[item.key] = [item.value];
    });
  }
  return reformattedData;
}

+(function ($) {
  'use strict';

  var data;

  var getData = function () {
    return data;
  };

  var columns = [
    {
      name: 'key',
      title: 'Key',
      data: 'key',
      render: function (data, type, row, meta) {
        if (isEmpty(data) || data === 'false') {
          return "<div style='color: #f8f8f8'><input type='text' class='form-control parsley-validated font13 darkBack' name='attr-key' /></div>";
        } else {
          let displayText = data;
          let color = '#a4c6ff';
          return "<div style='white-space: nowrap; color: " + color + "'>" + displayText + '</div>';
        }
      },
      className: 'dt-body-left',
      visible: true,
    },
    {
      name: 'value',
      title: 'Value',
      data: 'value',
      render: function (data, type, row, meta) {
        if (isEmpty(data) || data === 'false') {
          return "<div style='color: #f8f8f8'><input type='text' class='form-control parsley-validated font13 darkBack' name='attr-value' /></div>";
        } else {
          let displayText = data;
          let color = '#a4c6ff';
          return "<div style='white-space: nowrap; color: " + color + "'>" + displayText + '</div>';
        }
      },
      className: 'dt-body-left',
      visible: true,
    },
    {
      name: 'btn',
      title: 'Actions',
      data: 'btn',
      visible: true,
      orderable: false,
      render: function (data, type) {
        return $("<button class='btn btn-sm btn-danger' name='remove_row'/>")
          .text('Del')
          .css('min-width', '35px')
          .prop('outerHTML');
      },
    },
  ];

  $(document).one('init.attributeTable', function () {
    $('#attributesTable')
      .on('click', "button[name='remove_row']", function (event) {
        console.log('remove_row is clicked');
        var $target = $(event.target);
        var row = $target.closest('tr');
        var thisTable = $('#attributesTable').table().table;
        var selectedRow = thisTable.row(row);

        thisTable.row(selectedRow).remove().draw(false);
        event.stopPropagation();
      })
      .on('change', "input[name='attr-key']", function (event) {
        var $target = $(event.target);
        var row = $target.closest('tr');
        var selectedRow = $('#attributesTable').table().table.row(row);
        var originData = selectedRow.data();

        selectedRow.data($.extend({}, originData, { key: $target.val() })).draw(false);
      })
      .on('change', "input[name='attr-value']", function (event) {
        var $target = $(event.target);
        var row = $target.closest('tr');
        var selectedRow = $('#attributesTable').table().table.row(row);
        var originData = selectedRow.data();

        selectedRow.data($.extend({}, originData, { value: $target.val() })).draw(false);
      })
      .table({
        order: [],
        columns: columns,
        dom: 'lBrtip', // dom: '<"pull-right"Blrtip>',
        buttons: [
          {
            text: '저장',
            className: 'btn btn-success btn-sm margin-bottom ml-sm pull-right',
            action: function (e, dt, node, config) {
              console.log('save Button Click');
              console.log($('#attributesTable').table().getDatas());
              if (selectedGroup) {
                updateAttributes(selectedGroup, $('#attributesTable').table().getDatas());
              } else {
                jError('Group을 선택해 주세요.');
              }
            },
          },
          {
            text: 'Attribute 추가',
            className: 'btn btn-warning btn-sm margin-bottom pull-right',
            action: function (e, dt, node, config) {
              dt.row
                .add({
                  key: '',
                  value: '',
                  btn: '',
                })
                .draw(false);
            },
          },
        ],
        data: [],
        drawCallback: function () {
          console.log('drawCallback');
        },
      });
  });
})(jQuery);

function updateAttributes(groupInfo, attributes) {
  // 변경된 attributes 으로 세팅
  let reformatted = reformatAttributes(attributes);
  groupInfo.attributes = reformatted;
  $.ajax({
    url: '/auth-admin/realms/master/groups/' + groupInfo.id, // roleMapping 가져오는 api 연결
    type: 'PUT',
    contentType: 'application/json;charset=UTF-8',
    data: JSON.stringify(groupInfo),
    success: function () {
      // 'data' will be the List<RealmRepresentation> (as a JavaScript array)
      console.log('[Security Groups :: editGroupAttributes]');
      $('.jstree-clicked').html(`<ins class="jstree-icon">&nbsp;</ins> ${groupInfo.name}`);
      $('#nav-attributes>a').click();
    },
    error: function (xhr, status, error) {
      getGroupInfo(groupInfo.id);
      console.error('[Security Groups :: editGroupName] :: Error => ', error);
    },
  });
}

function addRootNode(jsonData) {
  /**
   * JSON 데이터를 입력받아, 최상위에 "rel": "drive", "type": "drive" 이면서 "data": "Root"를 추가합니다.
   *
   * @param {Object} jsonData - 입력 JSON 데이터 (객체 형태).
   * @returns {Array} 수정된 JSON 데이터 (배열 형태).
   */
  const rootNode = {
    data: 'root',
    metadata: {
      id: 'root_id', // 필요에 따라 다른 ID로 변경 가능
    },
    children: jsonData.data,
    rel: 'drive',
    type: 'drive',
    state: 'open',
  };

  let results = {
    data: [rootNode],
  };
  return results;
}
