(function ($) {
	'use strict';

	var MappingAppAndHost = function () {
		this.table;
	};

	var url = 'html/generalconfig/content-container.html';

	MappingAppAndHost.prototype.create = function (data) {
		$.get(
			url,
			function (template) {
				var $element = $(template);

				$('#host-modal').append($element);
				$element.trigger('mad:localization', $element);

				var additionalHostTable = new $.fn.HostInfoTable('#additionalHostTable');

				this.table = new $.fn.HostInfoTable('#addedHostTable');

				var additionalHostInfo = data
					? hostInfos.filter(function (hostInfo) {
						return !data.find(function (mappingAppAndHost) {
							return mappingAppAndHost.c_id === hostInfo.c_id;
						});
					})
					: hostInfos;

				additionalHostTable.dataTableBuild({ data: additionalHostInfo, isAddCheckbox: true });
				this.table.dataTableBuild({ data: data || [], isAddCheckbox: true });

				$('#btn--append').click(
					function () {
						additionalHostTable.removeRows(
							function (selectedDatas) {
								this.table.addRows(selectedDatas);
							}.bind(this),
						);

						$(additionalHostTable.selector + ' thead input[name="checkall"]').prop('checked', false);
					}.bind(this),
				);

				$('#btn--remove').click(
					function () {
						this.table.removeRows(function (selectedDatas) {
							additionalHostTable.addRows(selectedDatas);
						});

						$(this.table.selector + ' thead input[name="checkall"]').prop('checked', false);
					}.bind(this),
				);
			}.bind(this),
		);
	};

	$.fn.MappingAppAndHost = MappingAppAndHost;
})(jQuery);
