+(function ($) {
	'use strict';

	var columnList = [
		{ name: 'c_id', title: '제품(서비스) 아이디', data: 'c_id', visible: false },
		{
			name: 'job_name',
			title: 'JOB 이름',
			data: 'job_name',
			render: function (data, type) {
				if (type === 'display') {
					if ([null, undefined, ''].includes(data)) {
						return getEmptyCell();
					} else {
						return getDefaultCell(data);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
			visible: true,
		},
		{
			name: 'cron_exp',
			title: 'Cron Job',
			data: 'cron_exp',
			render: function (data, type, row) {
				if (type === 'display') {
					if ([null, undefined, ''].includes(data)) {
						return $("<button class='btn btn-xs btn-transparent' />")
							.append($("<i class='fa fa-calendar text-warning' />"))
							.attr('data-toggle', 'modal')
							.attr('data-target', '#schedule_control_modal')
							.attr('data-row', JSON.stringify(row))
							.prop('outerHTML');
					} else {
						return (
							getDefaultCell(cronstrue.toString(data, { locale: 'ko', use24HourTimeFormat: true })) +
							$("<button class='btn btn-xs btn-transparent ml-xs' />")
								.append($("<i class='fa fa-calendar text-warning' />"))
								.attr('data-toggle', 'modal')
								.attr('data-target', '#schedule_control_modal')
								.attr('data-row', JSON.stringify(row))
								.prop('outerHTML')
						);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
			visible: true,
		},
		{
			name: 'job_status',
			title: '최종 실행 상태',
			data: 'job_status',
			render: function (data, type, row) {
				if (type === 'display') {
					if ([null, undefined, ''].includes(data)) {
						return getEmptyCell();
					} else {
						return (
							getDefaultCell(data) +
							$("<button class='btn btn-xs btn-transparent ml-xs' />")
								.append($("<i class='fa fa-search-plus text-warning' />"))
								.attr('data-toggle', 'modal')
								.attr('data-target', '#schedule_history_modal')
								.attr('data-host_link', row.c_id)
								.prop('outerHTML')
						);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
			visible: true,
		},
		{
			name: 'job_last_run_time',
			title: 'JOB 마지막 실행 시간',
			data: 'job_last_run_time',
			render: function (data, type) {
				if (type === 'display') {
					if ([null, undefined, ''].includes(data)) {
						return getEmptyCell();
					} else {
						return getDefaultCell(data);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
			visible: true,
		},
		{
			name: 'job_next_run_time',
			title: 'JOB 다음 실행 시간',
			data: 'job_next_run_time',
			render: function (data, type) {
				if (type === 'display') {
					if ([null, undefined, ''].includes(data)) {
						return getEmptyCell();
					} else {
						return getDefaultCell(data);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
			visible: true,
		},
	];

	$(document).on('init.schedule_list', function (event) {
		$.ScheduleConfigApi.getNodesWithoutRoot()().done(function (data) {
			$(event.target).table({
				data: data.result,
				columns: columnList,
				dom: 'Blfrtip',
				buttons: [
					{
						extend: 'excel',
						charset: 'UTF-8',
						bom: true,
						title: 'HyperMig_Schedule_Config_' + getCurrentDate(),
						className: 'btn btn-default btn-sm margin-bottom',
					},
				],
				order: [],
			});
		});
	});
})(jQuery);
