////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {

	var pluginGroups = [
		[	"../reference/light-blue/lib/vendor/jquery.ui.widget.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Templates_js_tmpl.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Load-Image_js_load-image.js",
			"../reference/light-blue/lib/vendor/http_blueimp.github.io_JavaScript-Canvas-to-Blob_js_canvas-to-blob.js",
			"../reference/light-blue/lib/jquery.iframe-transport.js",
			"../reference/light-blue/lib/jquery.fileupload.js",
			"../reference/light-blue/lib/jquery.fileupload-fp.js",
			"../reference/light-blue/lib/jquery.fileupload-ui.js"],

		[	"../reference/jquery-plugins/select2-4.0.2/dist/css/select2_lightblue4.css",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/css/multiselect-lightblue4.css",
			"../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select-bluelight.css",
			"../reference/jquery-plugins/select2-4.0.2/dist/js/select2.min.js",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.quicksearch.js",
			"../reference/jquery-plugins/lou-multi-select-0.9.12/js/jquery.multi-select.js",
			"../reference/jquery-plugins/multiple-select-1.5.2/dist/multiple-select.min.js"],

		[	"../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.min.css",
			"../reference/light-blue/lib/bootstrap-datepicker.js",
			"../reference/jquery-plugins/datetimepicker-2.5.20/build/jquery.datetimepicker.full.min.js",
			"../reference/lightblue4/docs/lib/widgster/widgster.js",
			//d3 변경
			"../reference/jquery-plugins/d3-6.7.0/d3.min.js",
			"../reference/lightblue4/docs/lib/slimScroll/jquery.slimscroll.min.js",
			// timerStyle
			"../reference/jquery-plugins/timerStyles.js"],

		["../reference/jquery-plugins/dataTables-1.10.16/media/css/jquery.dataTables_lightblue4.css",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/css/responsive.dataTables_lightblue4.css",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/css/select.dataTables_lightblue4.css",
			"../reference/jquery-plugins/dataTables-1.10.16/media/js/jquery.dataTables.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/js/dataTables.responsive.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/js/dataTables.select.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/RowGroup/js/dataTables.rowsGroup.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/dataTables.buttons.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.html5.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.print.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/jszip.min.js",
			"../reference/jquery-plugins/swiper-11.1.4/swiper-bundle.min.js",
			"../reference/jquery-plugins/swiper-11.1.4/swiper-bundle.min.css",
			"./js/common/swiperHelper.js",
			"./css/customSwiper.css"
		]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function() {

			console.log('모든 플러그인 로드 완료');

			//사이드 메뉴 처리
			$('.widget').widgster();
			setSideMenu("sidebar_menu_report", "sidebar_menu_report_weekly");

			//coming soon
			$("#count-down").TimeCircles(
				{
					circle_bg_color: "#f8f8f8",
					use_background: true,
					bg_width: .2,
					fg_width: 0.013,
					time: {
						Days: { color: "#f8f8f8" },
						Hours: { color: "#f8f8f8" },
						Minutes: { color: "#f8f8f8" },
						Seconds: { color: "#f8f8f8" }
					}
				}
			);

            //제품(서비스) 셀렉트 박스 이니시에이터
            makePdServiceSelectBox();
            //버전 멀티 셀렉트 박스 이니시에이터
            makeVersionMultiSelectBox();
            //주차 선택 셀렉트 박스 이니시에이터 (mock)
            makeWeekSelectBox();

		})
		.catch(function() {
			console.error('플러그인 로드 중 오류 발생');
		});

}

///////////////////////
//제품 서비스 셀렉트 박스
//////////////////////
function makePdServiceSelectBox() {
    //제품 서비스 셀렉트 박스 이니시에이터
    $(".chzn-select").each(function() {
        console.log("[ fullDataSheet :: makePdServiceSelectBox ] :: select2 data => ", $(this).data());
        $(this).select2($(this).data());
    });

    //제품 서비스 셀렉트 박스 데이터 바인딩
    $.ajax({
        url: "/auth-user/api/arms/pdServicePure/getPdServiceMonitor.do",
        type: "GET",
        contentType: "application/json;charset=UTF-8",
        dataType: "json",
        progress: true,
        statusCode: {
            200: function(data) {
                //////////////////////////////////////////////////////////
                pdServiceListData = [];
                for (var k in data.response) {
                    var obj = data.response[k];
                    pdServiceListData.push({ "pdServiceId": obj.c_id, "pdServiceName": obj.c_title });
                    var newOption = new Option(obj.c_title, obj.c_id, false, false);
                    $("#selected_pdService").append(newOption).trigger("change");
                }
                //////////////////////////////////////////////////////////
                console.log("[fullDataSheet :: makePdServiceSelectBox] :: pdServiceListData => ");
                console.table(pdServiceListData);
            }
        }
    });

    $("#selected_pdService").on("select2:open", function() {
        //슬림스크롤
        makeSlimScroll(".select2-results__options");
    });

    // --- select2 ( 제품(서비스) 검색 및 선택 ) 이벤트 --- //
    $("#selected_pdService").on("select2:select", function(e) {
        selectedPdServiceId = $("#selected_pdService").val();
        //refreshDetailChart(); 변수값_초기화();
        // 제품( 서비스 ) 선택했으니까 자동으로 버전을 선택할 수 있게 유도
        // 디폴트는 base version 을 선택하게 하고 ( select all )
        //~> 이벤트 연계 함수 :: Version 표시 jsTree 빌드
        bind_VersionData_By_PdService();
    });
} // end makePdServiceSelectBox()

////////////////////////////////////////
//버전 멀티 셀렉트 박스
////////////////////////////////////////
function makeVersionMultiSelectBox() {
    //버전 선택시 셀렉트 박스 이니시에이터
    $("#multiple-version").multipleSelect({
        filter: true,
        // selectBox 닫혔을 때
        onClose: function() {
            var versionTag = $("#multiple-version").val();
            console.log("[ fullDataSheet :: makeVersionMultiSelectBox ] :: versionTag");
            console.log(versionTag);
            selectedVersionIds = versionTag.join(",");

            if (versionTag === null || versionTag == "") {
                jError("버전이 선택되지 않았습니다.");
                $("#multiple-version").siblings(".ms-parent").css("z-index", 1000);
                return;
            }

            let filteredVersionData = versionListData.filter(item => versionTag.includes(item.c_id.toString()));
            // 시작일 종료일 세팅(datetimepicker)
            setEdgeDateRange(filteredVersionData);

            let optionalParams = setOptionalParams();

            $("#multiple-version").siblings(".ms-parent").css("z-index", 1000);

            if (!isAllAssigneesSelected()) {
                optionalParams.emailAddress = selectedAssigneeEmails;
            }

            fetchExcelData(selectedPdServiceId, optionalParams);

        },
        // selectBox 열렸을 때
        onOpen: function() {
            $("#multiple-version").siblings(".ms-parent").css("z-index", 9999);
        }
    });
}

function bind_VersionData_By_PdService() {
    $("#multiple-version option").remove();
    $.ajax({
        url: "/auth-user/api/arms/pdService/getVersionList?c_id=" + $("#selected_pdService").val(),
        type: "GET",
        dataType: "json",
        progress: true,
        statusCode: {
            200: function(data) {
                //////////////////////////////////////////////////////////
                var pdServiceVersionIds = [];
                versionListData = [];
                for (var k in data.response) {
                    var obj = data.response[k];
                    pdServiceVersionIds.push(obj.c_id);
                    versionListData.push({"c_id" : obj.c_id, "c_title" : obj.c_title,
                        "start_date" : obj.c_pds_version_start_date,
                        "end_date" : obj.c_pds_version_end_date});
                    var newOption = new Option(obj.c_title, obj.c_id, true, false);
                    $("#multiple-version").append(newOption);
                }
                selectedVersionIds = pdServiceVersionIds.join(",");

                $("#multiple-version")
                    .multipleSelect("refresh")
                    .multipleSelect("checkAll");

                // 시작일 종료일 세팅(datetimepicker)
                setEdgeDateRange(versionListData);

                let optionalParams = setOptionalParams();

                if (!isAllAssigneesSelected()) {
                    optionalParams.emailAddress = selectedAssigneeEmails;
                }

                fetchExcelData(selectedPdServiceId, optionalParams);

                if (data.length > 0) {
                    console.log("display 재설정.");
                }
            }
        }
    });
}

////////////////////////////////////////
// 선택한 버전 - min,max 날짜 세팅
////////////////////////////////////////
function setEdgeDateRange(versionData) {

    if (!versionData || Object.keys(versionData).length === 0) {
        console.log("[ fullDataSheet :: setEdgeDateRange ] :: versionData 가 없습니다.");
        return false;
    }

    let minMaxDate = versionData.reduce((acc, curr) => {
        const startDate = new Date(curr.start_date);
        const endDate = new Date(curr.end_date);

        if (!acc.min || startDate < acc.min) {
            acc.min = startDate;
        }

        if (!acc.max || endDate > acc.max) {
            acc.max = endDate;
        }

        return acc;
    }, { min: null, max: null });
    console.log("[ fullDataSheet :: setEdgeDateRange ] :: " +
        "minMaxDate.min => " + minMaxDate.min+ ", minMaxDate.max => " +minMaxDate.max);

    const oneMonthAgo = new Date(minMaxDate.max);
    oneMonthAgo.setMonth(oneMonthAgo.getMonth() - 1);

    if (oneMonthAgo > minMaxDate.min) {
        oneMonthAgo.setTime(minMaxDate.min.getTime());
    }

    $('#date_timepicker_start').datetimepicker('setOptions', {
        value: oneMonthAgo
    });

    $('#date_timepicker_end').datetimepicker('setOptions', {
        value: minMaxDate.max
    });
}

////////////////////////////////////////
// 검색 조건을 선택하여 API 호출 시, 제품 버전이 모두 선택되어 있는지 체크하는 함수
// 모두 선택 된 경우, query param 으로 보낼 필요가 없기 때문
////////////////////////////////////////
function isAllVersionsSelected() {
    if (!selectedVersionIds) {
        return false;
    }
    return $("#multiple-version option").length === selectedVersionIds.split(",").length;
}
////////////////////////////////////////
// 검색 조건을 선택하여 API 호출 시, 작업자가 모두 선택되어 있는지 체크하는 함수
// 모두 선택 된 경우, query param 으로 보낼 필요가 없기 때문
////////////////////////////////////////
function isAllAssigneesSelected() {
    if (!selectedAssigneeEmails) {
        return false;
    }
    return $("#multiple-assignees option").length === selectedAssigneeEmails.split(",").length;
}

function makeWeekSelectBox() {

    $(".chzn-select").each(function() {
        $(this).select2($(this).data());
    });

    let mockWeek = [
        { "week": "1주차", "order" : 1 },
        { "week": "2주차", "order" : 2 },
        { "week": "3주차", "order" : 3 },
        { "week": "4주차", "order" : 4 },
        { "week": "5주차", "order" : 5 },
        { "week": "6주차", "order" : 6 },
        { "week": "7주차", "order" : 7 },
        { "week": "8주차", "order" : 8 },
        { "week": "9주차", "order" : 9 },
        { "week": "10주차", "order" : 10 },
    ];
    for (var week of mockWeek) {
        console.log(week);
        var newOption = new Option(week.week, week.order, false, false)
        $("#select-week").append(newOption).trigger("change");
    }
}