var ModalTabFunction = (function(){
	"use strict";

	// Modal Chart / Modal Exce의 Tab 메뉴별 동작 설정
	// 엑셀 데이터 높이 고정을 위한, 계산
	let chart_height = $("#chart_data").height();
	let chart_width = $("#chart_data").width();

	let lastSelected = {
		pdServiceId : null,
		versionId: null,
		chartName: null,
		result: null
	};

	function getLastSelected() {
		return lastSelected;
	};

	// chart_height 고정
	if(chart_height) {
		console.log("엑셀 데이터 높이 고정");
		$('#excel_data').height(chart_height);
		console.log("엑셀 높이 =>" + $("#chart_data").height());
	}

	let notificationNotSelected = function (element) {
		return `<span style="margin: auto">
							※ Notification ※
							<br/>
							전체 데이터 렌더링 영역 입니다.
							<br/>
							<br/>
							"${element}"가 선택되지 않았습니다.
							<br/>
							<br/>
							첫번째 탭은 데이터를 활용한 차트 렌더링 영역입니다.
							<br/>
							두번째 탭은 차트 관련 데이터를 엑셀 형태로 제공하고 있습니다.
							</span>`;
	};

	let notificationNoResult = function () {
		return `<span style="margin: auto">
							※ Notification ※
							<br/>							
							<br/>
							<br/>
							가져온 데이터가 없습니다.
							제품(서비스) 와 버전을 확인해주세요.
							<br/>
							<br/>							
							<br/>							
							</span>`;
	};

	function initTabEvents() {
		// Tab 이벤트
		$('a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
			var target = $(e.target).attr("href"); // 활성화된 탭의 href

			if (target === "#chart_data") {
				if (lastSelected && lastSelected.result !== null) {
					console.log("modalTabFunction :: drawChartWithoutAPI");
					ModalTabFunction.drawChartWithoutAPI();
				} else {
					console.log("modalTabFunction :: drawChart");
					ModalTabFunction.drawChart();
				}
			} else if (target === "#excel_data") {
				console.log("Excel tab 로직 처리");
				ModalTabFunction.drawModalExcel();
			}
		});
	}

	var resizeObserver = new ResizeObserver(function(entries) {
		for (let entry of entries) {
			var width = entry.contentRect.width;
			var height = entry.contentRect.height;
			handleResize(entry.target.id, width, height);
		}
	});

	// 모달요소 크기 변화 관찰
	resizeObserver.observe(document.getElementById('chart_data'));
	resizeObserver.observe(document.getElementById('excel_data'));

	function handleResize(id,width, height) {
		console.log('id: '+ id +' Modal resized to: ' + width + 'x' + height);
		if (id ==="excel_data" && height !== 0) {
			chart_height = height;
			chart_width = width;
			if(chart_height > 70) {
				ModalTabFunction.drawModalExcel();
			} else {
				console.log("엑셀 데이터를 그릴 영역의 넓이가 너무 작습니다.");
			}
		} else if (id ==="chart_data" && height !== 0) {
			chart_height = height;
			chart_width = width;
		}
	}

	function drawChart() {
		throw new Error("drawChart must be implemented by the importing page.");
	}

	function drawChartWithoutAPI() {
		throw new Error("drawChartWithoutAPI must be implemented by the importing page.");
	}

	function resetFilter() {
		throw new Error("resetFilter must be implemented by the importing page.");
	}

	function excelExport() {
		throw new Error("excelExport must be implemented by the importing page, or use default excel-download");
	}


	return {
		handleResize,
		drawChart,
		drawChartWithoutAPI,
		initTabEvents,
		getLastSelected,
		notificationNotSelected,
		notificationNoResult,
		resetFilter,
		excelExport
	}
})(jQuery);