(function ($) {
	$(document).on("create.wikiList", function (event) {
		var $target = $(event.target);
		var serviceNameForURL = "/auth-user/api/arms/wiki/T_ARMS_WIKI_" + $("#selected_pdService").val();

		$target
			.jstree({
				plugins: ["themes", "json_data", "ui", "crrm", "dnd", "search", "types", "contextmenu"],
				themes: { theme: ["lightblue4"] },
				types: {
					max_depth: -2,
					max_children: -2,
					valid_children: ["drive"],
					types: {
						default: {
							valid_children: "none",
							icon: {
								image: "../reference/jquery-plugins/jstree-v.pre1.0/themes/attibutes.png"
							}
						},
						folder: {
							valid_children: ["default", "folder"],
							icon: {
								image: "../reference/jquery-plugins/jstree-v.pre1.0/themes/ic_explorer.png"
							}
						},
						drive: {
							valid_children: ["default", "folder"],
							icon: {
								image: "../reference/jquery-plugins/jstree-v.pre1.0/themes/home.png"
							},
							start_drag: false,
							move_node: false,
							delete_node: false,
							remove: false
						}
					}
				},
				contextmenu: {
					items: {
						create: {
							separator_before: true,
							separator_after: true,
							label: "Create",
							action: false,
							submenu: {
								create_file: {
									seperator_before: false,
									seperator_after: false,
									label: "<i class='fa fa-file'></i> New File",
									action: function (obj) {
										this.create(obj, "last", {
											attr: {
												rel: "default"
											}
										});
									}
								},
								create_folder: {
									seperator_before: false,
									seperator_after: false,
									label: "<i class='fa fa-folder-open'></i> New Folder",
									action: function (obj) {
										this.create(obj, "last", {
											attr: {
												rel: "folder"
											}
										});
									}
								}
							}
						},
						copylink: {
							seperator_before: false,
							seperator_after: false,
							label: "Copy Link",
							action: function (obj) {
								var link =
									location.origin +
									location.pathname +
									"?page=adms&pdServiceId=" +
									$("#selected_pdService").val() +
									"&wikiId=" +
									obj.attr("id").replace("node_", "").replace("copy_", "");

								if (typeof navigator.clipboard == "undefined") {
									var textArea = document.createElement("textarea");
									textArea.value = link;
									textArea.style.position = "fixed"; //avoid scrolling to bottom
									document.body.appendChild(textArea);
									textArea.focus();
									textArea.select();

									document.execCommand("copy");
									document.body.removeChild(textArea);
									return;
								}

								navigator.clipboard.writeText(link);
							}
						},
						ccp: false
					}
				},
				json_data: {
					ajax: {
						url: serviceNameForURL + "/getChildNode.do",
						cache: false,
						data: function (n) {
							console.log("[ common :: jsTreeBuild ] :: json data load = ", n);

							return {
								c_id: n.attr ? n.attr("id").replace("node_", "").replace("copy_", "") : 1
							};
						}
					}
				},
				search: {
					ajax: {
						url: serviceNameForURL + "/searchNode.do",
						data: function (str) {
							return {
								searchString: str
							};
						},
						success: function (n) {
							jSuccess("search data complete");
						}
					}
				},
				core: {
					initially_open: ["node_2", "node_3"]
				}
			})
			.on("select_node.jstree", function (_, data) {
				var selectedNode = data.rslt.obj;
				var selectRel = selectedNode.attr("rel");

				$("#btn_save_contents").addClass("hidden");
				$("#btn_cancel").addClass("hidden");
				$("#version_warning").addClass("hidden");

				CKEDITOR.instances["editor"].setReadOnly(true);

				if (selectRel === "default") {
					$("#btn_edit_contents").removeClass("hidden");
					$("#btn_version").removeClass("hidden");
					$.ajax({
						type: "GET",
						url: "/auth-user/api/arms/wiki/" + getWikiId() + "/getWiki.do",
						contentType: "application/json;charset=UTF-8",
						dataType: "json",
						success: function (data) {
							CKEDITOR.instances["editor"].setData(data.contents);
							$("#editor_copy").html(data.contents);
						}
					});
				} else {
					if (data.inst.is_open()) {
						data.inst.close_node();
					} else {
						data.inst.open_node();
					}
				}
			})
			.on("create.jstree", function (e, data) {
				$.ajax({
					async: false,
					type: "POST",
					url: serviceNameForURL + "/addNode.do",
					data: {
						ref: data.rslt.parent.attr("id").replace("node_", "").replace("copy_", ""),
						c_position: data.rslt.position,
						c_title: data.rslt.name,
						c_type: data.rslt.obj.attr("rel")
					},
					success: function (newNode) {
						$(data.rslt.obj).attr("id", newNode.c_id);
					}
				});
			})
			.on("remove.jstree", function (e, data) {
				data.rslt.obj.each(function () {
					$.ajax({
						async: false,
						type: "DELETE",
						url: serviceNameForURL + "/removeNode.do",
						data: {
							c_id: this.id.replace("node_", "").replace("copy_", "")
						},
						error: function () {
							jError("Notification : <strong>Remove Node</strong>, Failed !");
						}
					});
				});
			})
			.on("move_node.jstree", function (e, data) {
				data.rslt.o.each(function (i) {
					$.ajax({
						async: false,
						type: "POST",
						url: serviceNameForURL + "/moveNode.do",
						data: {
							c_id: this.id.replace("node_", "").replace("copy_", ""),
							ref: data.rslt.cr.attr("id").replace("node_", "").replace("copy_", ""),
							c_position: data.rslt.cp + i,
							copy: 0,
							multiCounter: i
						}
					});
				});
			})
			.on("rename.jstree", function (_, data) {
				$.ajax({
					type: "PUT",
					url: serviceNameForURL + "/alterNode.do",
					data: {
						c_id: data.rslt.obj.attr("id").replace("node_", "").replace("copy_", ""),
						c_title: data.rslt.new_name,
						c_type: data.rslt.obj.attr("rel")
					}
				});
			})
			.on("loaded.jstree", function () {
				var urlParams = new URL(location.href).searchParams;
				var wikiId = urlParams.get("wikiId");

				if (wikiId !== null) {
					if (wikiId < 2) {
						jError("존재하지 않는 문서입니다.");
						return false;
					}

					var nodeIndex = 0;
					var nodePath = [wikiId];

					var selectNodeWithPath = function () {
						var nodeId = nodePath[nodeIndex];
						var $node = $("#node_" + nodeId);

						if (nodeIndex >= nodePath.length - 1) {
							$target.jstree("select_node", $node);
							$target.off("load_node.jstree", selectNodeWithPath);

							return;
						}

						nodeIndex += 1;
						$target.jstree("open_node", $node);
					};

					var loadNode = function (nodeId) {
						$.ajax({
							type: "GET",
							url: serviceNameForURL + "/getNode.do",
							data: { c_id: nodeId },
							success: function (node) {
								var $parentNode = $("#node_" + node.c_parentid);

								if ($parentNode.length) {
									$target.on("load_node.jstree", selectNodeWithPath);
									var isOpen = $target.jstree("is_open", $parentNode);

									if (isOpen) {
										selectNodeWithPath();
									} else {
										$target.jstree("open_node", $parentNode);
									}
									return;
								}

								nodePath = [node.c_parentid].concat(nodePath);
								loadNode(node.c_parentid);
							},
							error: function () {
								jError("존재하지 않는 문서입니다.");
							}
						});
					};

					var $node = $("#node_" + wikiId);
					if ($node.length) {
						$target.jstree("select_node", $node);
						return;
					}

					loadNode(wikiId);
				}
			});
	});
})(jQuery);
