(function ($) {
	"use strict";

	var columnList = [
		{
			name: "version",
			title: "버전",
			data: "version",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>V." + data + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		},
		{
			name: "updatedDate",
			title: "생성 날짜",
			data: "updatedDate",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>" + new Date(data).toLocaleString() + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		},
		{
			name: "author",
			title: "작성자",
			data: "author",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>" + data + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		},
		{
			data: null,
			title: "",
			render: function (data, type, row) {
				if (row.recent) {
					return "<span class='label label-info no-margin'>현재 버전</span>";
				}

				return $("<button class='btn btn-sm btn-warning btn-restore' type='button'>복원</button>")
					.attr("data-row", JSON.stringify(row))
					.prop("outerHTML");
			},
			orderable: false
		}
	];

	$(document).on("init.version_list", function (event) {
		$(event.target).table({
			columns: columnList,
			columnDefs: [
				{
					targets: 3,
					orderable: false,
					searchable: false,
					data: null,
					defaultContent: ""
				}
			],
			ordering: false,
			dom: "Brtip",
			buttons: [
				{
					extend: "excel",
					charset: "UTF-8",
					bom: true,
					className: "btn btn-default btn-sm margin-bottom"
				}
			],
			ajax: {
				url: "/auth-user/api/arms/wiki/" + getWikiId() + "/getWikiVersions.do",
				data: function (d) {
					return {
						size: d.length,
						page: Math.ceil(d.start / d.length)
					};
				},
				dataFilter: function (_data) {
					var data = JSON.parse(_data);
					data = data.body.response;

					return JSON.stringify({
						data: data.wikiVersions,
						recordsTotal: data.totalHits,
						recordsFiltered: data.totalHits
					});
				}
			},
			serverSide: true
		});
	});
})(jQuery);
