/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.redisrepo;

import com.arms.api.util.redisrepo.CustomRedisTemplate;
import com.arms.api.util.redisrepo.util.KeyName;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class CustomRedisTemplateImpl
implements CustomRedisTemplate {
    private final RedisTemplate<String, Object> redisTemplate;

    public List<String> scan(String id) {
        List<String> list;
        block9: {
            RedisConnectionFactory connectionFactory = this.redisTemplate.getConnectionFactory();
            if (connectionFactory == null) {
                throw new IllegalStateException("RedisConnectionFactory is not available");
            }
            RedisConnection connection = connectionFactory.getConnection();
            try {
                list = connection.scan(ScanOptions.scanOptions().match(id).count(200L).build()).stream().map(a -> new KeyName(new String((byte[])a, StandardCharsets.UTF_8)).get()).collect(Collectors.toList());
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error during scanning Redis keys", e);
                }
            }
            connection.close();
        }
        return list;
    }

    public void deleteByPattern(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        if (keys != null && !keys.isEmpty()) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public CustomRedisTemplateImpl(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

