/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.repository.configuration.EnableRedisRepositories;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.data.redis.config.annotation.web.server.EnableRedisWebSession;
import org.springframework.web.reactive.config.EnableWebFlux;

@Configuration
@EnableWebFlux
@EnableRedisRepositories
@EnableRedisWebSession(maxInactiveIntervalInSeconds=7200)
public class RedisConfig {
    private static final Logger logger = LoggerFactory.getLogger(RedisConfig.class);

    @Bean
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory connectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(connectionFactory);
        return template;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    public ReactiveRedisTemplate<String, Object> reactiveRedisTemplate(ReactiveRedisConnectionFactory factory) {
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext((RedisSerializer)new StringRedisSerializer()).hashKey((RedisSerializer)new StringRedisSerializer()).hashValue((RedisSerializer)new GenericJackson2JsonRedisSerializer()).build();
        return new ReactiveRedisTemplate(factory, serializationContext);
    }

    @Bean
    public RedisScript<Boolean> updateContentAndHistoryScript() {
        String luaScript = "local contentKey = KEYS[1]\nlocal historyKey = KEYS[2]\nlocal newContent = ARGV[1]\nlocal operationJson = ARGV[2]\n\nredis.call('SET', contentKey, newContent)\nredis.call('RPUSH', historyKey, operationJson)\n\nlocal maxHistory = tonumber(ARGV[3])\nif maxHistory and maxHistory > 0 then\n    local currentSize = redis.call('LLEN', historyKey)\n    if currentSize > maxHistory then\n        redis.call('LTRIM', historyKey, currentSize - maxHistory, -1)\n    end\nend\n\nreturn true";
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText(luaScript);
        redisScript.setResultType(Boolean.class);
        return redisScript;
    }
}

