/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.response;

import com.arms.api.util.errors.response.ErrorCode;
import com.arms.api.util.response.CommonResponse;
import org.springframework.http.HttpStatus;

public class CommonResponse {
    private CommonResponse() {
    }

    public static <T> ApiResult<T> success(T response) {
        return new ApiResult(true, response, null);
    }

    public static <T> ApiResult<T> error(Throwable throwable, HttpStatus status) {
        return new ApiResult(false, null, new ApiError(throwable, status));
    }

    public static <T> ApiResult<T> error(String message, HttpStatus status) {
        return new ApiResult(false, null, new ApiError(message, status));
    }

    public static <T> ApiResult<T> error(ErrorCode errorCode, HttpStatus status) {
        return new ApiResult(false, null, new ApiError(errorCode, status));
    }

    public static <T> ApiResult<T> error(String message, ErrorCode errorCode, HttpStatus status) {
        return new ApiResult(false, null, new ApiError(message, errorCode, status));
    }
}

